#!/bin/bash
# mountVMDisk.sh - utlitiy to partition available disks and mount into file system.
#  mountVMDisk.sh [<mount folder> <starting%  ending%>]
#  the % parameters must be one - quote the space between the two percents.
#	the pair of mount folder and percents can be repleated.
#	the percents must not over lap and should cover the whole of the disk.
#
#	i.e.   mountVMDisk /var/log "0% 15%"  /opt "26% 100%"
#
# Chris Bentz - May 2017

echo "Provision, partition and mount the data disk to folder: $1"
# create new volunm and mount with expeted directory
(echo n; echo p; echo 1; echo ; echo ; echo w) | sudo fdisk /dev/sdc
sudo mkfs -t ext4 /dev/sdc1
sudo mkdir -p $1 && sudo mount /dev/sdc1 $1

# persist the mount point into /etc/fstab file 
idinfo=$(sudo -i blkid | grep "/dev/sdc1" | grep -o UUID=\"[^\"]*\")
uuid=$(sed 's/"//g' <<< $idinfo)
echo "$uuid   $1  ext4    defaults,nofail   1  2" |sudo tee -a /etc/fstab
