# Build number: 8.0.000.31

# Installation Identifier - every concurrent deployment needs a unique install name
variable "install_name" {
    description = "Textual Name of this CMS Install as Installation Identifier, every concurrent deployment needs a unique install name."
}

# AWS Details - where and how to create the install
variable "aws_region" {
    description = "AWS region to launch vms into."
    default = "us-west-2"
}

variable "aws_access_key" {
    description = "AWS Access Key for access to aws API."
}

variable "aws_secret_key" {
    description = "AWS Secret Key for access to aws API."
}

variable "app_count" {
    description = "Number of application nodes to deploy."
    default = "1"
}

variable "cs_count" {
    description = "Number of Cluster Service nodes to deploy."
    default = "1"
}

variable "es_count" {
    description = "Number of ElasticSearch nodes to deploy."
    default = "1"
}

variable "pt_count" {
    description = "Number of Portal nodes to deploy."
    default = "0"
}

variable "ct_count" {
    description = "Number of Content server nodes to deploy."
    default = "0"
}

variable "rds_multi_az" {
    description = "Set it true to deploy database with high availability."
    default = false
}

variable "az_count" {
    description = "Number of availability zones to spread across."
    default = 3
}

variable "dev_mode" {
    description = "Set it true to run in development mode using smaller/cheaper instance types for testing the deployment and basic functions."
    default = false
}

variable "mount_options" {
    type = "list"
    description = "Mount options for EFS."
    default = ["nolock","nfsvers=4.1"]
}

variable "remount" {
    description = "Enable/disable remount as a mount option; should remain false for EFS."
    default = false
}

variable "cms_nas_type" {
    description = "The nas type for CMS."
    default = "nfs"
}

variable "ct_nas_type" {
    description = "The nas type for CMS CT nodes."
    default = "nfs"
}

variable "cms_nas_share" {
    description = "The nas share folder for CMS."
    default = "/"
}

variable "content_nas_share" {
    description = "The nas share folder for content."
    default = "/"
}

variable "ct_cms_nas_share" {
    description = "The nas share folder for CMS."
    default = "/"
}

variable "ct_content_nas_share" {
    description = "The nas share folder for content."
    default = "/"
}

# Security Firewall configuration

variable "admin_whitelist" {
    type = "list"
    description = "Networks to allow admin connectivity from, fill with cidr format. The IP must match the company NAT rules in use to allow access to the install from the company network."
    default = ["192.168.0.0/24"]
}

# must match the company NAT rules in use to allow access to the install from the company network
variable "external_whitelist" {
    type = "list"
    description = "networks to allow external connectivity from - replace with corporate public IP address range from corporate Nat/gateway; limit to 5."
    default = ["192.168.0.0/24"]
}

variable "bastion_public_cidr" {
    type = "list"
    description = "the public IP cidr of the bastion system, used to kickstart the deployment.  This IP must be allowed in the security groups.  i.e.   dig +short myip.opendns.com @resolver1.opendns.com."
    default = ["192.168.0.0/24"]
}

variable "ui_ports" {
    type = "list"
    description = "Accessible CMS UI ports."
    default = ["21","80","8081","8443","8501","9292","9393","16443","7070","8080","8444","5672"]
}

variable "internal_lb_ports" {
    type = "list"
    description = "Internal CMS load balanced ports."
    default = ["5000","6003","7443"]
}

variable "cs_ports" {
    type = "list"
    description = "Accessible CMS ports for CS nodes."
    default = ["5601","9090"]
}

# Networking Defaults
variable "aws_vpc_cidr" {
    description = "The CIDR of the VPC to create."
    default = "10.0.0.0/16"
}

variable "aws_subnet_cidr" {
    description = "The CIDR of the Subnet to create with the VPC. All VMs are created in this subnet, which is broken up into smaller subnets for each availability zone. Must be a valid subnet of the VPC cidr."
    default = "10.0.0.0/24"
}

variable "rds_subnet_cidr" {
    description = "The CIDR of the Subnet to create with the VPC for RDS instances. Must be a valid subnet of the VPC cidr."
    default = "10.0.1.0/24"
}


# Instance Type selection for the vms
variable "aws_instance_type_cs" {
    description = "The AWS Instance Type to use for CMS Cluster Server Instances."
    default = "m4.xlarge"
}

variable "aws_instance_type_cs_dev" {
    description = "The AWS Instance Type to use for CMS Cluster Server Instances in development mode."
    default = "m4.large"
}

variable "aws_instance_type_app" {
    description = "The AWS Instance Type to use for CMS Application Server Instances."
    default = "m4.4xlarge"
}

variable "aws_instance_type_app_dev" {
    description = "The AWS Instance Type to use for CMS Application Server Instances in development mode."
    default = "m4.large"
}

variable "aws_instance_type_rds" {
    description = "The AWS Instance Type to use for AWS PostgreSQL RDS Instances."
    default = "db.m4.4xlarge"
}

variable "aws_instance_type_rds_dev" {
    description = "The AWS Instance Type to use for AWS PostgreSQL RDS Instances in development mode."
    default = "db.m4.large"
}

variable "aws_instance_type_es" {
    description = "The AWS Instance Type to use for CMS Elastic Search Server Instances."
    default = "m4.xlarge"
}

variable "aws_instance_type_es_dev" {
    description = "The AWS Instance Type to use for CMS Elastic Search Server Instances in development mode."
    default = "m4.large"
}


variable "aws_instance_type_pt" {
    description = "The AWS Instance Type to use for CMS Portal Server Instances. Install will fail if this value is lowered."
    default = "t2.medium"
}

variable "aws_instance_type_ct" {
    description = "The AWS Instance Type to use for CMS Content Server Instances."
    default = "m4.xlarge"
}



# Instance Volume Type
# select one of standard, gp2 or io1
#  standard = magnetic
#  gp2 = General Provision SSD
#  io1 = Provisioned IOPS SSD

variable "root_volume_type" {
    description = "Volume type to use on boot/root disk."
    default = "standard"
}

variable "block_volume_type" {
    description = "Volume type to use on additional file system space."
    default = "standard"
}

# Instance Disk Space expansion
# amount of additional disk space to alloate to each instances

variable "aws_instance_block_size_cs" {
    description = "Number of GB of additional space to alloate to Cluster Server instances, the recommended value for production is 300."
    default = "20"
}

variable "aws_instance_block_size_app" {
    description = "Number of GB of additional space to alloate to Application Server instances, the recommended value for production is 100."
    default = "20"
}

variable "aws_instance_block_size_es" {
    description = "Number of GB of additional space to alloate to Elastic Search Server instances, the recommended value for production is 500."
    default = "100"
}

variable "aws_instance_block_size_pt" {
    description = "Number of GB of additional space to alloate to Portal Server instances, the recommended value for production is 100."
    default = "20"
}

variable "aws_instance_block_size_ct" {
    description = "Number of GB of additional space to alloate to Content Server instances, the recommended value for production is 100."
    default = "20"
}

# NAS Backing Block Details

variable "content_nas_volume_size" {
    description = "Number of GB to allocate for content share."
    default = "100"
}

variable "content_nas_volume_type" {
    description = "Type of aws block device to allocate for content share."
    default = "standard"
}

# CMS License & Fingerprint

variable "cms_license_fingerprint" {
    description = "CMS Installation License Fingerprint, should match with the fingerprint in CMS license file."
    default = "00000000000000000000000000000000"
}

variable "license_file_path" {
    description = "Path to CMS license file."
    default = "../license.xml"
}

# Instance Hostname/domain details

variable "cms_hostname_cs" {
    description = "The hostname prefix for the Cluster Server Instance."
    default = "cms-cs"
}

variable "cms_hostname_app" {
    description = "The hostname prefix for the Application Server Instance."
    default = "cms-app"
}

variable "cms_hostname_es" {
    description = "The hostname prefix for the Elastic Search Server Instance."
    default = "cms-es"
}

variable "cms_hostname_pt" {
    description = "The hostname prefix for the Portal Server Instance."
    default = "cms-pt"
}

variable "cms_hostname_ct" {
    description = "The hostname prefix for the Content Server Instance."
    default = "cms-ct"
}

variable "cms_dns_domain" {
    description = "Network Domain name for CMS Instances."
    default = "ericsson.local"
}

variable "timezone" {
    description = "Timezone to be set in the Instances OS."
    default = "America/Los_Angeles"
}

variable "ntp1" {
    description = "First ntp server IP address."
    default = "0.rhel.pool.ntp.org"
}

variable "ntp2" {
    description = "Second ntp server IP address."
    default = "1.rhel.pool.ntp.org"
}

variable "snmp_server" {
    description = "SNMP server IP address."
    default = "127.0.0.1"
}

# Base Operation System image to install - add more regions as needed...
variable "aws_ami_product_code" {
    description = "AMI product code identifiers to use in various regions - should be CentOS 7."
    default = "aw0evgkw8e5c1q413zgy5pjce" # CentOS 7 (x86_64) - with Updates HVM
}

# SSH Key Details
# this allows ssh into the instances via keys on the bastion system.

variable "private_key_path" {
    description = "The path of the ssh private key file in the server running this terraform scripts, which will be used to configure VM instances."
    default = "~/.ssh/cms_terraform_id_rsa"
}

variable "public_key_path" {
    description = "The path of the ssh pub key file in the server running this terraform scripts, which will be used to configure VM instances."
    default = "~/.ssh/cms_terraform_id_rsa.pub"
}

variable "ssh_user" {
    description = "The user name to use for ssh to VM instances."
    default = "centos"
}

variable "rds_db_version" {
    description = "Use this to set the db version for AWS Postgresql Server instance creation."
    default = "9.5"
}

variable "rds_db_minor_version" {
    description = "Use this to set the db version for RDS instance creation."
    default = "12"
}

variable "rds_db_name" {
    description = "Use this to set the db name for AWS Postgresql Server instance creation."
    default = "ttv"
}

variable "rds_db_port" {
    description = "Use this to set the db port for AWS Postgresql Server instance creation."
    default = "5432"
}

variable "rds_db_user" {
    description = "Use this to set the db user for AWS Postgresql Server instance creation."
    default = "postgres"
}

variable "rds_db_pass" {
    description = "Use this to set the db password for AWS Postgresql Server instance creation."
    default = "n2Cdf92j"
}

variable "package_location" {
    description = "Location of CMS packages for CMS installation."
    default = "../packages"
}

####CT nodes installation
variable "cloud_ext_ct" {
    description =  "To determine whether CT nodes need to be installed inside or outside aws."
    default = false
}

variable "existing_vpc_id" {
    description = "Use the parameter to set the existing vpc id, if the values set to 0, the terraform scritps will be create a new VPC. "
    default = 0
}