resource "azurerm_storage_account" "storageaccount" {
  name                     = replace("${var.install_name}storageac","-","")
  resource_group_name      = "${azurerm_resource_group.cms-rg.name}"
  location                 = "${azurerm_resource_group.cms-rg.location}"
  account_tier             = "${var.account_tier}"
  account_replication_type = "${var.account_replication_type}"
  #enable_file_encryption   = "false"

 #network_rules {
 #  #ip_rules                   = ["${var.storage_bastion_ip}"]
 #  ip_rules                   = "${var.bastion_public_cidr}"
 #  virtual_network_subnet_ids = ["${azurerm_subnet.cms-subnet.id}"]
 #}
 
  tags = {
    environment = "${var.tag_environment}"
  }
}


resource "azurerm_storage_share" "cmsshare" {
  name = "cmsshare-${var.install_name}"
  storage_account_name = "${azurerm_storage_account.storageaccount.name}"
  quota = "${var.storage_share_quota}"
}

resource "azurerm_storage_share_directory" "cmsfolder" {
  name                 = "cmsfolder-${var.install_name}"
  share_name           = "${azurerm_storage_share.cmsshare.name}"
  storage_account_name = "${azurerm_storage_account.storageaccount.name}"
}

resource "azurerm_storage_share_directory" "contentfolder" {
  name                 = "contentfolder-${var.install_name}"
  share_name           = "${azurerm_storage_share.cmsshare.name}"
  storage_account_name = "${azurerm_storage_account.storageaccount.name}"
}

resource "azurerm_storage_share_directory" "backupfolder" {
  name                 = "backupfolder-${var.install_name}"
  share_name           = "${azurerm_storage_share.cmsshare.name}"
  storage_account_name = "${azurerm_storage_account.storageaccount.name}"
}

resource "azurerm_storage_share_directory" "ctcmsfolder" {
  name                 = "ctcmsfolder-${var.install_name}"
  share_name           = "${azurerm_storage_share.cmsshare.name}"
  storage_account_name = "${azurerm_storage_account.storageaccount.name}"
}

resource "azurerm_storage_share_directory" "ctcontentfolder" {
  name                 = "ctcontentfolder-${var.install_name}"
  share_name           = "${azurerm_storage_share.cmsshare.name}"
  storage_account_name = "${azurerm_storage_account.storageaccount.name}"
}


output "storageaccount_name" {
    value = "${azurerm_storage_account.storageaccount.name}"
}
output "storageaccount_accesskey" {
    value = "${azurerm_storage_account.storageaccount.primary_access_key}"
}

output "cmsshareurl" {
    value = "${azurerm_storage_share.cmsshare.url}"
}

output "cmsfolderid" {
    value = "${azurerm_storage_share_directory.cmsfolder.id}"
}

output "contentfolderid" {
    value = "${azurerm_storage_share_directory.contentfolder.id}"
}

output "backupfolderid" {
    value = "${azurerm_storage_share_directory.backupfolder.id}"
}

output "ctcmsfolderid" {
    value = "${azurerm_storage_share_directory.ctcmsfolder.id}"
}

output "ctcontentfolderid" {
    value = "${azurerm_storage_share_directory.ctcontentfolder.id}"
}
