# Build number: 8.0.000.21

# CMS Configuration config.json files
resource "template_dir" "config" {
    source_dir = "../config_templates"
    destination_dir = "${path.cwd}/config"
    depends_on = [azurerm_storage_share_directory.cmsfolder, azurerm_storage_share_directory.contentfolder, azurerm_storage_share_directory.ctcmsfolder, azurerm_storage_share_directory.ctcontentfolder]

    vars = {
        customerLicenseId = "${var.cms_license_fingerprint}"
        privateNetmask = "${cidrnetmask(var.cms_private_cidr)}"
        # use azure internal DNS
        vpc_dns = "${var.azure_dns}"
        consul_servers = "${var.cs_count >= 3 ? "\"cs1\",\"cs2\",\"cs3\"" : "\"cs1\"" }"
        named_master = "${element(flatten(azurerm_network_interface.cs_nic.*.private_ip_addresses), 0)}"
        named_slaves = "${jsonencode(slice(flatten(azurerm_network_interface.cs_nic.*.private_ip_addresses), 1, length(flatten(azurerm_network_interface.cs_nic.*.private_ip_addresses))))}"
        cms_nas_type          = "cifs"
        cms_nas_server        = replace(azurerm_storage_share_directory.cmsfolder.id, "https:", "")
        cms_nas_share         = ""
        content_nas_server    = replace(azurerm_storage_share_directory.contentfolder.id, "https:", "")
        content_nas_share     = ""
        ct_nas_type           = "cifs"
        ct_cms_nas_server     = replace(azurerm_storage_share_directory.ctcmsfolder.id, "https:", "")
        ct_cms_nas_share      = ""
        ct_content_nas_server = replace(azurerm_storage_share_directory.ctcontentfolder.id, "https:", "")
        ct_content_nas_share  = ""
        mountOptions          = "vers=3.0,username=${azurerm_storage_account.storageaccount.name},password=${azurerm_storage_account.storageaccount.primary_access_key},dir_mode=0755,file_mode=0755,uid=99,gid=99,soft,mfsymlinks"
        remount               = true
        privateDomain = "${var.cms_dns_domain}"
##TODO - add load balancer when done (using )
        ui_eip = "${azurerm_public_ip.ui_ip.fqdn}"
        app_eip = "${azurerm_public_ip.ui_ip.fqdn}"
        timezone = "${var.timezone}"
        dbserver = "${azurerm_postgresql_server.edb1.fqdn}"
        snmpServer = "${var.snmp_server}"
        privateNetwork = "${cidrhost(var.cms_private_cidr,0)}"
        customerInstanceId = "${var.customerInstanceId}"
        installName = "${var.install_name}"
        cloudextct = "${var.cloud_ext_ct ? true : false}"
        hasct = "${((var.ct_count > 0 ? 1: 0) + (var.cloud_ext_ct ? 1: 0 )) >= 1 ? true: false}"
     }
}
