# Build number: 8.0.000.26


variable "install_name" {
    description = "Textual Name of this CMS Install as Installation Identifier, every concurrent deployment needs a unique install name."
}

variable "tag_environment" {
    description = "Environment tag, Staging or Production."
    default = "Staging"
}

# Azure Details - where and how to create the install
variable "azure_region" {
    description = "Azure region to launch VMs into."
    default = "westeurope"
}

variable "subscription_id" {
    description = "Resources will be created under this Azure subscription."
}

variable "tenant_id" {
    description = "Resources will be created under this Azure tenant."
}

variable "client_id" {
    description = "Client ID used for Azure Resource Managerment API access."
}

variable "client_secret" {
    description = "Client Secret used for Azure Resource Managerment API access."
}

variable "app_count" {
    description = "Number of application nodes to deploy."
    default = 1
}

variable "cs_count" {
    description = "Number of Cluster Service nodes to deploy."
    default = 1
}

variable "es_count" {
    description = "Number of ElasticSearch nodes to deploy."
    default = 1
}

variable "pt_count" {
    description = "Number of Portal nodes to deploy."
    default = 0
}

variable "ct_count" {
    description = "Number of Content nodes to deploy."
    default = 0
}

variable "dev_mode" {
    description = "True to run in development mode using smaller/cheaper instance types for testing the deployment and basic functions."
    default = false
}

# Networking Defaults
variable "cms_private_cidr" {
    description = "The CIDR of the Subnet to create with the VPC. All VMs are created in this subnet, which is broken up into smaller subnets for each availability zone. Must be a valid subnet of the VPC cidr."
    default = "10.0.0.0/24"
}
# Security Firewall configuration
variable "admin_whitelist" {
    description = "Networks to allow admin connectivity from, fill with cidr format. External CT node IP should be included in this whitelist. The IP must match the company NAT rules in use to allow access to the install from the company network."
    default = ["10.0.0.0/24"]
}

variable "external_whitelist" {
    description = "Networks to allow external connectivity from, for UI access only. The IP must match the company NAT rules in use to allow access to the install from the company network."
    default = ["10.0.0.0/24"]
}

variable "ui_ports" {
    description = "Accessible CMS UI ports."
    default = ["8443","16443"]
}
variable "external_access_ports" {
    description = "CMS load balanced ports for external access."
    default = ["80","5000","7070","7443","8080","8081","8444","8501","9292","9393","5672","5671"]
}
variable "prepack_ports" {
    description = "CMS load balanced ports for Prepack solution."
    default = ["21","6003"]
}
variable "cs_ports" {
    description = "Accessible CMS ports for CS nodes."
    default = ["5601","9090","9200"]
}

# Instance Type selection for the vms
variable "instance_type_cs" {
    description = "The Instance Type to use for CMS Cluster Server Instances."
    default = "Standard_E8_v3"
}

variable "instance_type_cs_dev" {
    description = "The Instance Type to use for CMS Cluster Server Instances in development mode."
    default = "Standard_E2_v3"
}

variable "instance_type_app" {
    description = "The Instance Type to use for CMS Application Server Instances."
    default = "Standard_E16_v3"
}

variable "instance_type_app_dev" {
    description = "The Instance Type to use for CMS Application Server Instances in development mode."
    default = "Standard_E2_v3"
}

variable "azure_db_cpus" {
    description = "The number of CPUs to allocate for Azure Database for PostgreSQL Instance."
    default = "16"
}

variable "azure_db_cpus_dev" {
    description = "The number of CPUs to allocate for Azure Database for PostgreSQL Instance in development mode."
    default = "2"
}

variable "instance_type_es" {
    description = "The Instance Type to use for CMS Elastic Search Server Instances."
    default = "Standard_E4_v3"
}

variable "instance_type_es_dev" {
    description = "The Instance Type to use for CMS Elastic Search Server Instances in development mode."
    default = "Standard_E2_v3"
}

variable "instance_type_pt" {
    description = "The Instance Type to use for CMS Portal Server Instances."
    default = "Standard_E2_v3"
}

variable "instance_type_pt_dev" {
    description = "The Instance Type to use for CMS Portal Server Instances in development mode."
    default = "Standard_E2_v3"
}

variable "instance_type_ct" {
    description = "The Instance Type to use for CMS Content Server Instances."
    default = "Standard_E16_v3"
}

variable "instance_type_ct_dev" {
    description = "The Instance Type to use for CMS Content Server Instances in development mode."
    default = "Standard_E2_v3"
}


variable "root_volume_type" {
    description = "Volume type to use on boot/root disk"
    default = "Standard_LRS"
}

variable "block_volume_type" {
    description = "Volume type to use on additional file system space"
    default = "Standard_LRS"
}

variable "delete_disks_on_termination" {
    description = "True to delete the disks (OS and data) when the VM is destroyed."
    default = "true"
}

# Instance Disk Space expansion
# amount of additional disk space to alloate to each instances

variable "instance_block_size_cs_dev" {
    description = "Number of GB of additional space to alloate to Cluster Server instances in dev mode."
    default = "20"
}

variable "instance_block_size_cs" {
    description = "Number of GB of additional space to alloate to Cluster Server instances."
    default = "500"
}

variable "instance_block_size_app_dev" {
    description = "Number of GB of additional space to alloate to Application Server instances in dev mode."
    default = "30"
}

variable "instance_block_size_app" {
    description = "Number of GB of additional space to alloate to Application Server instances."
    default = "300"
}

variable "instance_block_size_es_dev" {
    description = "Number of GB of additional space to alloate to Elastic Search Server instances in dev mode."
    default = "20"
}

variable "instance_block_size_es" {
    description = "Number of GB of additional space to alloate to Elastic Search Server instances."
    default = "500"
}

variable "instance_block_size_pt_dev" {
    description = "Number of GB of additional space to alloate to Portal Server instances in dev mode."
    default = "200"
}

variable "instance_block_size_pt" {
    description = "Number of GB of additional space to alloate to Portal Server instances."
    default = "20"
}

variable "instance_block_size_ct_dev" {
    description = "Number of GB of additional space to alloate to Content Server instances in dev mode."
    default = "20"
}

variable "instance_block_size_ct" {
    description = "Number of GB of additional space to alloate to Content Server instances."
    default = "300"
}

# CMS License & Fingerprint

variable "cms_license_fingerprint" {
    description = "CMS Installation License Fingerprint, should match with the fingerprint in CMS license file."
    default = "00000000000000000000000000000000"
}

variable "customerInstanceId" {
    description = "A value used internally - not in use any more."
    default = "cms"
}

variable "license_file_path" {
    description = "Path to CMS license file."
    default = "../license.xml"
}

# Instance Hostname/domain details

variable "cms_hostname_cs" {
    description = "The hostname prefix to be set for the Cluster Server Instance."
    default = "cms-cs"
}

variable "cms_hostname_app" {
    description = "The hostname prefix to be set for the Application Server Instance."
    default = "cms-app"
}

variable "cms_hostname_es" {
    description = "The hostname prefix to be set for the Elastic Search Server Instance."
    default = "cms-es"
}

variable "cms_hostname_pt" {
    description = "The hostname prefix to be set for the Portal Server Instance."
    default = "cms-pt"
}

variable "cms_hostname_ct" {
    description = "The hostname prefix to be set for the Content Server Instance."
    default = "cms-ct"
}

variable "cms_dns_domain" {
    description = "Network Domain name for CMS Instances."
    default = "mediakind.local"
}

variable "timezone" {
    description = "Timezone to be set in the Instances OS."
    default = "America/Los_Angeles"
}

variable "ntp1" {
    description = "First ntp server IP address."
    default = "0.rhel.pool.ntp.org"
}

variable "ntp2" {
    description = "Second ntp server IP address."
    default = "1.rhel.pool.ntp.org"
}

variable "snmp_server" {
    description = "SNMP server IP address."
    default = "127.0.0.1"
}

# SSH Key Details
# this allows ssh into the instances via keys on the bastion system.

variable "private_key_path" {
    description = "The path of the ssh private key file in the server running this terraform scripts, which will be used to configure VM instances."
    default = "~/.ssh/cms_terraform_id_rsa"
}

variable "public_key_path" {
    description = "The path of the ssh pub key file in the server running this terraform scripts, which will be used to configure VM instances."
    default = "~/.ssh/cms_terraform_id_rsa.pub"
}

variable "ssh_user" {
    description = "The user name to use for ssh to VM instances."
    default = "centos"
}

variable "ssh_user_password" {
    description = "Password set when creating ssh_user, only take effect when login with password is allowed."
    default = "CmsOnAzureAdm1n!"
}

variable "rds_db_version" {
    description = "Use this to set the db version for Azure Postgresql Server instance creation."
    default = "9.5"
}

variable "rds_db_name" {
    description = "Use this to set the db name for Azure Postgresql Server instance creation."
    default = "ttv"
}

variable "rds_db_port" {
    description = "Use this to set the db port for Azure Postgresql Server instance creation."
    default = "5432"
}

variable "rds_db_user" {
    description = "Use this to set the db user for Azure Postgresql Server instance creation."
    default = "postgres"
}

variable "rds_db_pass" {
    description = "Use this to set the db password for Azure Postgresql Server instance creation."
    default = "CmsAzureDbAdm1n!"
}

variable "package_location" {
    description = "Location of CMS packages for CMS installation."
    default = "../packages"
}


###############   Azure Variables ###################

###Azure OS references###

variable "os_publisher" {
    description = "Publisher property for OS Image Reference."
    default = "OpenLogic"
}

variable "os_offer" {
    description = "Offer property for OS Image Reference."
    default = "CentOS"
}

variable "os_sku" {
    description = "Sku property for OS Image Reference."
    default = "7.7"
}

variable "os_version" {
    description = "Version property for OS Image Reference."
    default = "latest"
}

variable "azure_dns" {
    description = "Azure DNS to use as forwarder."
    default = "168.63.129.16"
}

###Azure Storage File Share references###
variable "account_tier" {
    description = "Defines the Tier to use for this storage account. Valid options are Standard and Premium. Changing this forces a new resource to be created."
    default = "Standard"
}

variable "account_replication_type" {
    description = "Defines the type of replication to use for this storage account. Valid options are LRS, GRS, RAGRS and ZRS."
    default = "LRS"
}


variable "storage_share_quota" {
    description = "The maximum size of the share, in gigabytes. Must be greater than 0, and less than or equal to 5 TB (5120 GB)."
    default = "100"
}

####CT nodes installation
variable "cloud_ext_ct" {
    description =  "To determine whether CT nodes are installed inside or outside Azure."
    default = false
}

###Availability Set
variable "platform_fault_domain_count" {
    description =  "To determine the platform fault domain count."
    default = "2"
}
variable "platform_update_domain_count" {
    description =  "To determine the platform update domain count."
    default = "5"
}
