#####Configure external LB##########
resource "azurerm_public_ip" "ui_ip" {
    name                         = "${var.install_name}-ui_ip"
    location                     = "${azurerm_resource_group.cms-rg.location}"
    resource_group_name          = "${azurerm_resource_group.cms-rg.name}"
    allocation_method            = "Static"
    domain_name_label             = "ui-ip-${var.install_name}"

    tags = {
        environment = "${var.tag_environment}"
    }
}

resource "azurerm_lb" "ext" {
  name                = "${var.install_name}-ext"
  location              = "${azurerm_resource_group.cms-rg.location}"
  resource_group_name   = "${azurerm_resource_group.cms-rg.name}"
  frontend_ip_configuration {
    name      = "${var.install_name}-ext-frontend-ip"
#    subnet_id = "${azurerm_subnet.cms-subnet.id}"
    public_ip_address_id = "${azurerm_public_ip.ui_ip.id}"
  }
}

resource "azurerm_lb_backend_address_pool" "ext-backend" {
  resource_group_name = "${azurerm_resource_group.cms-rg.name}"
  loadbalancer_id     = "${azurerm_lb.ext.id}"
  name                = "ext-backend"
}

resource "azurerm_network_interface_backend_address_pool_association" "ext-backend-pool" {
  count = "${var.cs_count}"
  network_interface_id    = "${element(azurerm_network_interface.cs_nic.*.id,count.index)}"
  ip_configuration_name   = "${element(azurerm_network_interface.cs_nic[*].ip_configuration[0].name,count.index)}"
  backend_address_pool_id = "${azurerm_lb_backend_address_pool.ext-backend.id}"
  depends_on = ["azurerm_network_interface.cs_nic"]
}

resource "azurerm_lb_probe" "ext-probe" {
  resource_group_name = "${azurerm_resource_group.cms-rg.name}"
  loadbalancer_id     = "${azurerm_lb.ext.id}"
  name                = "${element(concat(var.ui_ports,var.external_access_ports,var.prepack_ports,var.cs_ports), count.index)}"
  port                = "${element(concat(var.ui_ports,var.external_access_ports,var.prepack_ports,var.cs_ports), count.index)}"
  count               = "${length(concat(var.ui_ports,var.external_access_ports,var.prepack_ports,var.cs_ports))}"
}
resource "azurerm_lb_rule" "ext-rule" {
  count                          = "${length(concat(var.ui_ports,var.external_access_ports,var.prepack_ports,var.cs_ports))}"
  resource_group_name            = "${azurerm_resource_group.cms-rg.name}"
  loadbalancer_id                = "${azurerm_lb.ext.id}"
  name                           = "${element(concat(var.ui_ports,var.external_access_ports,var.prepack_ports,var.cs_ports), count.index)}"
  protocol                       = "Tcp"
  frontend_port                  = "${element(concat(var.ui_ports,var.external_access_ports,var.prepack_ports,var.cs_ports), count.index)}"
  backend_port                   = "${element(concat(var.ui_ports,var.external_access_ports,var.prepack_ports,var.cs_ports), count.index)}"
  frontend_ip_configuration_name = "${azurerm_lb.ext.frontend_ip_configuration[0].name}"
  backend_address_pool_id        = "${azurerm_lb_backend_address_pool.ext-backend.id}"
  probe_id                       = "${element(azurerm_lb_probe.ext-probe.*.id, count.index)}"
}