#!/bin/bash
# Add rules
#set_ip_forward.sh <IP_need_forward> <IP_forward_to> <source_port1:dest_port1,source_port2:dest_port2,...>
# Remove rules
#set_ip_forward.sh <IP_need_forward> <IP_forward_to> <source_port1:dest_port1,source_port2:dest_port2,...> delete

DESTIP=$1
FORWARDIP=$2
PORTMAPS=($(echo $3 | tr "," "\n"))
DELETERULE=${4:-no}

#Start and enable the firewall service
systemctl start firewalld
systemctl enable firewalld

echo portmaps is ${PORTMAPS[@]}

if [ $DELETERULE == "delete" ];then
  for PORTMAP in ${PORTMAPS[@]}
  do
    #SOURCE_PORT=$(sed 's/-/:/g' <<< ${PORTMAP%%:*})
    SOURCE_PORT=${PORTMAP%%:*}
    DEST_PORT=${PORTMAP##*:}
    echo "[Info] Removing forward rule $1:$SOURCE_PORT --> $2:$DEST_PORT"
	if [[ $SOURCE_PORT =~ - ]]; then
      a1=${SOURCE_PORT%%-*}
      a2=${SOURCE_PORT##*-}
      b1=${DEST_PORT%%-*}
      b2=${DEST_PORT##*-}
      for (( i=$a1,j=$b1; i<=$a2; i++,j++ ))
      do
        echo "[Info] Removing forward rule $1:$i --> $2:$j" 
        firewall-cmd --permanent --direct --remove-rule ipv4 nat OUTPUT 0 -d $1 -p tcp --dport $i -j DNAT --to-destination $2:$j
      done
    else
      firewall-cmd --permanent --direct --remove-rule ipv4 nat OUTPUT 0 -d $1 -p tcp --dport $SOURCE_PORT -j DNAT --to-destination $2:$DEST_PORT
    fi
  done
else
  for PORTMAP in ${PORTMAPS[@]}
  do
    #SOURCE_PORT=$(sed 's/-/:/g' <<< ${PORTMAP%%:*})
    SOURCE_PORT=${PORTMAP%%:*}
    DEST_PORT=${PORTMAP##*:}
    echo "[Info] Forwarding $1:$SOURCE_PORT --> $2:$DEST_PORT"
	if [[ $SOURCE_PORT =~ - ]]; then
      a1=${SOURCE_PORT%%-*}
      a2=${SOURCE_PORT##*-}
      b1=${DEST_PORT%%-*}
      b2=${DEST_PORT##*-}
      for (( i=$a1,j=$b1; i<=$a2; i++,j++ ))
      do
        echo "[Info] Forwarding $1:$i --> $2:$j" 
        firewall-cmd --permanent --direct --add-rule ipv4 nat OUTPUT 0 -d $1 -p tcp --dport $i -j DNAT --to-destination $2:$j
      done
    else
      firewall-cmd --permanent --direct --add-rule ipv4 nat OUTPUT 0 -d $1 -p tcp --dport $SOURCE_PORT -j DNAT --to-destination $2:$DEST_PORT
    fi
  done
fi  
firewall-cmd --reload
systemctl restart firewalld