#Enable daily backup for all VMs

resource "azurerm_recovery_services_vault" "recovery-vault" {
  name                = "${var.install_name}-recovery-vault"
  location            = "${azurerm_resource_group.cms-rg.location}"
  resource_group_name = "${azurerm_resource_group.cms-rg.name}"
  sku                 = "Standard"
  #var.vault_soft_delete
  soft_delete_enabled = false
}

resource "azurerm_backup_policy_vm" "vmbackup-policy" {
  name                = "${var.install_name}-vmbackup-policy"
  resource_group_name = "${azurerm_resource_group.cms-rg.name}"
  recovery_vault_name = "${azurerm_recovery_services_vault.recovery-vault.name}"

  timezone = "UTC"
  backup {
    frequency = "Weekly"
    time      = "02:00"
    weekdays = ["Tuesday"]
  }
  #retention_daily {
  #  count = 7
  #}
  retention_weekly {
    count    = 5
    weekdays = ["Tuesday"]
  }
}

resource "azurerm_backup_protected_vm" "cs" {
  count = "${var.cs_count}"
  depends_on = ["azurerm_virtual_machine.cs"]
  resource_group_name = "${azurerm_resource_group.cms-rg.name}"
  recovery_vault_name = "${azurerm_recovery_services_vault.recovery-vault.name}"
  source_vm_id        = "${azurerm_virtual_machine.cs[count.index].id}"
  backup_policy_id    = "${azurerm_backup_policy_vm.vmbackup-policy.id}"
}

resource "azurerm_backup_protected_vm" "app" {
  count = "${var.app_count}"
  depends_on = ["azurerm_virtual_machine.app"]
  resource_group_name = "${azurerm_resource_group.cms-rg.name}"
  recovery_vault_name = "${azurerm_recovery_services_vault.recovery-vault.name}"
  source_vm_id        = "${azurerm_virtual_machine.app[count.index].id}"
  backup_policy_id    = "${azurerm_backup_policy_vm.vmbackup-policy.id}"
}

resource "azurerm_backup_protected_vm" "es" {
  count = "${var.es_count}"
  depends_on = ["azurerm_virtual_machine.es"]
  resource_group_name = "${azurerm_resource_group.cms-rg.name}"
  recovery_vault_name = "${azurerm_recovery_services_vault.recovery-vault.name}"
  source_vm_id        = "${azurerm_virtual_machine.es[count.index].id}"
  backup_policy_id    = "${azurerm_backup_policy_vm.vmbackup-policy.id}"
}

resource "azurerm_backup_protected_vm" "pt" {
  count = "${var.pt_count}"
  depends_on = ["azurerm_virtual_machine.pt"]
  resource_group_name = "${azurerm_resource_group.cms-rg.name}"
  recovery_vault_name = "${azurerm_recovery_services_vault.recovery-vault.name}"
  source_vm_id        = "${azurerm_virtual_machine.pt[count.index].id}"
  backup_policy_id    = "${azurerm_backup_policy_vm.vmbackup-policy.id}"
}

resource "azurerm_backup_protected_vm" "ct" {
  count = "${var.ct_count}"
  depends_on = ["azurerm_virtual_machine.ct"]
  resource_group_name = "${azurerm_resource_group.cms-rg.name}"
  recovery_vault_name = "${azurerm_recovery_services_vault.recovery-vault.name}"
  source_vm_id        = "${azurerm_virtual_machine.ct[count.index].id}"
  backup_policy_id    = "${azurerm_backup_policy_vm.vmbackup-policy.id}"
}
