## CMS Terraform scripts for AZURE deployment.

### Overview
The Terraform scripts provision a set of resources in AZURE Cloud Platform and install the CMS.
* Azure Resources provisioned by the scripts include:
  * Azure virtual network for CMS.
  * Azure security group and security rules.
  * Availability sets for CS nodes, APP nodes, ES nodes, PT nodes, CT nodes.
  * Azure linux VM instances for CS nodes, APP nodes, ES nodes, PT nodes, CT nodes.
  * Azure storage share as CMS internal NAS.
  * Azure postgresql server instance as CMS DB.
  * Azure public dynamic IPs for CS nodes, APP nodes, ES nodes, PT nodes, CT nodes.
  * Azure public dynamic IP as CMS external VIP.
  * Azure load balancer.
  * Azure load balancer probes.
  * Azure load balancer rules.

### Prerequisites
1. User should have basic knowledge about [terraform cli](https://www.terraform.io/docs/commands/index.html).
2. User should have advanced knowledge about Linux OS operations.
3. Azure subscription id is ready for deploying CMS.
4. Azure [tenant id](https://docs.microsoft.com/en-us/azure/active-directory/fundamentals/active-directory-access-create-new-tenant) is ready for deploying CMS.
* Project team should be responsible for providing the subscription id and tenant id.
5. Azure [client id and client secret](https://www.terraform.io/docs/providers/azurerm/guides/service_principal_client_secret.html) are ready for deploying CMS.
* For more detail about client id and client secret, please refer to [how to create Azure service principal](https://docs.microsoft.com/en-us/azure/active-directory/develop/howto-create-service-principal-portal)

### Required CMS Installation Packages
* CMS Software Packages RPM (cms-swo-repo-x.x.xxx.xxx-0.el7.noarch.rpm).
* CMS Installer RPM (cmsinstaller-x.x.xxx.xx-0.noarch.rpm).
* CMS Terraform Scripts (cmsform-azure-x.x.xxx.xx.tar.gz).

### Steps for deploying CMS on Azure
**1. Prepare terraform in a machine.**
   * Acquire a CentOS linux machine which can access public internet, this machine can be a VM or a metal machine.  
   * Login to the machine and install terraform v0.12 follow the [terraform guide](https://www.terraform.io/downloads.html).

**2. Prepare the CMS terraform scripts.**
   * Put cmsform-azure-x.x.xxx.xx.tar.gz to the machine and extract this gz file.
```bash
tar -xvzf cmsform-azure-x.x.xxx.xx.tar.gz
```
   <br>You will get a new folder ***cmsform*** with below subfolders.
   *<br> - AZURE*
   *<br> - config_templates*
   *<br> - vmTools*
   *<br> - scripts*

**3. Prepare the CMS RPMs.**
   * Put below CMS RPMs to the machine by SCP or FTP or any other physical method.
   *<br> - CMS Software Packages RPM*
   *<br> - CMS Installer RPM*
   * Move the rpms to a dedicated folder
   <br>*For example, /home/packages*
   <br>**Note:**  *Make sure this folder can be accessed by user running the terraform scripts.*
   * Update the full path of this folder into field ***package_location*** in the [customized deployment variable file](#samplevariablesfile).

**4. Prepare the CMS license file.**
   * Get CMS license.xml file and put the file to the machine under the folder *cmsform* created in step 2.
   * Update the License Fingerprint into field ***cms_license_fingerprint*** in the [customized deployment variable file](#samplevariablesfile).

**5. Prepare the SSH key files.**
   * Create SSH key pair based on user's own security requirement. User can refer to [Generate a New SSH Key](https://www.ssh.com/ssh/keygen) for some information.
   * Put the generated key file and key.pub file to the machine under the folder *cmsform* created in step 2.
   <br>*Key pare example: cms-ssh-key, cms-ssh-key.pub*
   * Update the full path of the key pair files into fields ***private_key_path*** and ***public_key_path*** in the [customized deployment variable file](#samplevariablesfile).

**6. Prepare the customized deployment variable file.**
   * Create a \<anyname\>.tfvars file, e.g. ~/cmsform/AZURE/sample.tfvars.
   <br>*Refer to section [Variables](#variables) for all available variables.*
   <br>*- Pay attention to those variables that need customized.*
   <br>*Read below sections to decide the values for significant variables.*
   *<br> - [Recommanded VM size](#recommanded-vm-size)*
   *<br> - [About Regions](#about-regions)*
   *<br> - [About Storage](#about-storage)*
   *<br> - [About External CT node](#about-external-ct-node)*
   *<br><a name="samplevariablesfile">Example tfvars file as below.</a>*
```bash
#vi ~/cmsform/AZURE/sample.tfvars
install_name     = "cmsproductc"
tag_environment  = "PRODUCT-C"
subscription_id  = "xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx"
client_id        = "xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx"
client_secret    = "xxxxxxxxxxxxxxxxxxxxxxxxxx"
tenant_id        = "xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx"
azure_region     = "westeurope"
package_location = "/home/packages"
private_key_path = "/home/cmsform/cms-ssh-key"
public_key_path  = "/home/cmsform/cms-ssh-key.pub"
admin_whitelist    = ["10.111.1.1"]
external_whitelist = [ "198.24.0.0/24","198.24.8.0/23","10.111.1.2/32"]
cms_license_fingerprint = "01234567890123456789012345678901"
cs_count  = 2
app_count = 2
es_count  = 2
ct_count  = 0
pt_count  = 0
cloud_ext_ct = true
storage_share_quota = "100"
```

**7. Run scripts to deploy CMS.**
   * Login to the machine and change to the terraform scripts directory
```bash
#e.g.
cd ~/cmsform/AZURE
```
   * Make sure the customized deployment variable file, *e.g. sample.tfvars*, is inside this folder as well. 
   * Run scripts with below commands.
```bash
sudo terraform init -upgrade
sudo terraform plan -var-file=sample.tfvars -out=azurecms.tfplan
sudo terraform apply azurecms.tfplan
```

**8. Check resources created and login CS1 node.**
   * From Azure portal, all CMS resources are created under Resource Group named as *<install_name>-cms-resourcegroup*.
   * Click the "Public IP Address" resource name *public-ip-cs1-<install_name>* to get the IP address for CS1 node.
   <br>User can then login CS1 node with ssh command, with password defined in variable *ssh_user_password*.
``` bash
ssh <ssh_user>@<CS1_IP_Address>
```

**9. (Optional) Start all cms services from CS1 node after cms and all CT nodes installation finished.**
   * This step is only necessary when there is CT node deployed, either internal or external CT node.
   * Login CS1 node with the installer user and start all cms services with below command.
```bash
service cms-cluster start -f
```

**10. Login CMS UI.**
   * From Azure portal, click the "Load Balancer" resource name *<install_name>-ext* to get the IP address for CMS VIP.
   <br>User can then browse to CMS UI with this VIP.
``` bash
https://<Load_Balancer_IP_Address>:8443/portal
```

### Recommanded VM size
   * Set variable ***dev_mode*** to `false` will use the recommanded VM size for production deployment.
   * For more VM size information, refer to [Sizes for Linux virtual machines in Azure](https://docs.microsoft.com/en-us/azure/virtual-machines/linux/sizes).
   * CMS VM size related variables recommanded value for Azure production deployment as below.

Variable|Value
:-|:-
instance_type_cs|"Standard_E4_v3"
instance_type_app|"Standard_E16_v3"
instance_type_es|"Standard_E4_v3"
instance_type_pt|"Standard_E2_v3"
instance_type_ct|"Standard_E8_v3"
azure_db_cpus|"16"
instance_block_size_cs|"500"
instance_block_size_app|"150"
instance_block_size_es|"500"
instance_block_size_pt|"150"
instance_block_size_ct|"150"

   * Setting variable ***dev_mode*** to `true` will use the minimum VM sizing value to setup CMS with all CMS provided functions but low capacity and slow performance.
   * The following table lists the minimum VM sizing values for installing CMS on Azure platform.

Variable|Value
:-|:-
instance_type_cs_dev|"Standard_E2_v3"
instance_type_app_dev|"Standard_E2_v3"
instance_type_es_dev|"Standard_E2_v3"
instance_type_pt_dev|"Standard_E2_v3"
instance_type_ct_dev|"Standard_E2_v3"
azure_db_cpus_dev|"2"
instance_block_size_cs_dev|"20"
instance_block_size_app_dev|"30"
instance_block_size_es_dev|"20"
instance_block_size_pt_dev|"20"
instance_block_size_ct_dev|"20"

### About Regions
   * Azure operates in multiple datacenters around the world. These datacenters are grouped in to geographic regions, giving you flexibility in choosing where to build your applications. For more detail, refer to [Regions for virtual machines in Azure](https://docs.microsoft.com/en-us/azure/virtual-machines/linux/regions).
   * Choose the desired region and set the value in variable ***azure_region***.


### About Storage
   * CMS is using Azure Storage Share as internal shared storage, mainly used for storing CMS configration files and Content files.
   * Variable ***storage_share_quota*** determine the size allocated for the shared storage, the unit is GB, default is 100 and maximum value is 5120 (5TB).
   * This shared storage is not for external CT nodes. External CT nodes are using On-Premise NAS server inside customer site as shared storge. When CMS is deployed with external CT node, media content files are not stored in this Azure internal shared storage, use the default value, 100GB, is sufficient.


### About External CT node
   * **Related variables**
   <br>Set ***ct_count*** with `0` and ***cloud_ext_ct*** to `ture` when CMS is to be deployed with external CT nodes.
   <br>Make sure the IPs of external CT nodes are included in variable ***admin_whitelist***.
   * **External CT node Installation** 
   <br>After CMS is deployed in Azure successfully, follow the steps in Installation Guide section *Deploying CT Node Outside Clouds* to install external CT nodes.
   * **NAT**
   <br>Since external CT node is deployed inside customer's data-center, it could be behind a firewall and exported with a natted IP. In such case, user need to enable the firewalld service in all CS nodes and APP nodes and configure some firewall rules to route the outgoing messages to the CT node's natted IP.
   <br>Refer to Installation Guide section *Configuring Iptables NAT Rules (Optional)* for setting up the firewall rules on CS and APP nodes.
   * **Firewall Ports**
   <br>The external CT nodes should have below ports (TCP by default) opened for CS and APP nodes.

Service|Cloud resource|Cloud Port|Direction|Firewall Port|OnPremise Node
:-|:-|:-|:-:|:-|:-
Consul|External LB|8501|<-----|XX|Content Server
Workflow|External LB|7070|<-----|XX|Content Server
Elasticsearch|External LB|9200|<-----|XX|Content Server
Kibana|External LB|9292|<-----|XX|Content Server
RPM-Repo|External LB|8008|<-----|XX|Content Server
Redis|External LB|6379|<-----|XX|Content Server
RabbitMQ|External LB|5672|<-----|XX|Content Server
DNS|External LB|53(TCP and UDP)|<-----|XX|Content Server
cmstomcat|CS nodes|XX|----->|8081|Content Server
cms|CS nodes|XX|----->|8444|Content Server
FTP|CS nodes|XX|----->|21|Content Server
FTP|CS nodes|XX|----->|10000-10199|Content Server
ADI|CS nodes|XX|----->|5000|Content Server
cmstomcat|APP nodes|XX|----->|8081|Content Server
cms|APP nodes|XX|----->|8444|Content Server


### Variables

Variable Name|Description|Default Value|Need Customized
:-|:-|:-|:-
install_name|Textual Name of this CMS Install as Installation Identifier, every concurrent deployment needs a unique install name."|""|*
tag_environment|Environment tag, Staging or Production.|"Staging"|
azure_region|Azure region to launch VMs into.|"westeurope"|*
subscription_id|Resources will be created under this Azure subscription."|""|*
tenant_id|Resources will be created under this Azure tenant."|""|*
client_id|Client ID used for Azure Resource Managerment API access."|""|*
client_secret|Client Secret used for Azure Resource Managerment API access."|""|*
app_count|Number of application nodes to deploy.|1|*
cs_count|Number of Cluster Service nodes to deploy.|1|*
es_count|Number of ElasticSearch nodes to deploy.|1|*
pt_count|Number of Portal nodes to deploy.|0|*
ct_count|Number of Content nodes to deploy.|0|*
cloud_ext_ct|To determine whether CT nodes are installed inside or outside Azure.|false|*
dev_mode|True to run in development mode using smaller/cheaper instance types for testing the deployment and basic functions.|false|
cms_private_cidr|The CIDR of the Subnet to create with the VPC. All VMs are created in this subnet, which is broken up into smaller subnets for each availability zone. Must be a valid subnet of the VPC cidr.|"10.0.0.0/24"|
admin_whitelist|Networks to allow admin connectivity from, fill with cidr format. External CT node IP should be included in this whitelist. The IP must match the company NAT rules in use to allow access to the install from the company network.|["10.0.0.0/24"]|*
external_whitelist|Networks to allow external connectivity from, for UI access only. The IP must match the company NAT rules in use to allow access to the install from the company network.|["10.0.0.0/24"]|*
ui_ports|Accessible CMS UI ports.|["8443","16443"]|
external_access_ports|CMS load balanced ports for external access.|["80","5000","7070",<br>"7443","8080","8081",<br>"8444","8501","9292",<br>"9393","5672","5671"]|
prepack_ports|CMS load balanced ports for Prepack solution.|["21","6003"]|
cs_ports|Accessible CMS ports for CS nodes.|["5601","9090","9200"]|
instance_type_cs|The Instance Type to use for CMS Cluster Server Instances.|"Standard_E4_v3"|
instance_type_cs_dev|The Instance Type to use for CMS Cluster Server Instances in development mode.|"Standard_E2_v3"|
instance_type_app|The Instance Type to use for CMS Application Server Instances.|"Standard_E16_v3"|
instance_type_app_dev|The Instance Type to use for CMS Application Server Instances in development mode.|"Standard_E2_v3"|
azure_db_cpus|The number of CPUs to allocate for Azure Database for PostgreSQL Instance.|"16"|
azure_db_cpus_dev|The number of CPUs to allocate for Azure Database for PostgreSQL Instance in development mode.|"2"|
instance_type_es|The Instance Type to use for CMS Elastic Search Server Instances.|"Standard_E4_v3"|
instance_type_es_dev|The Instance Type to use for CMS Elastic Search Server Instances in development mode.|"Standard_E2_v3"|
instance_type_pt|The Instance Type to use for CMS Portal Server Instances.|"Standard_E2_v3"|
instance_type_pt_dev|The Instance Type to use for CMS Portal Server Instances in development mode.|"Standard_E2_v3"|
instance_type_ct|The Instance Type to use for CMS Content Server Instances.|"Standard_E8_v3"|
instance_type_ct_dev|The Instance Type to use for CMS Content Server Instances in development mode.|"Standard_E2_v3"|
root_volume_type|Volume type to use on boot/root disk|"Standard_LRS"|
block_volume_type|Volume type to use on additional file system space|"Standard_LRS"|
delete_disks_on_termination|True to delete the disks (OS and data) when the VM is destroyed.|"true"|
instance_block_size_cs_dev|Number of GB of additional space to alloate to Cluster Server instances in dev mode.|"20"|
instance_block_size_cs|Number of GB of additional space to alloate to Cluster Server instances.|"500"|
instance_block_size_app_dev|Number of GB of additional space to alloate to Application Server instances in dev mode.|"30"|
instance_block_size_app|Number of GB of additional space to alloate to Application Server instances.|"150"|
instance_block_size_es_dev|Number of GB of additional space to alloate to Elastic Search Server instances in dev mode.|"20"|
instance_block_size_es|Number of GB of additional space to alloate to Elastic Search Server instances.|"500"|
instance_block_size_pt_dev|Number of GB of additional space to alloate to Portal Server instances in dev mode.|"150"|
instance_block_size_pt|Number of GB of additional space to alloate to Portal Server instances.|"20"|
instance_block_size_ct_dev|Number of GB of additional space to alloate to Content Server instances in dev mode.|"20"|
instance_block_size_ct|Number of GB of additional space to alloate to Content Server instances.|"150"|
cms_license_fingerprint|CMS Installation License Fingerprint, should match with the fingerprint in CMS license file.|"00000000000000000000000000000000"|*
license_file_path|Path to CMS license file.|"../license.xml"|*
cms_hostname_cs|The hostname prefix to be set for the Cluster Server Instance.|"cms-cs"|
cms_hostname_app|The hostname prefix to be set for the Application Server Instance.|"cms-app"|
cms_hostname_es|The hostname prefix to be set for the Elastic Search Server Instance.|"cms-es"|
cms_hostname_pt|The hostname prefix to be set for the Portal Server Instance.|"cms-pt"|
cms_hostname_ct|The hostname prefix to be set for the Content Server Instance.|"cms-ct"|
cms_dns_domain|Network Domain name for CMS Instances.|"mediakind.local"|
timezone|Timezone to be set in the Instances OS.|"America/Los_Angeles"|*
ntp1|First ntp server IP address.|"0.rhel.pool.ntp.org"|
ntp2|Second ntp server IP address.|"1.rhel.pool.ntp.org"|
snmp_server|SNMP server IP address.|"127.0.0.1"|
private_key_path|The path of the ssh private key file in the server running this terraform scripts, which will be used to configure VM instances.|"~/.ssh/cms_terraform_id_rsa"|*
public_key_path|The path of the ssh pub key file in the server running this terraform scripts, which will be used to configure VM instances.|"~/.ssh/cms_terraform_id_rsa.pub"|*
ssh_user|The user name to use for ssh to VM instances.|"centos"|*
ssh_user_password|Password set when creating ssh_user, only take effect when login with password is allowed.|"CmsOnAzureAdm1n!"|*
rds_db_version|Use this to set the db version for Azure Postgresql Server instance creation.|"9.5"|
rds_db_name|Use this to set the db name for Azure Postgresql Server instance creation.|"ttv"|
rds_db_port|Use this to set the db port for Azure Postgresql Server instance creation.|"5432"|
rds_db_user|Use this to set the db user for Azure Postgresql Server instance creation.|"postgres"|
rds_db_pass|Use this to set the db password for Azure Postgresql Server instance creation.|"CmsAzureDbAdm1n!"|
package_location|Location of CMS packages for CMS installation.|"../packages"|*
os_publisher|Publisher property for OS Image Reference.|"OpenLogic"|
os_offer|Offer property for OS Image Reference.|"CentOS"|
os_sku|Sku property for OS Image Reference.|"7.7"|
os_version|Version property for OS Image Reference.|"latest"|
azure_dns|Azure DNS to use as forwarder.|"168.63.129.16"|
account_tier|Defines the Tier to use for this storage account. Valid options are Standard and Premium. Changing this forces a new resource to be created.|"Standard"|
account_replication_type|Defines the type of replication to use for this storage account. Valid options are LRS, GRS, RAGRS and ZRS.|"LRS"|
storage_share_quota|The maximum size of the share, in gigabytes. Must be greater than 0, and less than or equal to 5 TB (5120 GB).|"100"|*
platform_fault_domain_count|To determine the platform fault domain count.|"2"|
platform_update_domain_count|To determine the platform update domain count.|"5|


