## CMS Terraform scripts for GCP deployment.

### Overview
The Terraform scripts provision a set of resources in GCP (Google Cloud Platform) and install the CMS.
* GCP Resources provisioned by the scripts include:
  * VPC network for CMS.
  * VPC Firewall rules.
  * VM instance templates for APP cluster type, ES cluster type, PT cluster type, CT cluster type.
  * VM instance for CS nodes, APP nodes, ES nodes, PT nodes, CT nodes.
  * VM instance as internal NFS server (optional).
  * VM instance groups for CS nodes.
  * VM regional managed instance groups for APP nodes, ES nodes, PT  nodes, CT nodes.
  * Cloud SQL instance as CMS DB.
  * Public Static IP as CMS external VIP.
  * Internal static IP as CMS internal VIP.
  * Cloud NAT IP.
  * Backend service as internal Load Balancer.
  * Target Pool as external Load Balancer.
  * Forwarding rules for openning ports in external Load Balancer.

### Prerequisites
1. User should have basic knowledge about [terraform cli](https://www.terraform.io/docs/commands/index.html).
2. User should have basic knowledge about GCP bastion VM instance.
3. User should have advanced knowledge about Linux OS operations.
4. GCP project and account are ready for deploying CMS.
5. Terraform v0.12 has been installed in the bastion VM instance.

### Steps for deploying CMS on GCP
**1. Prepare GCP bastion VM instance.**
   * Create GCP VM instance follow the [GCP How-to Guide](https://cloud.google.com/compute/docs/quickstart-linux). 
   <br>*<font color=red size=2>Note:  When creating bastion VM, choose ***'Allow full access to all Cloud APIs'*** option for ***Access scopes***.</font>*</br>
   * Create SSH key and configure the SSH access for bastion VM follow the [GCP Guide](https://cloud.google.com/compute/docs/instances/adding-removing-ssh-keys).
   * Login to bastion VM and install terraform v0.12 follow the [terraform guide](https://www.terraform.io/downloads.html).

**2. Prepare the CMS RPMs.**
   * Put below CMS RPMs to the GCP bastion VM instance by SCP or FTP.
   *<br><font size=2 color=teal> - CMS-SWO-REPO rpm</font>*
   *<br><font size=2 color=teal> - CMS-OS-CentOS7x-REPO rpm</font>*
   *<br><font size=2 color=teal> - CMSInstaller rpm</font>*
   * Move the rpms to a dedicated folder
   <br><font size=2>*For example, <font color=teal>/home/packages*</font></font>
   <br>*<font color=red size=2>Note:  Make sure this folder can be accessed by user running the terraform scripts.</font>*

**3. Prepare the CMS terraform scripts.**
   * Create a folder in the bastion VM for GCP terraform scripts.
   <br><font size=2>*For example, <font color=teal>~/terraform_gcp*</font></font>
   * Put below folders from this project to bastion VM under the new folder created above
   *<br><font size=2 color=teal> - GCP</font>*
   *<br><font size=2 color=teal> - config_templates</font>*
   *<br><font size=2 color=teal> - vmTools</font>*
   *<br><font size=2 color=teal> - scripts</font>*

**4. Prepare the CMS license file.**
   * Get CMS license.xml file and put the file into bastion VM under the folder created in above step.
   <br><font size=2>*For example, <font color=teal>~/terraform_gcp*</font></font>
   * Update the License Fingerprint into field *cms_license_fingerprint* in the [customized deployment variable file](#jump_samplevariablesfile) 

**5. Prepare the SSH key files.**
   * Create SSH key pare based on user's own security requirement. User can refer to [GCP Guide](https://cloud.google.com/compute/docs/instances/adding-removing-ssh-keys) for some information.
   * Put the generated key file and key.public file into bastion VM under the folder created in above step.
   <br><font size=2>*For example, <font color=teal>~/terraform_gcp*</font></font>
   <br><font size=2>*Key pare example: <font color=teal>cms-ssh-key, cms-ssh-key.pub*</font></font>

**6. Prepare the <span id="jump_samplevariablesfile">customized deployment variable file</span>.**
   * Create a \<anyname\>.tfvars file, e.g. ~/terraform_gcp/sample.tfvars.
   * Edit this file with variables that need customized value.
   <br><font size=2>*Refer to below section [Variables](#jump_variables) for all avaiable variables.*</font>
   <br><font size=2>Sample file:</font>
```bash
#cat ~/terraform_gcp/sample.tfvars
install_name = "gcp-cms-test"
cms_license_fingerprint = "01234567890123456789012345678901"
cs_count     = 3
app_count    = 3
es_count     = 3
pt_count     = 1
ct_count     = 0
cloud_ext_ct = true
ssh_user     = "test"
private_key_path = "~/terraform_gcp/cms-ssh-key"
public_key_path  = "~/terraform_gcp/cms-ssh-key.pub"
package_location = "/home/packages"
```

**7. Run scripts to deploy CMS.**
   * Login to bastion VM and change to the terraform scripts directory
```bash
#e.g.
cd ~/terraform_gcp/GCP
```
   * Run scripts with below commands
```bash
sudo terraform init -upgrade
sudo terraform plan -var-file=~/terraform_gcp/sample.tfvars -out=gcpcms.tfplan
sudo terraform apply gcpcms.tfplan
```

### About Storage
   * NFS VM vs. Shared VPC file store
      * NFS VM
        <br>This terraform scripts will create a dedicated VM running nfs service as internal NAS server by default. However, this internal NAS can not be sccessiced by other VPC. That means it can not be accessed by other 3PP (e.g. MKEOD) or downstream systems (e.g. VSPP). Also this internal NAS has no HA nor Redundent capability.
      * GCP File Store
        <br>For production setup, it is highly recommanded to setup [GCP File Store](https://cloud.google.com/filestore/docs/how-to) inside [shared VPC](https://cloud.google.com/vpc/docs/provisioning-shared-vpc), which can be accessed by all integreted systems. 
        <br>*<font color=red size=2>Please note these Shared VPC and File Store resources are not in the scope of CMS terraform scripts, user need to create them manually.</font>*
        <br>User then need to provide the File Store mount points into the [customized deployment variable file](#jump_samplevariablesfile).
        <br>When using the File Store from shared VPC, no need to setup internal NAS any more. User can set *setup_nfs* as ***false***.
```bash
#cat ~/terraform_gcp/sample.tfvars
install_name = "gcp-cms-test"
...
setup_nfs             = false
#e.g.
cms_nas_server        = "<ip_of_gcp_file_store>"
cms_nas_share         = "/nfs/cms_app"
content_nas_server    = "<ip_of_gcp_file_store>"
content_nas_share     = "/nfs/cms_content"
ct_cms_nas_server     = "<ip_of_gcp_file_store>"
ct_cms_nas_share      = "/nfs/cms_ct_app"
ct_content_nas_server = "<ip_of_gcp_file_store>"
ct_content_nas_share  = "/nfs/cms_ct_content"
...
```

### About External CT node
   * **NAT**
   <br>Since external CT node is deployed inside customer's data-center, it could be behind a firewall and exported with a natted IP. In such case, user need to enable the firewalld service in all CS nodes and APP nodes and configure some firewall rules to route the outgoing messages to the CT node's natted IP.
   <br>Refer to Installation Guide section *Configuring Iptables NAT Rules (Optional)* for setting up the firewall rules on CS and APP nodes.
   * **Firewall Ports**
   <br>The external CT nodes should have below ports opened for CS and APP nodes.

Service|Cloud resource|Cloud Port|Direction|Firewall Port|OnPremise Node
:-|:-|:-|:-:|:-|:-
Consul|External LB|8501|<-----|XX|Content Server
Workflow|External LB|7070|<-----|XX|Content Server
Elasticsearch|External LB|9200|<-----|XX|Content Server
Kibana|External LB|9292|<-----|XX|Content Server
RPM-Repo|External LB|8008|<-----|XX|Content Server
Redis|External LB|6379|<-----|XX|Content Server
RabbitMQ|External LB|5672|<-----|XX|Content Server
DNS|External LB|53(TCP and UDP)|<-----|XX|Content Server
cmstomcat|CS nodes|XX|----->|8081|Content Server
cms|CS nodes|XX|----->|8444|Content Server
FTP|CS nodes|XX|----->|21|Content Server
FTP|CS nodes|XX|----->|10000-10199|Content Server
ADI|CS nodes|XX|----->|5000|Content Server
cmstomcat|APP nodes|XX|----->|8081|Content Server
cms|APP nodes|XX|----->|8444|Content Server

### <span id="jump_variables">Variables</span>

&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Variable Name &nbsp; &nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp; &nbsp; |Description|Default Value
:-|:-|:-
project|The GCP Project ID for the CMS setup.|"tvaas-poc"
region|The expected GCP Region where the instances will be created at.|"us-west1"
instance_group_zones|The expected Zones within the region where the instances will be created at.|["us-west1-a", "us-west1-b", "us-west1-c"]
bastion_public_cidr|The public IP CIDR of the installer system.  E.g. ["10.20.30.40/32", "10.20.40.0/24"]|[]
admin_whitelist|Networks to allow admin connectivity from, fill with IP CIDR format.|[]
external_whitelist|Networks to allow external connectivity from, mainly for UI access, fill with IP CIDR format.|[]
cs_ports|CMS load balanced ports for CMS applications.|["5601", "9090", "9393", "5672", "5671", "7070", "5000"]
ui_ports|CMS load balanced ports for accessing CMS UI.|["8443", "16443"]
external_access_ports|CMS load balanced ports for external nodes, e.g. CT node, to access.|["6379", "8501", "9200", "9292"]
prepack_ports|CMS load balanced ports for Prepack solution.|["21", "6003"]
session_affinity |The session affinity for the Load balancer backends. Valid values are: NONE, CLIENT_IP.|"NONE"
gcp_vpc_cidr|The CIDR of the VPC to create.|"10.1.0.0/16"
gcp_subnet|The CIDR of the Subnet to create within the VPC. All VMs are created in this subnet. Must be a valid subnet of the VPC cidr.|"10.1.0.0/24"
install_name|Textual Name of this CMS Install, all instances created will be named with this as prefix.|"gcp-cms"
app_count|Number of application nodes to deploy.|"1"
cs_count|Number of Cluster Service nodes to deploy.|"1"
es_count|Number of ElasticSearch nodes to deploy.|"1"
pt_count|Number of Portal nodes to deploy.|"0"
ct_count|Number of Content nodes to deploy inside GCP.|"0"
cloud_ext_ct|To determine whether CT nodes need to be installed inside or outside GCP. Set it to true when User has On Premise CT node deployed outisde GCP.|false
dev_mode|True to run in development mode (smaller/cheaper instance types).|false
setup_nfs|Ture to create an additional VM instance dedicated for running nfs service as build-in NAS server. For production, recommand to set it to false and user should use a customer provided NAS server or GCP File Store running in shared VPC.|true
nfs_disk_size|Number of GB of disk space to alloate to build-in NFS Server instances when dev_mode is false. It will always be 30GB when dev_mode is true.|"2048"
mount_options|NFS Mount options for NAS mount points.|["nolock", "nfsvers=4.1"]
remount|Enable/disable remount as a mount option for NAS mount points.|false
cms_nas_server|The IP address of nas server for cms app folder in APP nodes.|"10.0.0.5"
content_nas_server|The IP address of nas server for cms content folder in APP nodes.|"10.0.0.5"
ct_cms_nas_server|The IP address of nas server for cms app folder in CT nodes.|"10.0.0.5"
ct_content_nas_server|The IP address of nas server for cms content folder in CT nodes.|"10.0.0.5"
cms_nas_share|The nas share folder for cms in APP nodes.|"/var/nfsshare/app"
content_nas_share|The nas share folder for content in APP nodes.|"/var/nfsshare/content"
ct_cms_nas_share|The nas share folder for cms in CT nodes.|"/var/nfsshare/ct-app"
ct_content_nas_share|The nas share folder for content in CT nodes.|"/var/nfsshare/ct-content"
gcp_instance_type_nfs|The GCP Instance Type to use for CMS build-in NAS Instances.|"n1-highmem-4"
gcp_instance_type_nfs_dev|The GCP Instance Type to use for CMS build-in NAS in development mode.|"n1-standard-2"
gcp_instance_type_cs|The GCP Instance Type to use for CMS Cluster Server Instances.|"n1-highmem-4"
gcp_instance_type_cs_dev|The GCP Instance Type to use for CMS Cluster Server Instances in development mode.|"n1-standard-2"
gcp_instance_type_app|The GCP Instance Type to use for CMS Application Server Instances.|"n1-standard-16"
gcp_instance_type_app_dev|The GCP Instance Type to use for CMS Application Server Instances in development mode.|"n1-standard-2"
gcp_instance_type_es|The GCP Instance Type to use for CMS Elastic Search Server Instances. |"n1-highmem-4"
gcp_instance_type_es_dev|The GCP Instance Type to use for CMS Elastic Search Server Instances in development mode.|"n1-standard-2"
gcp_instance_type_pt|The GCP Instance Type to use for CMS Portal Server Instances.|"n1-standard-1"
gcp_instance_type_pt_dev|The GCP Instance Type to use for CMS Portal Server Instances in development mode.|"n1-standard-1"
gcp_instance_type_ct|The GCP Instance Type to use for CMS Content Server Instances.|"n1-standard-16"
gcp_instance_type_ct_dev|The GCP Instance Type to use for CMS Content Server Instances in development mode.|"n1-standard-2"
gcp_db_tier|The GCP PostgreSQL Instances type.|"db-custom-8-15360"
gcp_db_tier_dev|The GCP PostgreSQL Instances type in development mode|"db-custom-8-15360"
cs_disk_size|Number of GB of additional space to alloate to Cluster Server instances|"300"
cs_disk_size_dev|Number of GB of additional space to alloate to Cluster Server instances in dev mode|"20"
app_disk_size|Number of GB of additional space to alloate to Application Server instances|"50"
app_disk_size_dev|Number of GB of additional space to alloate to Application Server instances in dev mode|"20"
es_disk_size|Number of GB of additional space to alloate to ES Server instances|"500"
es_disk_size_dev|Number of GB of additional space to alloate to ES Server instances in dev mode|"20"
pt_disk_size|Number of GB of additional space to alloate to Portal Server instances|"100"
pt_disk_size_dev|Number of GB of additional space to alloate to Portal Server instances in dev mode|"10"
ct_disk_size|Number of GB of additional space to alloate to Content Server instances|"100"
ct_disk_size_dev|Number of GB of additional space to alloate to Content Server instances in dev mode|"20"
cms_license_fingerprint|CMS Installation License Fingerprint. This should be matched with the fingerprint in the license.xml file.|"00000000000000000000000000000000"
customerInstanceId|A value used internally - mostly here for legacy purposes|"cms"
license_file_path|Path to CMS license file.|"../license.xml"
package_location|Path to CMS SWO packages, including cms-swo, cms-os, cms-installer rpms.|"../packages"
cms_hostname_cs|The hostname prefix for the Cluster Server Instance.|"cms-cs"
cms_hostname_app|The hostname prefix for the Application Server Instance.|"cms-app"
cms_hostname_es|The hostname prefix for the Elastic Search Server Instance.|"cms-es"
cms_hostname_pt|The hostname prefix for the Portal Server Instance.|"cms-pt"
cms_hostname_ct|The hostname prefix for the Content Server Instance.|"cms-ct"
cms_dns_domain|Network Domain name for CMS Instances.|"mediakind.local"
timezone|Timezone to run the Instances in.|"America/Los_Angeles"
ntp1|First ntp server ip.|"0.rhel.pool.ntp.org"
ntp2|Second ntp server ip.|"1.rhel.pool.ntp.org"
snmp_server|SNMP server IP.|"127.0.0.1"
prepack_license_file_path|Path to CMS prepack license file.|"../prepackLicense.xml"
config_install_sysInfo_template|PrePack install sysInfo file for Prepack installation.|"../prepackTools/install_sysInfo_1NonHA.tpl"
ssh_user|User to ssh as administrator with the private key.|"test"
private_key_path|The path of the ssh private key the bastion will use to configure instances.|"~/.ssh/test"
public_key_path|The path of the ssh pub key the bastion will use to configure instances.|"~/.ssh/test.pub"
db_version|Use this to set the db version for RDS instance creation.|"POSTGRES_9_6"
sql_ha_type|SQL availability_type, ZONAL for non-ha, REGIONAL for ha.|"ZONAL"
db_name|Use this to set the db name for Cloud SQL instance creation.|"ttv"
db_port|Use this to set the db port for Cloud SQL instance creation.|"5432"
db_user|Use this to set the db user for Cloud SQL instance creation.|"postgres"
db_pass|Use this to set the db password for Cloud SQL instance creation.|"n2Cdf92j"


### Known Issues
   * [D-10437 Consul-esm not in good status after CS node reboot](https://www5.v1host.com/Ericsson04/defect.mvc/Summary?oidToken=Defect:497336)

