resource google_compute_instance_template app_template {
  name        = "${var.install_name}-app-template"
  #depends_on = ["data.google_compute_instance.cs_server"]
  depends_on = [google_compute_address.cs_with_subnet_and_address]
  machine_type = var.dev_mode ? var.gcp_instance_type_app_dev : var.gcp_instance_type_app

  disk {
    source_image = "centos-cloud/centos-7"
    auto_delete  = true
    boot         = true
    disk_type    = "pd-standard"
    disk_size_gb = var.dev_mode ? var.app_disk_size_dev : var.app_disk_size
  }

  network_interface {
    subnetwork = google_compute_subnetwork.subnet_cms_cluster.name
    #network_ip = element(
    #  google_compute_address.cs_with_subnet_and_address.*.address,
    #  count.index,
    #)
    // //access_config = {}
  }

  #depends_on = [google_compute_instance.cs]

  #metadata_startup_script = "sed -i 's/enabled=1/enabled=0/g' /etc/yum.repos.d/epel.rep"
  metadata_startup_script = "sed -i 's/enabled=1/enabled=0/g' /etc/yum.repos.d/epel.repo;curl -O http://${google_compute_instance.cs[0].network_interface.0.network_ip}:8008/startup.tgz;tar -xzf startup.tgz;/bin/bash /opt/vmTools/scripts/app.sh ${google_compute_instance.cs[0].network_interface.0.network_ip} $(date -u +%Y%m%d%H%M%S%2N) ${var.cms_hostname_app} ${var.cms_dns_domain} ${var.db_name} ${var.db_port} ${var.db_user} ${var.db_pass}"

  metadata = {
    ssh-keys = "${var.ssh_user}:${file(var.public_key_path)}"
    #shutdown-script = "sudo sh /opt/vmTools/scripts/deregister_node.sh"
  }

  service_account {
    scopes = ["compute-rw"]
  }
}

# Region Instance Group Manager for HA
resource google_compute_region_instance_group_manager app_region_igm {
  name = "${var.install_name}-app-region-igm"
  depends_on = [null_resource.cs1_prepare_rpm, google_sql_database_instance.cloudsql_master, null_resource.cs_installcms]

  base_instance_name         = "${var.install_name}-app"
  version {
    instance_template        = google_compute_instance_template.app_template.self_link
  }
  region                     = var.region
  distribution_policy_zones  = var.instance_group_zones

  target_size                = var.app_count
  wait_for_instances         = true

}

# Get the created instance group for fetching the created Instances
data google_compute_region_instance_group app_group {
    name = google_compute_region_instance_group_manager.app_region_igm.name
    depends_on = [google_compute_region_instance_group_manager.app_region_igm]
}


# Get the Instances created from the instance group
data google_compute_instance app_server {
    count = var.app_count
    self_link  = data.google_compute_region_instance_group.app_group.instances[count.index].instance
    depends_on = [google_compute_region_instance_group_manager.app_region_igm]
}


# call by other resource by
# "${data.google_compute_instance.app_server[count.index].network_interface.0.network_ip}"
output APP_IP_Address {
  #value = "${data.azurerm_public_ip.cs_pub_ip.*.ip_address}"
  value = data.google_compute_instance.app_server.*.network_interface.0.network_ip
  depends_on = [google_compute_region_instance_group_manager. app_region_igm,data.google_compute_instance.app_server]
}


resource null_resource app_checklogs {
  count = var.app_count
  depends_on = [null_resource.cs1_prepare_rpm,data.google_compute_instance.app_server]

  connection {
    host = data.google_compute_instance.app_server[count.index].network_interface.0.network_ip
    type = "ssh"
    user = var.ssh_user
    private_key = file(var.private_key_path)
    #timeout     = "60m"
  }
  provisioner remote-exec {
    inline = [
      "sudo timeout 2700 bash /opt/vmTools/scripts/checklogs.sh && [[ $? -eq 0 ]] || if [[ $${PIPESTATUS[0]} -eq 124 ]];then echo 'Installation Timeout!!';exit 1; else exit 1;fi",
      ## Reset the hostname to align with the cname
      #"sudo hostnamectl set-hostname ${var.cms_hostname_app}$(cat /etc/facter/facts.d/node.yaml | grep 'cname: app' | grep -o [0-9]*)",
    ]
  }
}


#resource "null_resource" "app_installcms" {
#  count = "${var.app_count}"
#  depends_on = ["null_resource.cs1_prepare_rpm","data.google_compute_instance.app_server"]
#
#  connection {
#    host = "${data.google_compute_instance.app_server[count.index].network_interface.0.network_ip}"
#    type = "ssh"
#    user = "${var.ssh_user}"
#    private_key = "${file(var.private_key_path)}"
#    #timeout     = "60m"
#  }
#  provisioner "remote-exec" {
#    inline = [
#      "sudo mkdir -p /opt/vmTools",
#      "sudo chown ${var.ssh_user}:${var.ssh_user} /opt/vmTools",
#    ]
#  }
#
#  provisioner "file" {
#    source      = "../vmTools/"
#    destination = "/opt/vmTools"
#  }
#
#  provisioner "remote-exec" {
#    inline = [
#      "sudo chmod +x /opt/vmTools/*.sh",
#      "sudo bash /opt/vmTools/mountVMdisk.sh /var/log \"0% 25%\" /opt \"26% 100%\"",
#      "sudo bash /opt/vmTools/setHostname.sh ${var.cms_hostname_es}${count.index + 1}",
#      "echo 'PEERDNS=no' | sudo tee -a /etc/sysconfig/network-scripts/ifcfg-eth0",
#      "sudo yum erase -y python-setuptools",
#      "sudo systemctl stop firewalld",
#      "sudo bash /opt/vmTools/waitAndPullNodeInstall.sh http://${data.google_compute_instance.cs_server[0].network_interface.0.network_ip}:8008/cms-node-config.tgz",
#      #"cd /opt/cms/staging",
#      #"sudo bash installcmsnode.sh -n ${var.app_count} es${count.index + 1} |& sudo tee -a /var/log/cms/installer/installcmsnode.log; test $${PIPESTATUS[0]} -eq 0",
#    ]
#  }
#
#}
