resource null_resource post_install {
  count = var.cloud_ext_ct ? 0 : 1
  depends_on = [null_resource.es_checklogs, null_resource.pt_checklogs, null_resource.app_checklogs, null_resource.ct_checklogs]

  connection {
    host = google_compute_instance.cs[0].network_interface.0.network_ip
    type = "ssh"
    user = var.ssh_user
    private_key = "${file(var.private_key_path)}"
    timeout     = "20m"
  }
  
  provisioner remote-exec {
    inline = [
      # workaround for update post_install scripts without sudo
      "sudo sed -i 's/    sudo /    /g' /opt/cms/installer/post_install.sh",
      "sleep 30",
      "sh /opt/cms/installer/post_install.sh ${google_compute_address.cs_vip_external.address}",
    ]
  }
}

