resource google_compute_instance_template es_template {
  name        = "${var.install_name}-es-template"
  #depends_on = ["data.google_compute_instance.cs_server"]
  depends_on = [google_compute_address.cs_with_subnet_and_address]
  machine_type = var.dev_mode ? var.gcp_instance_type_es_dev : var.gcp_instance_type_es

  disk {
    source_image = "centos-cloud/centos-7"
    auto_delete  = true
    boot         = true
    disk_type    = "pd-standard"
    disk_size_gb = var.dev_mode ? var.es_disk_size_dev : var.es_disk_size
    #type         = "SCRATCH"
  }

  network_interface {
    subnetwork = google_compute_subnetwork.subnet_cms_cluster.name
    #network_ip = element(
    #  google_compute_address.cs_with_subnet_and_address.*.address,
    #  count.index,
    #)
    // //access_config = {}
  }

  #depends_on = [google_compute_instance.cs]

  #metadata_startup_script = "sed -i 's/enabled=1/enabled=0/g' /etc/yum.repos.d/epel.rep"
  metadata_startup_script = "sed -i 's/enabled=1/enabled=0/g' /etc/yum.repos.d/epel.repo;curl -O http://${google_compute_instance.cs[0].network_interface.0.network_ip}:8008/startup.tgz;tar -xzf startup.tgz;/bin/bash /opt/vmTools/scripts/es.sh ${google_compute_instance.cs[0].network_interface.0.network_ip} $(date -u +%Y%m%d%H%M%S%2N) ${var.cms_hostname_es} ${var.cms_dns_domain}"

  metadata = {
    ssh-keys = "${var.ssh_user}:${file(var.public_key_path)}"
    #shutdown-script = "sudo sh /opt/vmTools/scripts/deregister_node.sh"
  }
  
  service_account {
    scopes = ["compute-rw"]
  }
}

# Region Instance Group Manager for HA
resource google_compute_region_instance_group_manager es_region_igm {
  name = "${var.install_name}-es-region-igm"
  depends_on = [null_resource.cs_installcms]

  base_instance_name         = "${var.install_name}-es"
  version {
    instance_template          = google_compute_instance_template.es_template.self_link
  }
  region                     = var.region
  distribution_policy_zones  = var.instance_group_zones
  
  update_policy {
    # PROACTIVE or OPPORTUNISTIC 
    type                         = "OPPORTUNISTIC"
    # PROACTIVE or NONE
    instance_redistribution_type = "NONE"
    # REPLACE or RESTART
    minimal_action               = "RESTART"
    #max_surge_percent            = 20
    max_unavailable_fixed        = length(var.instance_group_zones)
    #min_ready_sec                = 50
  }

  target_size                = var.es_count
  wait_for_instances         = true

}

# Get the created instance group for fetching the created Instances
data google_compute_region_instance_group es_group {
    name = google_compute_region_instance_group_manager.es_region_igm.name
    depends_on = [google_compute_region_instance_group_manager.es_region_igm]
}


# Get the Instances created from the instance group
data google_compute_instance es_server {
    count = var.es_count
    self_link  = data.google_compute_region_instance_group.es_group.instances[count.index].instance
    depends_on = [google_compute_region_instance_group_manager.es_region_igm]
}


# call by other resource by
# "${data.google_compute_instance.es_server[count.index].network_interface.0.network_ip}"
output ES_IP_Address {
  #value = "${data.azurerm_public_ip.cs_pub_ip.*.ip_address}"
  value = data.google_compute_instance.es_server.*.network_interface.0.network_ip
  depends_on = [google_compute_region_instance_group_manager.es_region_igm,data.google_compute_instance.es_server]
}

resource null_resource es_checklogs {
  count = var.es_count
  depends_on = [null_resource.cs1_prepare_rpm,data.google_compute_instance.es_server]

  connection {
    host = data.google_compute_instance.es_server[count.index].network_interface.0.network_ip
    type = "ssh"
    user = var.ssh_user
    private_key = "${file(var.private_key_path)}"
    #timeout     = "60m"
  }
  
  provisioner remote-exec {
    inline = [
      #"sudo timeout 1800 bash /opt/vmTools/scripts/checklogs.sh && [[ $? -eq 0 ]] || echo 'Installation Timeout !!' ;! test $${PIPESTATUS[0]} -eq 0 && exit 1",
      "sudo timeout 1800 bash /opt/vmTools/scripts/checklogs.sh && [[ $? -eq 0 ]] || if [[ $${PIPESTATUS[0]} -eq 124 ]];then echo 'Installation Timeout!!';exit 1; else exit 1;fi",
    ]
  }
}