# Dev Mode to true will use small capacity instance for test, should set it to false for setup Production system.
dev_mode = true
# Installation Identifier - every concurrent deployment needs a unique install name.
install_name = "cms-jacel"
cms_license_fingerprint = "00000000000000000000000000000000"
cs_count = 1
app_count = 1
es_count = 1
pt_count = 0
# Number of Content server node to be installed inside cloud platform
# Set ct_count as 0 and cloud_ext_ct as true when seting up de Contenr server outside cloud platform 
ct_count = 0
cloud_ext_ct = false
# Network to allow connectivity for admin access, including external CT nodes' hosts.
admin_whitelist = ["66.0.13.79/32", "120.236.209.139/32"]
# Network to allow external connectivity for UI access only - replace with corporate public IP address range from corporate Nat/gateway.
external_whitelist = ["120.236.209.140/32", "192.176.1.0/24", "119.35.92.0/24"]
# The public IP cidr of the installer system.  i.e.   dig +short myip.opendns.com @resolver1.opendns.com.
bastion_public_cidr = "192.168.0.0/24"
timezone      = "America/Los_Angeles"
ui_ports      = ["8443", "16443"]
prepack_ports = ["21", "6003"]
# The paths to the ssh key the installer will use for access to deployed instances.
ssh_user         = "test"
private_key_path = "../cms-ssh-key"
public_key_path  = "../cms-ssh-key.pub"
# SQL availability_type, ZONAL for non-ha, REGIONAL for ha.
sql_ha_type = "ZONAL"
# Ture to create an additional VM instance dedicated for running nfs service as build-in NAS server. 
# For production, recommand to set it to false and user should fill out below information for customer provided NAS (GCP FileStore) server.
setup_nfs             = true
cms_nas_server        = ""
cms_nas_share         = ""
content_nas_server    = ""
content_nas_share     = ""
ct_cms_nas_server     = ""
ct_cms_nas_share      = ""
ct_content_nas_server = ""
ct_content_nas_share  = ""
