resource google_compute_address cs_with_subnet_and_address {
  # Static internal IPs for CS compute instances
  count        = var.cs_count
  name         = "${var.install_name}-cs-adress-${count.index}"
  region       = var.region
  subnetwork   = google_compute_subnetwork.subnet_cms_cluster.name
  address_type = "INTERNAL"
  address      = cidrhost(var.gcp_subnet, count.index + 11)
}

output CS_IP_Address {
  value = google_compute_address.cs_with_subnet_and_address.*.address
}

resource google_compute_instance cs {
  # Scpecification of CS instances.
  count        = var.cs_count
  name         = "${var.install_name}-cs-${count.index}"
  #depends_on = [google_compute_instance.nfs]
  machine_type = var.dev_mode ? var.gcp_instance_type_cs_dev : var.gcp_instance_type_cs
  hostname     = "${var.cms_hostname_cs}${count.index + 1}.${var.cms_dns_domain}"
  //
  zone = element(flatten([var.instance_group_zones, var.instance_group_zones, var.instance_group_zones]), count.index)

  tags = ["ui-target-node"]
  
  boot_disk {
    initialize_params {
      image = "centos-cloud/centos-7"
      size  = var.dev_mode ? var.cs_disk_size_dev : var.cs_disk_size
      type  = "pd-standard"
    }
  }

  network_interface {
    subnetwork = google_compute_subnetwork.subnet_cms_cluster.name
    network_ip = element(google_compute_address.cs_with_subnet_and_address.*.address, count.index)
    // //access_config = {}
  }

  metadata_startup_script = "sed -i 's/enabled=1/enabled=0/g' /etc/yum.repos.d/epel.repo;echo -n 'net.ipv4.ip_forward=1' >> /etc/sysctl.conf;sysctl -p;ip addr add ${google_compute_address.cs_vip_external.address}/32 dev lo;ip addr add ${google_compute_address.cs_vip_internal.address}/32 dev lo;"
  metadata = {
    ssh-keys = "${var.ssh_user}:${file(var.public_key_path)}"
  }
}



resource null_resource cs_config_vm {
  count = var.cs_count
  depends_on = [google_compute_instance.cs]

  connection {
    host = google_compute_instance.cs[count.index].network_interface.0.network_ip
    type = "ssh"
    user = var.ssh_user
    private_key = file(var.private_key_path)
    #timeout     = "60m"
  }
  provisioner remote-exec {
    inline = [
      "sudo mkdir -p /opt/vmTools",
      "sudo chown ${var.ssh_user}:${var.ssh_user} /opt/vmTools",
    ]
  }

  provisioner file {
    source      = "../vmTools/"
    destination = "/opt/vmTools"
  }

  provisioner remote-exec {
    inline = [
      "sudo mkdir -p /opt/vmTools/scripts",
      "sudo chown ${var.ssh_user}:${var.ssh_user} /opt/vmTools/scripts",
    ]
  }

  provisioner file {
    source      = var.private_key_path
    destination = "~/.ssh/id_rsa"
  }

  provisioner remote-exec {
    inline = [
      "chmod 600 ~/.ssh/id_rsa",
    ]
  }

  provisioner file {
    source      = "../scripts/"
    destination = "/opt/vmTools/scripts"
  }

  provisioner remote-exec {
    inline = [
      "sudo mkdir -p /opt/cms/staging/config",
      "sudo chown -R ${var.ssh_user}:${var.ssh_user} /opt/cms/staging",
    ]
  }

  provisioner file {
    source      = template_dir.config.destination_dir
    destination = "/opt/cms/staging/"
  }

  provisioner remote-exec {
    inline = [
      "sudo chmod +x /opt/vmTools/*.sh",
      #"sudo bash /opt/vmTools/mountVMdisk.sh /var/log \"0% 25%\" /opt \"26% 100%\"",
      # The hostname is already set when creating VM instance
      #"sudo hostnamectl set-hostname ${var.cms_hostname_cs}${count.index + 1}",
      "echo 'PEERDNS=no' | sudo tee -a /etc/sysconfig/network-scripts/ifcfg-eth0",
      "sudo setenforce 0",
      "sudo sed -i --follow-symlinks 's/^SELINUX=.*/SELINUX=disabled/g' /etc/sysconfig/selinux",
      "sudo yum erase -y python-setuptools",
      # Make sure the lo network interface is configured properly when VM start up so that LB networking health-check can work well. 
      "sudo sed -i '$aip addr add ${google_compute_address.cs_vip_external.address}/32 dev lo' /etc/rc.d/rc.local",
      "sudo sed -i '$aip addr add ${google_compute_address.cs_vip_internal.address}/32 dev lo' /etc/rc.d/rc.local",
      "sudo chmod +x /etc/rc.d/rc.local", 
    ]
  }
}

resource null_resource cs1_prepare_rpm {
  depends_on = [null_resource.cs_config_vm]

  connection {
    host = google_compute_instance.cs[0].network_interface.0.network_ip
    type = "ssh"
    user = var.ssh_user
    private_key = file(var.private_key_path)
    timeout     = "20m"
  }
  provisioner file {
    source      = var.package_location
    destination = "~${var.ssh_user}/packages"
  }
  
  provisioner remote-exec {
    inline = [
      "cd ~${var.ssh_user}/packages/",
      "sudo yum install -y `ls *.rpm`",
      "sudo bash /opt/repos/scripts/create_httpd_repo.sh ${google_compute_instance.cs[0].network_interface.0.network_ip}",
      "sudo systemctl restart httpd",
      "sudo mv /opt/cms/staging/config /opt/cms/installer/staging/.",
      "sudo cat << EOF | sudo tee /opt/cms/installer/staging/files/license.xml",
      file(var.license_file_path),
      "EOF",
      "sudo bash /opt/cms/installer/create_config_package.sh",
      "sudo systemctl stop firewalld",
      #Clean the original rpms to save disk space
      "cd ~${var.ssh_user}/packages;rm -f *.rpm",
      #Prepare the startup scripts tar file for other nodes
      "sudo tar -czf /opt/cms/installer/startup.tgz /opt/vmTools",
      "sudo chmod 644 /opt/cms/installer/startup.tgz",
      "sudo ln -sf /opt/cms/installer/startup.tgz /var/www/html/startup.tgz",
    ]
  }
}


resource null_resource cs_installcms {
  count = var.cs_count
  depends_on = [null_resource.cs1_prepare_rpm,google_compute_instance.nfs]

  connection {
    host = google_compute_instance.cs[count.index].network_interface.0.network_ip
    type = "ssh"
    user = var.ssh_user
    private_key = file(var.private_key_path)
    #timeout     = "60m"
  }

  provisioner remote-exec {
    inline = [
      # Fetch the CMS config files
      "sudo bash /opt/vmTools/waitAndPullNodeInstall.sh http://${google_compute_instance.cs[0].network_interface.0.network_ip}:8008/cms-node-config.tgz",
      # Install CMS
      "cd /opt/cms/staging",
      "sudo bash installcmsnode.sh -n ${var.cs_count} cs${count.index + 1} |& sudo tee -a /var/log/cms/installer/installcmsnode.log; test $${PIPESTATUS[0]} -eq 0",
      # For solving Consul Too many open files issue D-10440
      "sudo sed -i '/\\[Service\\]/aLimitNOFILE=65536' /etc/systemd/system/consul.service",
      "sudo systemctl daemon-reload; sudo systemctl restart consul",
      # Need to update redis bind address when there is external CT
      "if [[ ${var.cloud_ext_ct} == 'true' ]];then sudo sed -i '/^bind/cbind 0.0.0.0' /etc/redis.conf; sudo systemctl restart redis; fi",
    ]
  }

}
