resource google_compute_network cms_network {
  name                    = "${var.install_name}-cms-network"
  description             = "Network that is use for host CMS installation"
  auto_create_subnetworks = "false"
}

resource google_compute_address nat_ip {
  name         = "${var.install_name}-nat-ip"
  region       = var.region
  address_type = "EXTERNAL"
}

output GCP_NAT_IP {
  value = "${google_compute_address.nat_ip.address}"
  depends_on = [google_compute_address.nat_ip]
}

### Add Cloud NAT 
## Set minimum ports to 128 to adapte to kibana import process, default is 64
resource google_compute_router_nat cloud_nat {
  provider                           = google
  name                               = "${var.install_name}-cloud-nat"
  router                             = google_compute_router.cloud_nat.name
  #nat_ip_allocate_option             = "AUTO_ONLY"
  nat_ip_allocate_option             = "MANUAL_ONLY"
  nat_ips                            = google_compute_address.nat_ip.*.self_link

  source_subnetwork_ip_ranges_to_nat = "ALL_SUBNETWORKS_ALL_IP_RANGES"
  region                             = var.region
  #min_ports_per_vm                   = 128
}

resource google_compute_router cloud_nat {
  name    = "${var.install_name}-cloud-nat"
  network = google_compute_network.cms_network.self_link
}

data google_compute_network default {
  name = var.bastion_gcp_vpc_name
}

# Peer from Bstion host (default) to CMS instances (cms-network)
resource google_compute_network_peering bastion2cms {
  name         = "${var.install_name}-bastion2cms"
  network      = data.google_compute_network.default.self_link
  peer_network = google_compute_network.cms_network.self_link
  #auto_create_routes = true
}

resource google_compute_network_peering cms2bastion {
  name         = "${var.install_name}-cms2bastion"
  network      = google_compute_network.cms_network.self_link
  peer_network = data.google_compute_network.default.self_link
  #auto_create_routes = true
}

## Peer VPCs with MFVP project
#resource "google_compute_network_peering" "tvaas_peering_cms_mfvp" {
#  name               = "${var.install_name}-tvaas-peering-cms-mfvp"
#  network            = "${google_compute_network.cms_network.self_link}"
#  peer_network       = "https://www.googleapis.com/compute/v1/projects/tvaas-poc-mfvp/global/networks/tvaas-mfvp"
#  auto_create_routes = true
#}
#
## Peer VPCs with VSPP project
#resource "google_compute_network_peering" "tvaas_peering_mfvp_vspp" {
#  name               = "${var.install_name}-tvaas-peering-mfvp-vspp"
#  network            = "${google_compute_network.cms_network.self_link}"
#  peer_network       = "https://www.googleapis.com/compute/v1/projects/tvaas-poc-vspp/global/networks/default"
#  auto_create_routes = true
#}

resource google_compute_subnetwork subnet_cms_cluster {
  name          = "${var.install_name}-subnet-cms-cluster"
  ip_cidr_range = var.gcp_subnet
  region        = var.region
  network       = google_compute_network.cms_network.name
  #private_ip_google_access = "true"
}

resource google_compute_firewall admin_ingress {
  name    = "${var.install_name}-admin-ingress"
  network = google_compute_network.cms_network.name
  priority = 1001
  # The source_ranges should include the GCP IP range "130.211.0.0/22", "35.191.0.0/16" for health check request
  source_ranges = concat([var.bastion_public_cidr], var.admin_whitelist)
  allow {
    #protocol = "TCP"
    #ports    = concat(var.cs_ports, var.ui_ports, var.external_ct_ports, var.prepack_ports)
    protocol = "all"
  }

  direction = "INGRESS"
}

resource google_compute_firewall healthcheck_ingress {
  name    = "${var.install_name}-healthcheck-ingress"
  network = google_compute_network.cms_network.name
  priority = 1002
  # The source_ranges should include the GCP IP range "130.211.0.0/22", "209.85.152.0/22", "209.85.204.0/22", "35.191.0.0/16" for health check request
  source_ranges = ["130.211.0.0/22", "209.85.152.0/22", "209.85.204.0/22", "35.191.0.0/16"]
  allow {
    protocol = "TCP"
    ports    = ["8501"]
  }

  direction = "INGRESS"
}

resource google_compute_firewall ui_ingress {
  name    = "${var.install_name}-ui-ingress"
  network = google_compute_network.cms_network.name
  priority = 1003
  # The source_ranges should include the GCP IP range "130.211.0.0/22", "35.191.0.0/16" for health check request
  source_ranges = var.external_whitelist
  allow {
    protocol = "TCP"
    ports    = var.ui_ports
  }
  # Only apply to CS nodes as load-balancer target
  target_tags = ["ui-target-node"]
  direction = "INGRESS"
}

resource google_compute_firewall defaut_internal_ingress {
  name    = "${var.install_name}-default-internal-ingress"
  network = google_compute_network.cms_network.name

  source_ranges = ["10.128.0.0/9", var.gcp_subnet, "${google_compute_address.nat_ip.address}/32"]

  allow {
    protocol = "all"
  }

  direction = "INGRESS"
}

resource google_compute_firewall defaut_egress {
  name    = "${var.install_name}-default-egress"
  network = google_compute_network.cms_network.name

  allow {
    protocol = "all"
  }

  direction = "EGRESS"
}
