#!/bin/bash
#update_instance_metadata.sh <HOSTNAME> <HOSTDOMAIN>

HOSTNAME=$1
HOSTDOMAIN=$2

INSTANCENAME=$(curl -H "Metadata-Flavor: Google" http://metadata.google.internal/computeMetadata/v1/instance/name)
INSTANCEZONE=$(curl -H "Metadata-Flavor: Google" http://metadata.google.internal/computeMetadata/v1/instance/zone)

## Add hostname into GCP internal metadata server
SCTOKEN=$(curl -H "Metadata-Flavor: Google" "http://metadata.google.internal/computeMetadata/v1/instance/service-accounts/default/token"|jq .access_token)
curl https://compute.googleapis.com/compute/v1/$INSTANCEZONE/instances/$INSTANCENAME -H "Authorization":"Bearer $SCTOKEN" |jq .metadata > /home/instance_meta.json
sed -i '/"items":/a{ "key": "hostname", "value": "'${HOSTNAME}'.'${HOSTDOMAIN}'" },' /home/instance_meta.json
curl -X POST https://compute.googleapis.com/compute/v1/$INSTANCEZONE/instances/$INSTANCENAME/setMetadata -H "Authorization":"Bearer $SCTOKEN" -H "Content-Type: application/json" -d @/home/instance_meta.json

## Create label 
LABELFP=$(curl https://compute.googleapis.com/compute/v1/$INSTANCEZONE/instances/$INSTANCENAME -H "Authorization":"Bearer $SCTOKEN" |jq .labelFingerprint)
curl -X POST https://compute.googleapis.com/compute/v1/$INSTANCEZONE/instances/$INSTANCENAME/setLabels -H "Authorization":"Bearer $SCTOKEN" -H "Content-Type: application/json" -d '{ "labels": { "node": "'${HOSTNAME}'" }, "labelFingerprint": '${LABELFP}' }'
