resource google_compute_instance_template pt_template {
  name        = "${var.install_name}-pt-template"
  #depends_on = ["data.google_compute_instance.cs_server"]
  depends_on = [google_compute_address.cs_with_subnet_and_address]
  machine_type = var.dev_mode ? var.gcp_instance_type_pt_dev : var.gcp_instance_type_pt

  disk {
    source_image = "centos-cloud/centos-7"
    auto_delete  = true
    boot         = true
    disk_type    = "pd-standard"
    disk_size_gb = var.dev_mode ? var.pt_disk_size_dev : var.pt_disk_size
  }

  network_interface {
    subnetwork = google_compute_subnetwork.subnet_cms_cluster.name
    #network_ip = element(
    #  google_compute_address.cs_with_subnet_and_address.*.address,
    #  count.index,
    #)
    // //access_config = {}
  }

  #depends_on = [google_compute_instance.cs]

  #metadata_startup_script = "sed -i 's/enabled=1/enabled=0/g' /etc/yum.repos.d/epel.rep"
  metadata_startup_script = "sed -i 's/enabled=1/enabled=0/g' /etc/yum.repos.d/epel.repo;curl -O http://${google_compute_instance.cs[0].network_interface.0.network_ip}:8008/startup.tgz;tar -xzf startup.tgz;/bin/bash /opt/vmTools/scripts/pt.sh ${google_compute_instance.cs[0].network_interface.0.network_ip} $(date -u +%Y%m%d%H%M%S%2N) ${var.cms_hostname_pt} ${var.cms_dns_domain}"

  metadata = {
    ssh-keys = "${var.ssh_user}:${file(var.public_key_path)}"
    #shutdown-script = "sudo sh /opt/vmTools/scripts/deregister_node.sh"
  }

  service_account {
    scopes = ["compute-rw"]
  }
}

# Region Instance Group Manager for HA
resource google_compute_region_instance_group_manager pt_region_igm {
  name = "${var.install_name}-pt-region-igm"
  depends_on = [google_sql_database_instance.cloudsql_master,null_resource.cs_installcms]

  base_instance_name         = "${var.install_name}-pt"
  version {
    instance_template          = google_compute_instance_template.pt_template.self_link
  }
  region                     = var.region
  distribution_policy_zones  = var.instance_group_zones

  update_policy {
    # PROACTIVE or OPPORTUNISTIC 
    type                         = "OPPORTUNISTIC"
    # PROACTIVE or NONE
    instance_redistribution_type = "NONE"
    # REPLACE or RESTART
    minimal_action               = "RESTART"
    #max_surge_percent            = 20
    max_unavailable_fixed        = length(var.instance_group_zones)
    #min_ready_sec                = 50
  }

  target_size                = var.pt_count
  wait_for_instances         = true

}

# Get the created instance group for fetching the created Instances
data google_compute_region_instance_group pt_group {
    #count = "${ (var.pt_count == 0 ? 0 : 1) }"
    name = google_compute_region_instance_group_manager.pt_region_igm.name
    depends_on = [google_compute_region_instance_group_manager.pt_region_igm]
}


# Get the Instances created from the instance group
data google_compute_instance pt_server {
    count      = var.pt_count
    self_link  = data.google_compute_region_instance_group.pt_group.instances[count.index].instance
    depends_on = [google_compute_region_instance_group_manager.pt_region_igm]
}


# call by other resource by
# "${data.google_compute_instance.pt_server[count.index].network_interface.0.network_ip}"
output PT_IP_Address {
  #value = "${data.azurerm_public_ip.cs_pub_ip.*.ip_address}"
  value = data.google_compute_instance.pt_server.*.network_interface.0.network_ip
  depends_on = [google_compute_region_instance_group_manager.pt_region_igm,data.google_compute_instance.pt_server]
}

resource null_resource pt_checklogs {
  count = var.pt_count
  depends_on = [null_resource.cs1_prepare_rpm,data.google_compute_instance.pt_server]

  connection {
    host = data.google_compute_instance.pt_server[count.index].network_interface.0.network_ip
    type = "ssh"
    user = var.ssh_user
    private_key = "${file(var.private_key_path)}"
    #timeout     = "60m"
  }
  provisioner remote-exec {
    inline = [
      "sudo timeout 1800 bash /opt/vmTools/scripts/checklogs.sh && [[ $? -eq 0 ]] || if [[ $${PIPESTATUS[0]} -eq 124 ]];then echo 'Installation Timeout!!';exit 1; else exit 1;fi",
    ]
  }
}
