DISK_ID=$(curl http://metadata.google.internal/computeMetadata/v1/instance/attributes/device_name -H "Metadata-Flavor: Google")
INSTANCE_IP=$(curl http://metadata.google.internal/computeMetadata/v1/instance/network-interfaces/0/ip -H "Metadata-Flavor: Google")
NFS_STORAGE_PATH=/var/nfsshare



if file -Ls /dev/disk/by-id/${DISK_ID} | grep filesystem ; then
  echo "Disk already has filesystem on it. Skipping."
else
  echo "Disk unformated. Formating disk in ext4 filesystem..."
  mkfs.ext4 -m 0 -F -E lazy_itable_init=0,lazy_journal_init=0,discard /dev/disk/by-id/${DISK_ID}
fi

# Mount persistent disk
mkdir -p ${NFS_STORAGE_PATH}
cp /etc/fstab /etc/fstab.backup
DISK_UUID=$(blkid -s UUID -o value /dev/disk/by-id/${DISK_ID})
DISK_FS=$(blkid -s TYPE -o value /dev/disk/by-id/${DISK_ID})
echo "UUID=${DISK_UUID} ${NFS_STORAGE_PATH} ${DISK_FS} discard,defaults,nofail 0 2" >> /etc/fstab
mount -a

#Create nfs
yum install -y nfs-utils
chown nfsnobody:nfsnobody ${NFS_STORAGE_PATH}
mkdir  ${NFS_STORAGE_PATH}/app
mkdir  ${NFS_STORAGE_PATH}/content
mkdir  ${NFS_STORAGE_PATH}/ct-app
mkdir  ${NFS_STORAGE_PATH}/ct-content
chown 99:99 ${NFS_STORAGE_PATH}/app
chown 99:99 ${NFS_STORAGE_PATH}/content
chown 99:99 ${NFS_STORAGE_PATH}/ct-app
chown 99:99 ${NFS_STORAGE_PATH}/ct-content
chmod -R 755 ${NFS_STORAGE_PATH}
systemctl enable rpcbind
systemctl enable nfs-server
systemctl enable nfs-lock
systemctl enable nfs-idmap
systemctl start rpcbind
systemctl start nfs-server
systemctl start nfs-lock
systemctl start nfs-idmap
echo "${NFS_STORAGE_PATH}   *(rw,sync,no_root_squash,no_all_squash)" >> /etc/exports
exportfs -a
