## CMS Terraform scripts for GCP deployment.


### Overview
The Terraform scripts provision a set of resources in GCP (Google Cloud Platform) and install the CMS.
* GCP Resources provisioned by the scripts include:
  * VPC network for CMS.
  * VPC Firewall rules.
  * VM instance templates for APP cluster type, ES cluster type, PT cluster type, CT cluster type.
  * VM instance for CS nodes, APP nodes, ES nodes, PT nodes, CT nodes.
  * VM instance as internal NFS server (optional).
  * VM instance groups for CS nodes.
  * VM regional managed instance groups for APP nodes, ES nodes, PT  nodes, CT nodes.
  * Cloud SQL instance as CMS DB.
  * Public Static IP as CMS external VIP.
  * Internal static IP as CMS internal VIP.
  * Cloud NAT IP.
  * Backend service as internal Load Balancer.
  * Target Pool as external Load Balancer.
  * Forwarding rules for openning ports in external Load Balancer.


### Prerequisites
1. User should have basic knowledge about [terraform cli](https://www.terraform.io/docs/commands/index.html).
2. User should have basic knowledge about GCP bastion VM instance.
3. User should have advanced knowledge about Linux OS operations.
4. GCP project and account are ready for deploying CMS.
5. Terraform v0.12 has been installed in the bastion VM instance.


### Required CMS Installation Packages
* CMS Software Packages RPM (cms-swo-repo-x.x.xxx.xxx-0.el7.noarch.rpm).
* CMS Installer RPM (cmsinstaller-x.x.xxx.xx-0.noarch.rpm).
* CMS Terraform Scripts (cmsform-gcp-x.x.xxx.xx.tar.gz).
* (Optional) CMS Prepack Installer RPM (cms-prepack-installer-x.x.xxx-xxxxxx.noarch.rpm).
* (Optional) CMS Prepack Packages RPM (cms-prepack-repo-x.x.xxx-xxxxxx.noarch.rpm).


### Steps for deploying CMS on GCP
**1. Prepare GCP bastion VM instance.**
   * Create GCP VM instance follow the [GCP How-to Guide](https://cloud.google.com/compute/docs/quickstart-linux). 
   <br>**Note:**  *When creating bastion VM, choose `Allow full access to all Cloud APIs` option for ***Access scopes***.*
   * Create SSH key and configure the SSH access for bastion VM follow the [GCP Guide](https://cloud.google.com/compute/docs/instances/adding-removing-ssh-keys).
   * Login to bastion VM and install terraform v0.12 follow the [terraform guide](https://www.terraform.io/downloads.html).

**2. Prepare the CMS terraform scripts.**
   * Put cmsform-gcp-x.x.xxx.xx.tar.gz to the GCP bastion VM and extract this gz file.
```bash
tar -xvzf cmsform-gcp-x.x.xxx.xx.tar.gz
```
   * You will get a new folder *cmsform* with below subfolders.
   *<br> - GCP*
   *<br> - config_templates*
   *<br> - vmTools*
   *<br> - scripts*
   *<br> - prepackTools*

**3. Prepare the CMS RPMs.**
   * Put below CMS RPMs to the GCP bastion VM by SCP or FTP or any other physical method.
   *<br> - CMS Software Packages RPM*
   *<br> - CMS Installer RPM*
   * Move the rpms to a dedicated folder
   <br>*For example, /home/packages*
   <br>**Note:**  *Make sure this folder can be accessed by user running the terraform scripts.*
   * Update the full path of this folder into field *package_location* in the [customized deployment variable file](#samplevariablesfile).

**4. Prepare the CMS license file.**
   * Get CMS license.xml file and put the file to the GCP bastion VM under the folder *cmsform* created in step 2.
   * Update the License Fingerprint into field *cms_license_fingerprint* in the [customized deployment variable file](#samplevariablesfile) 

**5. Prepare the SSH key files.**
   * Create SSH key pare based on user's own security requirement. User can refer to [GCP Guide](https://cloud.google.com/compute/docs/instances/adding-removing-ssh-keys) for some information.
   * Put the generated key file and key.pub file to the GCP bastion VM.
   <br>*Key pare example: cms-ssh-key, cms-ssh-key.pub*
   * Update the full path of the key pair files into fields *private_key_path* and *public_key_path* in the [customized deployment variable file](#samplevariablesfile).

**6. (Optional) Prepare the Prepack RPMs.**
   * Put below Prepack RPMs to the GCP bastion VM by SCP or FTP or any other physical method.
   *<br> - CMS Prepack Installer RPM*
   *<br> - CMS Prepack Packages RPM*
   * Move the rpms to a dedicated folder
   <br>*For example, /home/prepack_packages*
   <br>**Note:** *Make sure this folder can be accessed by user running the terraform scripts.*
   * Update the full path of this folder into field *prepack_package_location* in the [customized deployment variable file](#samplevariablesfile).

**7. (Optional) Prepare the Prepack license file.**
   * Get Prepack license.xml file and put the file to the GCP bastion VM under the folder *prepack_packeages* created in step 6.

**8. (Optional) Prepare the Prepack pre-configure json file.**
   * Prepare the preconfigured components selection file named ***preconfigSelection.json*** file and put the file to the GCP bastion VM under the folder *prepack_packeages* created in step 6.
   <br>**Note:** Prepare the preconfigSelection.json file follow the *Prepack InstallationDeployment Guide* section *5.2.1 Configuring JSON File*.

**9. Prepare the customized deployment variable file.**
   * Create a \<anyname\>.tfvars file on the GCP bastion VM, e.g. ~/cmsform/GCP/sample.tfvars.
   * Edit this file with variables that need customized value.
   <br>*Refer to section [Variables](#variables) for all available variables.*
   <br>*- Pay attention to those variables that need customized.*
   <br>*Read below sections to decide the values for significant variables.*
   *<br> - [Recommanded VM size](#recommanded-vm-size)*
   *<br> - [About Regions and Zones](#about-regions-and-zones)*
   *<br> - [About Storage](#about-storage)*
   *<br> - [About Instance Groups](#about-instance-groups)*
   *<br> - [About External CT node](#about-external-ct-node)*
   *<br> - [About Prepack Installation](#about-prepack-installation)*
   *<br>Example tfvars file as below.*
```bash
#vi ~/cmsform/GCP/sample.tfvars
install_name = "gcp-cms-test"
cms_license_fingerprint = "01234567890123456789012345678901"
admin_whitelist         = ["120.1.10.1/32", "120.236.1.6/32"]
external_whitelist      = ["120.236.1.9/32", "192.176.1.0/24"]
bastion_gcp_vpc_name    = "bastion"
bastion_public_cidr     = "192.168.0.0/24"
timezone     = "America/Los_Angeles"
cs_count     = 3
app_count    = 3
es_count     = 3
pt_count     = 1
ct_count     = 0
cloud_ext_ct = true
ssh_user     = "test"
private_key_path = "/home/cmsform/cms-ssh-key"
public_key_path  = "/home/cmsform/cms-ssh-key.pub"
package_location = "/home/packages"
install_prepack  = true
prepack_package_location = "/home/prepack_packages"
```

**10. Run scripts to deploy CMS.**
   * Login to the GCP bastion VM and change to the terraform scripts directory
```bash
#e.g.
cd ~/cmsform/GCP
```
   * Make sure the customized deployment variable file, *e.g. sample.tfvars*, is inside this folder as well. 
   * Run scripts with below commands.
```bash
sudo terraform init -upgrade
sudo terraform plan -var-file=sample.tfvars -out=gcpcms.tfplan
sudo terraform apply gcpcms.tfplan
```

**11. Check resources created and login CS1 node.**
   * From GCP Console portal, navigate to *Computer Engine* -> *VM instances*.
   * Get the internal IP address of VM instance named as *<install_name>-cs-0*.
   <br>User can then login CS1 node with ssh command from the GCP bastion VM, with the ssh key file prepared in step 5.
``` bash
ssh -i <private_key_path> <ssh_user>@<CS1_Internal_IP_Address>
```

**12. (Optional) Start all cms services from CS1 node after cms and all CT nodes installation finished.**
   * This step is only necessary when there is external CT node deployed.
   * Login CS1 node with the installer user and start all cms services with below command.
```bash
service cms-cluster start -f
```

**13. Login CMS UI.**
   * From GCP Console portal, navigate to *VPC network* -> *External IP addresses*.
   * Get the IP address of External IP Address named *<install_name>-\<region\>-cs-ip-external*.
   <br>User can then browse to CMS UI with this IP.
``` bash
https://<External_IP_Address>:8443/portal
```


### Recommanded VM size
   * Set variable *dev_mode* to `false` will use the recommanded VM size for production deployment.
   * For more VM size information, refer to [Machine Type](https://cloud.google.com/compute/docs/machine-types).
   * CMS VM size related variables recommanded value for GCP production deployment as below.

Variable|Value
:-|:-
gcp_instance_type_cs|"n1-highmem-4"
gcp_instance_type_app|"n1-standard-16"
gcp_instance_type_es|"n1-highmem-4"
gcp_instance_type_pt|"n1-standard-1"
gcp_instance_type_ct|"n1-standard-16"
gcp_db_tier|"db-custom-8-15360"
cs_disk_size|"300"
app_disk_size|"100"
es_disk_size|"500"
pt_disk_size|"100"
ct_disk_size|"100"


### About Regions and Zones
   * GCP operates in multiple datacenters around the world. These datacenters are grouped in to geographic regions, giving you flexibility in choosing where to build your applications. For more detail, refer to [Cloud Locations](https://cloud.google.com/about/locations/).
   * Choose the desired region and set the value in variable *region*.
   * Choose the desired zones and set the value in variable *instance_group_zones*.


### About Storage
   * NFS VM vs. Shared VPC File Store
      * NFS VM
        <br>The CMS terraform scripts will create a dedicated VM running NFS service as an internal NAS server by default. However, this internal NAS is not accessible for other VPC. That means it is not accessible for other 3PP device (e.g. MKEOD) or downstream systems (e.g. VSPP). Also this internal NAS has no HA nor Redundent capability.
      * GCP File Store
        <br>For production setup, it is highly recommanded to setup [GCP File Store](https://cloud.google.com/filestore/docs/how-to) inside [shared VPC](https://cloud.google.com/vpc/docs/provisioning-shared-vpc), which is accessible for all integreted systems. 
        <br>*Please note the Shared VPC and File Store resources are not in the scope of CMS terraform scripts, user need to create them manually.*
        <br>User then need to provide the File Store mount points into the customized deployment variable file.
        <br>When using the File Store from shared VPC, no need to setup internal NAS any more. User can set variable *setup_nfs* with value `false`.
```bash
#cat ~/cmsform/GCP/sample.tfvars
install_name = "gcp-cms-test"
...
setup_nfs             = false
#e.g.
cms_nas_server        = "<ip_of_gcp_file_store>"
cms_nas_share         = "/nfs/cms_app"
content_nas_server    = "<ip_of_gcp_file_store>"
content_nas_share     = "/nfs/cms_content"
ct_cms_nas_server     = "<ip_of_gcp_file_store>"
ct_cms_nas_share      = "/nfs/cms_ct_app"
ct_content_nas_server = "<ip_of_gcp_file_store>"
ct_content_nas_share  = "/nfs/cms_ct_content"
...
```


### About Instance Groups
   * **Unmanaged instance groups for CS nodes**
   <br>Each CS node will be associated with one unmanaged [Instance Group](https://cloud.google.com/compute/docs/instance-groups/). Purpose for such deployment is to setup internal load balance backend service. 
   <br>User can trigger Start, Stop, Reset operations towards these CS instances normally. 

   * **Region managed instance groups for APP, ES, PT, CT nodes**
   <br>Other than CS node type, all the other nodes will be created inside node type (APP, ES, PT, CT) specific [Region Managed Instance Group](https://cloud.google.com/compute/docs/instance-groups/distributing-instances-with-regional-instance-groups).
   
     There are advantages and disadvantages with Region Managed Instance Group.
     * [Advantages](https://cloud.google.com/compute/docs/instance-groups/)
     * Disadvantages
       * User can not trigger the Stop operation towards the VM instance inside the Managed Instance Group.
       * Once the VM is powered off by command 'shutdown' form the VM OS, the instance will be deleted from the Managed Instance Group. 

     ***Notes:*** 
     <br>- *User can move the VM instance outside the Managed Instance Group to enable the VM Stop operation without deleting the instance. However, the VM instance can not be moved back to the instance group any more.*
     <br>- *Move the VM instance outside the Managed Instance Group will not impact the CMS function but will lose the Advantages.*


### About External CT node
   * **Related variables**
   <br>Set *ct_count* with `0` and *cloud_ext_ct* to `ture` when CMS is to be deployed with external CT nodes.
   * **External CT node Installation** 
   <br>After CMS is deployed in GCP successfully, follow the steps in Installation Guide section *External CT Node Deployment* to install external CT nodes.
   * **NAT**
   <br>Since external CT node is deployed inside customer's data-center, it could be behind a firewall and exported with a natted IP. In such case, user need to enable the firewalld service in all CS nodes and APP nodes and configure some firewall rules to route the outgoing messages to the CT node's natted IP.
   <br>Refer to Installation Guide section *Configuring Iptables NAT Rules (Optional)* for setting up the firewall rules on CS and APP nodes.
   * **Firewall Ports**
   <br>The external CT nodes should have below ports (TCP by default) opened for CS and APP nodes.

Service|Cloud resource|Cloud Port|Direction|Firewall Port|OnPremise Node
:-|:-|:-|:-:|:-|:-
Consul|External LB|8501|<-----|XX|Content Server
Workflow|External LB|7070|<-----|XX|Content Server
Elasticsearch|External LB|9200|<-----|XX|Content Server
Kibana|External LB|9292|<-----|XX|Content Server
RPM-Repo|External LB|8008|<-----|XX|Content Server
Redis|External LB|6379|<-----|XX|Content Server
RabbitMQ|External LB|5672|<-----|XX|Content Server
DNS|External LB|53(TCP and UDP)|<-----|XX|Content Server
cmstomcat|CS nodes|XX|----->|8081|Content Server
cms|CS nodes|XX|----->|8444|Content Server
FTP|CS nodes|XX|----->|21|Content Server
FTP|CS nodes|XX|----->|10000-10199|Content Server
ADI|CS nodes|XX|----->|5000|Content Server
cmstomcat|APP nodes|XX|----->|8081|Content Server
cms|APP nodes|XX|----->|8444|Content Server


### About Prepack Installation
   * Set variable *install_prepack* to `true` will run the prepack installation automatically during CMS deployment.
   <br> - ***Note:*** *Prepack installation will never be triggered automatically when CMS deployed with external CT node. User have to follow the Prepack Installation and Deployment Guide to install prepack manually after external CT node get installed.*
   * This terraform scripts only installs prepack, user still need to follow the prepack configuration guide to configure Prepack after installation finished.
   * User need to create GCP [VPC network peering](https://cloud.google.com/vpc/docs/vpc-peering) manually for 3PP device or downstream connections.
   * User need to follow Preapck Configuration Guide section 3 *Cluster Expansion* to expant prepack on new node after enlarging the instance number of APP managed instance group or CT managed instance group. 


### <span id="jump_variables">Variables</span>

Variable Name|Description|Default Value|Need Customized
:-|:-|:-|:-
project|Project ID on GCP for the CMS deployment.|"tvaas-poc"|*
region|The GCP location for the CMS deployment.|"us-west1"|*
instance_group_zones|The expected Zones within the region where the instances will be created at.|["us-west1-a", "us-west1-b", <br>"us-west1-c"]|*
bastion_gcp_vpc_name|The GCP VPC network to which the bastion VM belong.|"bastion"|*
bastion_public_cidr|The network IP cidr to which the bastion VM belong.|["192.168.0.0/24"]|*
admin_whitelist|Networks to allow admin connectivity from, fill with cidr format. Replace with corporate public IP address range from corporate Nat/gateway.|["192.168.0.0/24"]|*
external_whitelist|Networks to allow external connectivity from, mainly for UI access, fill with cidr format. Replace with corporate public IP address range from corporate Nat/gateway.|["192.168.0.0/24"]|*
external_ftp_clients|The IP addresses for external ftp clients that are allowed to access the CMS content data.|["192.168.0.0/24"]|*
ui_ports|Accessible CMS UI ports.|["8443", "16443"]|
external_access_ports|CMS load balanced ports for external nodes, e.g. CT node, to access.|["6379", "8501", "9200", <br>"9292"]|
prepack_ports|CMS load balanced ports for Prepack solution.|["21", "6003"]|
cs_ports|Accessible CMS ports for CS nodes|["5601", "9090", "9393", <br>"5672", "5671", "7070", <br>"5000"]|
ftp_data_ports|Ports for FTP data transfer, 10000-10099 for APP1, 10100-10199 for APP2, 10200-10299 for APP3, and so on.|"10000-10299"
gcp_vpc_cidr|The CIDR of the VPC to be created for the CMS deployment.|"10.1.0.0/16"|
gcp_subnet|The CIDR of the Subnet to create within the VPC. All VMs are created in this subnet, which is broken up into smaller subnets for each availability zone. Must be a valid subnet of the VPC cidr.|"10.1.0.0/24"|
install_name|Textual Name of this CMS Install as Installation Identifier, every concurrent deployment needs a unique install name.||*
app_count|Number of application nodes to deploy.|1|*
cs_count|Number of Cluster Service nodes to deploy.|1|*
es_count|Number of ElasticSearch nodes to deploy.|1|*
pt_count|Number of Portal nodes to deploy.|0|*
ct_count|Number of Content Transport nodes to deploy.|0|*
cloud_ext_ct|To determine whether CT nodes need to be installed inside or outside GCP.|false|*
dev_mode|True to run in development mode with smaller/cheaper instance types. Set this to true when deploy CMS for production.|false|
setup_nfs|Ture to create an additional VM instance dedicated for running nfs service as build-in NAS server. For production, recommand to set it to false and user should use a customer provided NAS server.|true|*
nfs_disk_size|Number of GB of disk space to alloate to build-in NFS Server instances when dev_mode is false.|"2048"|
mount_options|The mount options for share folders.|["nolock", "nfsvers=4.1"]|
remount|Enable/disable remount as a mount option.|false|
cms_nas_type|The type of nas server for cms app and content folders.|"nfs"|
cms_nas_server|The IP address of nas server for cms app folder.|"10.0.0.5"|*
content_nas_server|The IP address of nas server for cms app folder.|"10.0.0.5"|*
ct_nas_type|The type of nas server for cms app and content folders on CT nodes.|"nfs"|
ct_cms_nas_server|The IP address of nas server for cms app folder.|"10.0.0.5"|*
ct_content_nas_server|The IP address of nas server for cms app folder.|"10.0.0.5"|*
cms_nas_share|The nas share folder for cms.|"/var/nfsshare/app"|*
content_nas_share|The nas share folder for content.|"/var/nfsshare/content"|*
ct_cms_nas_share|The nas share folder for cms.|"/var/nfsshare/ct-app"|*
ct_content_nas_share|The nas share folder for content.|"/var/nfsshare/ct-content"|*
gcp_instance_type_nfs|The GCP Instance Type to use for CMS Cluster Server Instances.|"n1-highmem-4"|
gcp_instance_type_nfs_dev|The GCP Instance Type to use for CMS Cluster Server Instances in development mode.|"n1-standard-1"|
gcp_instance_type_cs|The GCP Instance Type to use for CMS Cluster Server Instances.|"n1-highmem-4"|
gcp_instance_type_cs_dev|The GCP Instance Type to use for CMS Cluster Server Instances in development mode.|"n1-standard-2"|
gcp_instance_type_app|The GCP Instance Type to use for CMS Application Server Instances.|"n1-standard-16"|
gcp_instance_type_app_dev|The GCP Instance Type to use for CMS Application Server Instances in development mode.|"n1-standard-2"|
gcp_instance_type_es|The GCP Instance Type to use for CMS Elastic Search Server Instances. |"n1-highmem-4"|
gcp_instance_type_es_dev|The GCP Instance Type to use for CMS Elastic Search Server Instances in development mode.|"n1-standard-2"|
gcp_instance_type_pt|The GCP Instance Type to use for CMS Portal Server Instances.|"n1-standard-1"|
gcp_instance_type_pt_dev|The GCP Instance Type to use for CMS Portal Server Instances.|"n1-standard-1"|
gcp_instance_type_ct|The GCP Instance Type to use for CMS Portal Server Instances.|"n1-standard-16"|
gcp_instance_type_ct_dev|The GCP Instance Type to use for CMS Portal Server Instances.|"n1-standard-2"|
gcp_db_tier|The GCP PostgreSQL Instances type.|"db-custom-8-15360"|
gcp_db_tier_dev|The GCP PostgreSQL Instances type in development mode.|"db-custom-8-15360"|
cs_disk_size|Number of GB of additional space to alloate to Cluster Server instances.|"300"|
cs_disk_size_dev|Number of GB of additional space to alloate to Cluster Server instances in dev mode.|"20"|
app_disk_size|Number of GB of additional space to alloate to Cluster Server instances."""|"100"|
app_disk_size_dev|Number of GB of additional space to alloate to Cluster Server instances in dev mode.|"20"|
es_disk_size|Number of GB of additional space to alloate to Cluster Server instances.|"500"|
es_disk_size_dev|Number of GB of additional space to alloate to Cluster Server instances in dev mode.|"20"|
pt_disk_size|Number of GB of additional space to alloate to Cluster Server instances.|"100"|
pt_disk_size_dev|Number of GB of additional space to alloate to Cluster Server instances in dev mode.|"10"|
ct_disk_size|Number of GB of additional space to alloate to Cluster Server instances.|"100"|
ct_disk_size_dev|Number of GB of additional space to alloate to Cluster Server instances in dev mode.|"20"|
cms_license_fingerprint|CMS Installation License Fingerprint, should match with the fingerprint in CMS license file.|"00000000000000000000000000000000"|*
license_file_path|Path to CMS license file.|"../license.xml"|*
cms_hostname_cs|The hostname prefix for the Cluster Server Instance.|"cms-cs"|
cms_hostname_app|The hostname prefix for the Application Server Instance.|"cms-app"|
cms_hostname_es|The hostname prefix for the Elastic Search Server Instance.|"cms-es"|
cms_hostname_pt|The hostname prefix for the Portal Server Instance.|"cms-pt"|
cms_hostname_ct|The hostname prefix for the Content Server Instance.|"cms-ct"|
cms_dns_domain|Network Domain name for CMS Instances.|"mediakind.local"|
timezone|Timezone to run the Instances in.|"America/Los_Angeles"|
ntp1|The IP address or FQDN of first ntp server.|"0.rhel.pool.ntp.org"|
ntp2|The IP address or FQDN of second ntp server.|"1.rhel.pool.ntp.org"|
snmp_server|The IP address or FQDN of SNMP server.|"127.0.0.1"|
gcp_os_image|GCP image name for VM Operation System.|"centos-cloud/centos-7"|
private_key_path|The path of the ssh private key the bastion will use to configure instances.|"~/.ssh/test"|*
public_key_path|The path of the ssh pub key the bastion will use to configure instances.|"~/.ssh/test.pub"|*
ssh_user|User name as the CMS install user.|"test"|*
db_version|Use this to set the db version for RDS instance creation.|"POSTGRES_9_6"|
sql_ha_type|SQL availability_type, ZONAL for non-ha, REGIONAL for ha.|"ZONAL"|
db_name|Use this to set the db name for RDS instance creation.|"ttv"|
db_port|Use this to set the db port for RDS instance creation.|"5432"|
db_user|Use this to set the db user for RDS instance creation.|"postgres"|
db_pass|Use this to set the db password for RDS instance creation.|"n2Cdf92j"|
package_location|Location of CMS packages to install.|"../packages"|*
session_affinity|The session affinity for the backends example: NONE, CLIENT_IP.|"NONE"|
install_prepack|Indicator for whether to run prepack installation or not.|false|*
prepack_package_location|Location of Prepack packages to install.|"../prepack_packages"|*
prepackVersion|The release version of prepack.|"5.1.000-SNAPSHOT"|*
config_install_sysInfo_template|PrePack install sysInfo file.|"../prepackTools/install_sysInfo.tpl"|
cmsUser|User for connecting to CMS API.|"admin"|
cmsPassword|Password for connecting to CMS API.|"admin"|
cmsDBUser|User name for connecting to CMS DB.|"wfs"|
