# Build number: 8.0.000.7

# CMS Configuration config.json files
resource template_dir config {
  #source_dir      = "${path.module}/config_templates"
  source_dir      = "../config_templates"
  destination_dir = "${path.cwd}/config"

  vars = {
    customerLicenseId = var.cms_license_fingerprint
    privateNetmask    = cidrnetmask(var.gcp_subnet)
    # DNS services are on .2 of the vpc subnet by AWS
    # due to google set it to 8.8.8.8
    vpc_dns        = "8.8.8.8"
    consul_servers = var.cs_count >= 3 ? "\"cs1\",\"cs2\",\"cs3\"" : "\"cs1\""
    named_master = element(
      flatten(google_compute_instance.cs.*.network_interface.0.network_ip),
      0,
    )
    named_slaves = jsonencode(
      slice(
        flatten(google_compute_instance.cs.*.network_interface.0.network_ip),
        1,
        length(
          flatten(google_compute_instance.cs.*.network_interface.0.network_ip),
        ),
      ),
    )
    cms_nas_type          = var.setup_nfs ? "nfs" : var.cms_nas_type
    ct_nas_type           = var.setup_nfs ? "nfs" : var.ct_nas_type
    cms_nas_server        = var.setup_nfs ? google_compute_instance.nfs[0].network_interface[0].network_ip : var.cms_nas_server
    cms_nas_share         = var.setup_nfs ? "/var/nfsshare/app" : var.cms_nas_share
    content_nas_server    = var.setup_nfs ? google_compute_instance.nfs[0].network_interface[0].network_ip : var.content_nas_server
    content_nas_share     = var.setup_nfs ? "/var/nfsshare/content" : var.content_nas_share
    ct_cms_nas_server     = var.setup_nfs ? google_compute_instance.nfs[0].network_interface[0].network_ip : var.ct_cms_nas_server
    ct_cms_nas_share      = var.setup_nfs ? "/var/nfsshare/ct-app" : var.ct_cms_nas_share
    ct_content_nas_server = var.setup_nfs ? google_compute_instance.nfs[0].network_interface[0].network_ip : var.ct_content_nas_server
    ct_content_nas_share  = var.setup_nfs ? "/var/nfsshare/ct-content" : var.ct_content_nas_share
    mountOptions          = join(",", var.mount_options)
    remount               = var.remount
    privateDomain      = var.cms_dns_domain
    ui_eip             = google_compute_address.cs_vip_external.address
    app_eip            = google_compute_address.cs_vip_internal.address
    timezone           = var.timezone
    dbserver           = google_sql_database_instance.cloudsql_master.private_ip_address
    snmpServer         = var.snmp_server
    privateNetwork     = cidrhost(var.gcp_subnet, 0)
    customerInstanceId = var.customerInstanceId
    installName        = var.install_name
    cloudextct         = var.cloud_ext_ct ? true : false
    hasct              = ((var.ct_count > 0 ? 1: 0) + (var.cloud_ext_ct ? 1: 0 )) >= 1 ? true: false
  }
}