resource google_compute_address cs_vip_internal {
  name         = "${var.install_name}-${var.region}-cs-ip-internal"
  region       = var.region
  subnetwork   = google_compute_subnetwork.subnet_cms_cluster.name
  address_type = "INTERNAL"
}

resource google_compute_address cs_vip_external {
  name         = "${var.install_name}-${var.region}-cs-ip-external"
  region       = var.region
  address_type = "EXTERNAL"
}

output External_VIP_Address {
  value = "${google_compute_address.cs_vip_external.address}"
  depends_on = [google_compute_address.cs_vip_external]
}

# External CT Forwarding rules, add these rules only when cloud_ext_ct is true or ct_count not 0
resource google_compute_forwarding_rule cs_external_ct_forwarding_rule {
  count   = var.cloud_ext_ct ? length(var.external_access_ports) : ( var.ct_count > 0 ? length(var.external_access_ports) : 0 )
  project               = var.project
  name                  = "${var.install_name}-cs-external-ct-forwarding-rule-${element(var.external_access_ports, count.index)}"
  region                = var.region
  load_balancing_scheme = "EXTERNAL"
  target                = google_compute_target_pool.cs_target_pool.self_link
  ip_address            = google_compute_address.cs_vip_external.address
  ip_protocol           = "TCP"
  port_range            = element(var.external_access_ports, count.index)
}

# External Forwarding rules, for external user to access the portal UIs and managerment UIs
resource google_compute_forwarding_rule cs_external_forwarding_rule {
  count                 = length(concat(var.ui_ports, var.cs_ports, var.prepack_ports))
  project               = var.project
  name                  = "${var.install_name}-cs-external-forwarding-rule-${element(concat(var.ui_ports, var.cs_ports, var.prepack_ports), count.index)}"
  region                = var.region
  load_balancing_scheme = "EXTERNAL"
  target                = google_compute_target_pool.cs_target_pool.self_link
  ip_address            = google_compute_address.cs_vip_external.address
  ip_protocol           = "TCP"
  port_range            = element(concat(var.ui_ports, var.cs_ports, var.prepack_ports), count.index)
}

# External Forwarding rules, for FTP data access ports
resource google_compute_forwarding_rule cs_external_ftp_forwarding_rule {
  project               = var.project
  name                  = "${var.install_name}-cs-external-forwarding-rule-ftp-data"
  region                = var.region
  load_balancing_scheme = "EXTERNAL"
  target                = google_compute_target_pool.cs_target_pool.self_link
  ip_address            = google_compute_address.cs_vip_external.address
  ip_protocol           = "TCP"
  port_range            = var.ftp_data_ports
}

#resource google_compute_forwarding_rule cs_external_forwarding_rule_affinity {
#  count                 = length(var.ui_ports)
#  project               = var.project
#  name                  = "${var.install_name}-cs-external-forwarding-rule-${element(var.ui_ports, count.index)}"
#  region                = var.region
#  load_balancing_scheme = "EXTERNAL"
#  target                = google_compute_target_pool.cs_target_pool_affinity.self_link
#  ip_address            = google_compute_address.cs_vip_external.self_link
#  ip_protocol           = "TCP"
#  port_range            = element(var.ui_ports, count.index)
#}

# Internal Forwardign rules
resource google_compute_forwarding_rule cs_internal_forwarding_rule {
  project               = var.project
  name                  = "${var.install_name}-cs-internal-forwarding-rule"
  region                = var.region
  network               = google_compute_network.cms_network.self_link
  subnetwork            = google_compute_subnetwork.subnet_cms_cluster.self_link
  load_balancing_scheme = "INTERNAL"
  backend_service       = google_compute_region_backend_service.cs_backend_service.self_link
  ip_address            = google_compute_address.cs_vip_internal.address
  ip_protocol           = "TCP"
  all_ports             = true
}


# Unmanaged Instance group for CS
resource google_compute_instance_group cs_group {
  count       = var.cs_count
  name        = "${var.install_name}-cs-group-${count.index}"
  depends_on  = [google_compute_instance.cs]
  description = "CS unmanaged group"
  zone        = element(flatten( [var.instance_group_zones, var.instance_group_zones, var.instance_group_zones] ),count.index)
  network     = google_compute_network.cms_network.self_link
  instances   = [google_compute_instance.cs[count.index].self_link]
}

resource google_compute_health_check cs_healthcheck {
  name = "${var.install_name}-cs-healthcheck"

  http_health_check {
    port         = "10253"
    request_path = "/healthz"
  }
  timeout_sec         = 2
  check_interval_sec  = 10
  healthy_threshold   = 2
  unhealthy_threshold = 1
}

# Backend Service for CS services internal access
resource google_compute_region_backend_service cs_backend_service {
  #count            = var.cs_count
  project          = var.project
  name             = "${var.install_name}-cs-backend-service"
  #depends_on = ["google_compute_region_instance_group_manager.cs_region_igm"]
  depends_on = [google_compute_instance.cs]
  region           = var.region
  protocol         = "TCP"
  timeout_sec      = 10
  session_affinity = var.session_affinity
  
  dynamic "backend" {
    for_each = google_compute_instance_group.cs_group.*.self_link
    content {
      group = backend.value
    }
  }

  health_checks = [google_compute_health_check.cs_healthcheck.self_link]
}

resource google_compute_http_health_check cs_targetpool_healthcheck {
  name         = "${var.install_name}-cs-targetpool-healthcheckk"
  port         = "10253"
  request_path = "/healthz"
  timeout_sec         = 2
  check_interval_sec  = 60
  healthy_threshold   = 2
  unhealthy_threshold = 1
}

# Target pool for CS servers external access
resource google_compute_target_pool cs_target_pool {
  name      = "${var.install_name}-cs-target-pool"
  #depends_on = ["google_compute_region_instance_group_manager.cs_region_igm"]
  depends_on = [google_compute_instance.cs]
  instances = google_compute_instance.cs.*.self_link
  #instances = data.google_compute_region_instance_group.cs_group.instances.*.instance
  //health_checks = ["${element(compact(concat(google_compute_health_check.tcp.*.self_link)), 0)}"]
  health_checks = [google_compute_http_health_check.cs_targetpool_healthcheck.self_link]
  session_affinity = var.session_affinity
}

#resource google_compute_target_pool cs_target_pool_affinity {
#  name      = "${var.install_name}-cs-target-pool-affinity"
#  #depends_on = ["google_compute_region_instance_group_manager.cs_region_igm"]
#  depends_on = [google_compute_instance.cs]
#  instances = google_compute_instance.cs.*.self_link
#  #instances = data.google_compute_region_instance_group.cs_group.instances.*.instance
#  //health_checks = ["${element(compact(concat(google_compute_health_check.tcp.*.self_link)), 0)}"]
#  health_checks = [google_compute_http_health_check.cs_targetpool_healthcheck.self_link]
#  session_affinity = "CLIENT_IP"
#}

# Additional UDP forwarding rule for external CT node to connect with DNS on CS
resource google_compute_forwarding_rule cs_external_forwarding_rule_dns_udp {
  count                 = var.cloud_ext_ct ? 1 : 0
  project               = var.project
  name                  = "${var.install_name}-cs-external-forwarding-rule-dns-udp-53"
  region                = var.region
  load_balancing_scheme = "EXTERNAL"
  #target                = google_compute_target_pool.cs_dns_target_pool[0].self_link
  target                = google_compute_target_pool.cs_target_pool.self_link
  ip_address            = google_compute_address.cs_vip_external.address
  ip_protocol           = "UDP"
  port_range            = "53"
}

# Additional TCP forwarding rule for external CT node to connect with DNS on CS
resource google_compute_forwarding_rule cs_external_forwarding_rule_dns_tcp {
  count                 = var.cloud_ext_ct ? 1 : 0
  project               = var.project
  name                  = "${var.install_name}-cs-external-forwarding-rule-dns-tcp-53"
  region                = var.region
  load_balancing_scheme = "EXTERNAL"
  target                = google_compute_target_pool.cs_target_pool.self_link
  ip_address            = google_compute_address.cs_vip_external.address
  ip_protocol           = "TCP"
  port_range            = "53"
}

# For external CT nodes to access rpm repo on CS1
resource google_compute_target_pool cs1_rpmrepo_target_pool {
  count     = var.cloud_ext_ct ? 1 : 0
  name      = "${var.install_name}-cs1-rpmrepo-target-pool"
  depends_on = [google_compute_instance.cs]
  instances = [google_compute_instance.cs[0].self_link]
  ##Health check is not necessary since there is only one instance linked
  #health_checks = [google_compute_http_health_check.cs1_rpmrepo_targetpool_healthcheck[0].self_link]
  session_affinity = var.session_affinity
}

resource google_compute_forwarding_rule cs_external_forwarding_rule_rpmrepo_tcp {
  count                 = var.cloud_ext_ct ? 1 : 0
  project               = var.project
  name                  = "${var.install_name}-cs-external-forwarding-rule-rpmrepo-tcp-8008"
  region                = var.region
  load_balancing_scheme = "EXTERNAL"
  target                = google_compute_target_pool.cs1_rpmrepo_target_pool[0].self_link
  ip_address            = google_compute_address.cs_vip_external.address
  ip_protocol           = "TCP"
  port_range            = "8008"
}

