#!/bin/bash

alias facter="/opt/puppetlabs/bin/facter -l none"

DNSSERVER=$(facter named.master)

DOMAIN=$(facter cms.networking.domain)

#Get IP for cname
if [[ $(facter cms.networking.private_network) ]]; then
    CNAME_IP=$(facter networking.interfaces.$(facter node.private_nic).ip)
else
    CNAME_IP=$(facter networking.ip)
fi

CNAME=$(facter node.cname)

echo $DNSSERVER
echo $DOMAIN
echo $CNAME

# Deregister from DNS server
COUNT=0
while :; do
    if [ $COUNT -gt 10 ]; then
        logger "Could not update the name server"
        exit 1
    fi

    nsupdate -v -k /var/named/dynamic/cmsns.key << EOF
server $DNSSERVER
zone $DOMAIN
update delete $(hostname).$DOMAIN
update delete $CNAME.$DOMAIN
update delete $CNAME-pub.$DOMAIN
send
EOF
    if [ $? -eq 0 ]; then
        break
    else
        sleep 2
    fi
    COUNT=$((COUNT+1))
done

# Get all registered services for current node
SERVICES=$( curl http://app:8501/v1/catalog/node/$CNAME | jq -r '.Services[] | .Service')
if [ $(facter node.clustergroup) == ct ];then
  for SERVICE in $SERVICES
  do
    /usr/bin/consul-external-deregister -s $SERVICE $CNAME $(facter cms.configname) -c http://app:8501
  done
  curl -X PUT -d "{\"Datacenter\": \"$(facter cms.configname)\", \"Node\": \"$CNAME\"}" http://app:8501/v1/catalog/deregister
else
  #for SERVICE in $SERVICES
  #do
  #  /usr/bin/consul-deregister $SERVICE
  #done
  #curl -X PUT -d "{\"Datacenter\": \"$(facter cms.configname)\", \"Node\": \"$CNAME\"}" http://localhost:8500/v1/catalog/deregister
  sudo systemctl stop consul
fi
