# Create NFS server
resource google_compute_instance nfs {
  count = var.setup_nfs ? 1 : 0
  name         = "${var.install_name}-nfs"
  machine_type = var.dev_mode ? var.gcp_instance_type_nfs_dev : var.gcp_instance_type_nfs

  //
  zone = element(var.instance_group_zones,1)

  boot_disk {
    initialize_params {
      image = "centos-cloud/centos-7"
    }
  }

  attached_disk {
    source      = google_compute_disk.nfs_disk[0].self_link
    device_name = google_compute_disk.nfs_disk[0].name
  }

  network_interface {
    subnetwork = google_compute_subnetwork.subnet_cms_cluster.name
    network_ip = cidrhost(var.gcp_subnet, 5)
    //access_config = {}
  }

  metadata_startup_script = file("../scripts/nfs.sh")

  metadata = {
    device_name = "google-${google_compute_disk.nfs_disk[0].name}"
    ssh-keys = "${var.ssh_user}:${file(var.public_key_path)}"
  }
}

# Create persistent disk
resource google_compute_disk nfs_disk {
  count = var.setup_nfs ? 1 : 0
  name = "${var.install_name}-nfs-disk"
  type = "pd-standard"
  zone = element(var.instance_group_zones,1)
  size = var.dev_mode ? 30 : var.nfs_disk_size

  labels = {
    service = "nfs"
  }
}

#resource "google_compute_region_disk" "nfs_disk" {
#  name   = "${var.install_name}-region-nfs-disk"
#  type   = "pd-standard"
#  region = var.region
#  replica_zones = var.nfs_replica_zones
#  size   = "200"#

#  labels = {
#    service = "nfs"
#  }
#}