## CMS Terraform scripts for AWS deployment.

### Overview
This script provisions a set of resources in AWS and installs the CMS.  
* AWS Resources provisioned by the scripts include:
  * Virtual Private Cloud (VPC) for CMS.
  * Security Group with Security Rules.
  * Availability zone for CS nodes, APP nodes, ES nodes, PT nodes, CT nodes.
  * EC2 instances for CS nodes, APP nodes, ES nodes, PT nodes, CT nodes.
  * EFS storage share as CMS internal NAS.
  * PostgreSQL server instance as CMS DB.
  * Public dynamic IPs for CS nodes, APP nodes, ES nodes, PT nodes, CT nodes.
  * Public dynamic IP as CMS external VIP.
  * Load Balancer.
  * Load Balancer rules.


### Prerequisites
1. User should have basic knowledge about [terraform cli](https://www.terraform.io/docs/commands/index.html).
2. User should have advanced knowledge about Linux OS operations.
3. AWS [access key ID](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_access-keys.html) is ready for deploying CMS.
* Project team should be responsible for providing the access key ID.
4. AWS [secret access key](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_access-keys.html) is ready for deploying CMS.
* Project team should be responsible for providing the secret access key.
* For more detail about access key ID and secret access key, please refer to [Configuring Access Keys, Secret Keys, and IAM Roles](https://clouductivity.com/amazon-web-services/aws-credentials-access-keys-secret-keys/)


### Required CMS Installation Packages
* CMS Software Packages RPM (cms-swo-repo-x.x.xxx.xxx-0.el7.noarch.rpm).
* CMS Installer RPM (cmsinstaller-x.x.xxx.xx-0.noarch.rpm).
* CMS Terraform Scripts (cmsform-aws-x.x.xxx.xx.tar.gz).

### Steps for deploying CMS on AWS
**1. Provision an Installer Node and install terraform.**
   * Acquire a CentOS linux machine which can access public internet, this machine can be a VM or a metal machine.  
   * Login to the machine and install terraform v0.12 follow the [terraform guide](https://www.terraform.io/downloads.html).

**2. Prepare the CMS terraform scripts.**
   * Put cmsform-aws-x.x.xxx.xx.tar.gz to the machine and extract this gz file.
```bash
tar -xvzf cmsform-aws-x.x.xxx.xx.tar.gz
```
   <br>You will get a new folder ***cmsform*** with below subfolders.
   *<br> - AWS*
   *<br> - config_templates*
   *<br> - vmTools*
   *<br> - scripts*

**3. Prepare the CMS RPMs.**
   * Put below CMS RPMs to the machine by SCP or FTP or any other physical method.
   *<br> - CMS Software Packages RPM*
   *<br> - CMS Installer RPM*
   * Move the rpms to a dedicated folder
   <br>*For example, /home/packages*
   <br>**Note:**  *Make sure this folder can be accessed by user running the terraform scripts.*
   * Update the full path of this folder into field ***package_location*** in the [customized deployment variable file](#samplevariablesfile).

**4. Prepare the CMS license file.**
   * Get CMS license.xml file and put the file to the machine under the folder *cmsform* created in step 2.
   * Update the License Fingerprint into field ***cms_license_fingerprint*** in the [customized deployment variable file](#samplevariablesfile).

**5. Prepare the SSH key files.**
   * Create SSH key pair based on user's own security requirement. User can refer to [Generate a New SSH Key](https://www.ssh.com/ssh/keygen) for some information.
   * Put the generated key file and key.pub file to the machine under the folder *cmsform* created in step 2.
   <br>*Key pare example: cms-ssh-key, cms-ssh-key.pub*
   * Update the full path of the key pair files into fields ***private_key_path*** and ***public_key_path*** in the [customized deployment variable file](#samplevariablesfile).

**6. Prepare the customized deployment variable file.**
   * Create a \<anyname\>.tfvars file, e.g. ~/cmsform/AWS/sample.tfvars.
   <br>*Refer to section [Variables](#variables) for all available variables.*
   <br>*- Pay attention to those variables that need customized.*
   <br>*Read below sections to decide the values for significant variables.*
   *<br> - [Recommanded VM size](#recommanded-vm-size)*
   *<br> - [About Regions and Availability Zone](#about-regions-and-availability-zone)*
   *<br> - [About Storage](#about-storage)*
   *<br> - [About External CT node](#about-external-ct-node)*
   *<br> - [About deploy with existing vpc](#about-deploy-with-existing-vpc)*
   *<br><a name="samplevariablesfile">Example tfvars file as below.</a>*
    
```bash
#vi ~/cmsform/AWS/sample.tfvars
install_name = "awscms"
aws_region     = "us-east-1"
aws_access_key = "XXXXXXXXXXXXXXXXXXXXXXXX"
aws_secret_key = "YYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYY"
external_whitelist = [ "198.24.0.0/21","198.24.8.0/23"]
admin_whitelist = ["198.24.0.0/21","198.24.8.0/23"]
bastion_public_cidr = ["198.24.0.0/21","198.24.8.0/23"]
cms_license_fingerprint = "00000000000000000000000000000000"
private_key_path = "~/.ssh/cms-ssh-key"
public_key_path = "~/.ssh/cms-ssh-key.pub"
cs_count = 3
app_count = 2
es_count = 3
pt_count = 2
ct_count = 2
az_count = 3
rds_multi_az = true
cloud_ext_ct = false
existing_vpc_id = 0
aws_vpc_cidr = "192.168.0.0/16"
aws_subnet_cidr = "192.168.0.0/24"
rds_subnet_cidr = "192.168.1.0/24"
package_location = "/home/packages"
content_nas_volume_size = "100"
```

**7. Run scripts to deploy CMS.**
   * Login to the machine and change to the terraform scripts directory
```bash
#e.g.
cd ~/cmsform/AWS
```
   * Make sure the customized deployment variable file, *e.g. sample.tfvars*, is inside this folder as well. 
   * Run scripts with below commands.
```bash
sudo terraform init -upgrade
sudo terraform plan -var-file=sample.tfvars -out=awscms.tfplan
sudo terraform apply awscms.tfplan
```

**8. Login CS1 node.**
   * From "AWS Console/EC2/INSTANCES", check the "Instances" resource name *CS1-<install_name>*, to get the FQDN for CS1 node in "Public DNS" attribute.
   <br>User can then login CS1 node with ssh command, with the username defined in variables file *ssh_user* and the private SSH private key we generated in step 5. The SSH private key file needs to be in 400 permission.
``` bash
ssh -i <private_key_path> <ssh_user>@<CS1_FQDN>
```

**9. (Optional) Start all cms services from CS1 node after cms and all CT nodes installation finished.**
   * This step is only necessary when there is CT node deployed, either internal or external CT node.
   * Login CS1 node with the installer user and start all cms services with below command.
```bash
service cms-cluster start -f
```

**10. Login CMS UI.**
   * From "AWS Console/EC2/LOAD BALANCING", check the attribute "DNS Name" of "Load Balancer" resource name *<install_name>* to get the FQDN for CMS VIP.
   <br>User can then browse to CMS UI with this FQDN.
``` bash
https://<Load_Balancer_DNS_NAME>:8443/portal
```

### Recommanded VM size
   * Set variable ***dev_mode*** to `false` will use the recommanded VM size for production deployment.
   * For more Instances size information, refer to [Instance Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html).
   * CMS VM size related variables recommanded value for AWS production deployment as below.

Variable|Value
:-|:-
aws_instance_type_cs|"m4.xlarge"
aws_instance_type_app|"m4.4xlarge"
aws_instance_type_es|"m4.xlarge"
aws_instance_type_pt|"t2.medium"
aws_instance_type_ct|"m4.xlarge"
aws_instance_type_rds|"db.m4.4xlarge"

### About Regions and Availability Zone
   * AWS has the concept of a Region, which is a physical location around the world where we cluster data centers. Each group of logical data centers is called an Availability Zone. Each AWS Region consists of multiple, isolated, and physically separate AZ's within a geographic area. For more detail, refer to [Regions and Availability Zones in AWS](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/?p=ngi&loc=2).
   * Choose the desired region and set the value in variable ***aws_region***.


### About Storage
   * CMS is using AWS EFS as internal shared storage, mainly used for storing CMS configration files and Content files.
   * Variable ***content_nas_volume_size*** determine the size allocated for the shared storage, the unit is GB, default is 100.
   * This shared storage is not for external CT nodes. External CT nodes are using On-Premise NAS server inside customer site as shared storge. When CMS is deployed with external CT node, media content files are not stored in this AWS internal shared storage, use the default value, 100GB, is sufficient.

### About deploy with existing VPC
   * By default, the Terraform creates a Virtual Private Cloud for the AWS installation. If users have created their own VPC, do the following: 
     1. Make sure the existing VPC has DNS hostnames function enalbed. For detailed instructions, refer to the official AWS documentation for VPC.
(https://docs.aws.amazon.com/vpc/latest/userguide/working-with-vpcs.html )
     2. Make sure an Internet gateway is attach to the exiting VPC. For detailed instructions, refer to the official AWS documentation for Internet gateway.
(https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Internet_Gateway.html ) 
     3. Make sure a route is created inside the VPC for accessing the internet. For detailed instructions, refer to the official AWS documentation for route tables.
(https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html )
     4. Update the current VPC id into the field ***existing_vpc_id*** in [customized deployment variable file](#samplevariablesfile).

### About External CT node
   * **Related variables**
   <br>Set ***ct_count*** with `0` and ***cloud_ext_ct*** to `ture` when CMS is to be deployed with external CT nodes.
   <br>Make sure the IPs of external CT nodes are included in variable ***external_whitelist***.
   * **External CT node Installation** 
   <br>After CMS is deployed in AWS successfully, follow the steps in Installation Guide section *Deploying CT Node Outside Clouds* to install external CT nodes.
   * **NAT**
   <br>Since external CT node is deployed inside customer's data-center, it could be behind a firewall and exported with a natted IP. In such case, user need to enable the firewalld service in all CS nodes and APP nodes and configure some firewall rules to route the outgoing messages to the CT node's natted IP.
   <br>Refer to Installation Guide section *Configuring Iptables NAT Rules (Optional)* for setting up the firewall rules on CS and APP nodes.
   * **Firewall Ports**
   <br>The external CT nodes should have below ports (TCP by default) opened for CS and APP nodes.

Service|Cloud resource|Cloud Port|Direction|Firewall Port|OnPremise Node
:-|:-|:-|:-:|:-|:-
Consul|External LB|8501|<-----|XX|Content Server
Workflow|External LB|7070|<-----|XX|Content Server
Elasticsearch|External LB|9200|<-----|XX|Content Server
Kibana|External LB|9292|<-----|XX|Content Server
RPM-Repo|External LB|8008|<-----|XX|Content Server
Redis|External LB|6379|<-----|XX|Content Server
RabbitMQ|External LB|5672|<-----|XX|Content Server
DNS|CS nodes|53(TCP and UDP)|<-----|XX|Content Server
cmstomcat|CS nodes|XX|----->|8081|Content Server
cms|CS nodes|XX|----->|8444|Content Server
FTP|CS nodes|XX|----->|21|Content Server
FTP|CS nodes|XX|----->|10000-10199|Content Server
ADI|CS nodes|XX|----->|5000|Content Server
cmstomcat|APP nodes|XX|----->|8081|Content Server
cms|APP nodes|XX|----->|8444|Content Server


### Variables
Variable Name|Description|Default Value|Need Customized
:-|:-|:-|:-
install_name|Textual Name of this CMS Install as Installation Identifier, every concurrent deployment needs a unique install name.|""|*|
aws_region|AWS region to launch vms into.|"us-west-2"|*|
aws_access_key|AWS Access Key for access to aws API.|""|*|
aws_secret_key|AWS Secret Key for access to aws API.|""|*|
app_count|Number of application nodes to deploy.|"1"|*|
cs_count|Number of Cluster Service nodes to deploy.|"1"|*|
es_count|Number of ElasticSearch nodes to deploy.|"1"|*|
pt_count|Number of Portal nodes to deploy.|"0"|*|
ct_count|Number of Content server nodes to deploy.|"0"|*|
rds_multi_az|Set it true to deploy database with high availability.|false|
az_count|Number of availability zones to spread across.|3|
dev_mode|Set it true to run in development mode using smaller/cheaper instance types for testing the deployment and basic functions.|false|
mount_options|Mount options for EFS.|["nolock","nfsvers=4.1"]|
remount|Enable/disable remount as a mount option; should remain false for EFS.|false|
cms_nas_type|The nas type for CMS.|"nfs"|
ct_nas_type|The nas type for CMS CT nodes.|"nfs"|
cms_nas_share|The nas share folder for CMS.|"/"|
content_nas_share|The nas share folder for content.|"/"|
ct_cms_nas_share|The nas share folder for CMS.|"/"|
ct_content_nas_share|The nas share folder for content.|"/"|
admin_whitelist|Networks to allow admin connectivity from, fill with cidr format. The IP must match the company NAT rules in use to allow access to the install from the company network.|["192.168.0.0/24"]|*|
external_whitelist|Networks to allow external connectivity from - replace with corporate public IP address range from corporate Nat/gateway; limit to 5.|["192.168.0.0/24"]|*|
bastion_public_cidr|The public IP cidr of the bastion system, used to kickstart the deployment.  This IP must be allowed in the security groups.  i.e.   dig +short myip.opendns.com @resolver1.opendns.com.|["192.168.0.0/24"]|*|
ui_ports|Accessible CMS UI ports.|["21","80","8081",<br>"8443","8501","9292",<br>"9393","16443","7070",<br>"8080","8444","5672"]|
internal_lb_ports|CMS load balanced ports.|["5000","6003","7443"]|
cs_ports|Accessible CMS ports for CS nodes.|["5601","9090"]|
aws_vpc_cidr|The CIDR of the VPC to create.|"10.0.0.0/16"|
aws_subnet_cidr|The CIDR of the Subnet to create with the VPC. All VMs are created in this subnet, which is broken up into smaller subnets for each availability zone. Must be a valid subnet of the VPC cidr.|"10.0.0.0/24"|
rds_subnet_cidr|The CIDR of the Subnet to create with the VPC for RDS instances. Must be a valid subnet of the VPC cidr.|"10.0.1.0/24"|
aws_instance_type_cs|The AWS Instance Type to use for CMS Cluster Server Instances.|"m4.xlarge"|
aws_instance_type_cs_dev|The AWS Instance Type to use for CMS Cluster Server Instances in development mode.|"m4.large"|
aws_instance_type_app|The AWS Instance Type to use for CMS Application Server Instances.|"m4.4xlarge"|
aws_instance_type_app_dev|The AWS Instance Type to use for CMS Application Server Instances in development mode.|"m4.large"|
aws_instance_type_rds|The AWS Instance Type to use for AWS PostgreSQL RDS Instances.|"db.m4.4xlarge"|
aws_instance_type_rds_dev|The AWS Instance Type to use for AWS PostgreSQL RDS Instances in development mode.|"db.m4.large"|
aws_instance_type_es|The AWS Instance Type to use for CMS Elastic Search Server Instances.|"m4.xlarge"|
aws_instance_type_es_dev|The AWS Instance Type to use for CMS Elastic Search Server Instances in development mode.|"m4.large"|
aws_instance_type_pt|The AWS Instance Type to use for CMS Portal Server Instances. Install will fail if this value is lowered.|"t2.medium"|
aws_instance_type_ct|The AWS Instance Type to use for CMS Content Server Instances.|"m4.xlarge"|
root_volume_type|Volume type to use on boot/root disk.|"standard"|
block_volume_type|Volume type to use on additional file system space.|"standard"|
aws_instance_block_size_cs|Number of GB of additional space to alloate to Cluster Server instances, the recommended value for production is 300.|"20"|*|
aws_instance_block_size_app|Number of GB of additional space to alloate to Application Server instances, the recommended value for production is 100.|"20"|*|
aws_instance_block_size_es|Number of GB of additional space to alloate to Elastic Search Server instances, the recommended value for production is 500.|"100"|*|
aws_instance_block_size_pt|Number of GB of additional space to alloate to Portal Server instances, the recommended value for production is 100.|"20"|*|
aws_instance_block_size_ct|Number of GB of additional space to alloate to Content Server instances, the recommended value for production is 100.|"20"|*|
content_nas_volume_size|Number of GB to allocate for contenet share.|"100"|*|
content_nas_volume_type|Type of aws block device to allocate for content share.|"standard"|
cms_license_fingerprint|CMS Installation License Fingerprint, should match with the fingerprint in CMS license file.|"00000000000000000000000000000000"|*|
license_file_path|Path to CMS license file.|"../license.xml"|*|
cms_hostname_cs|The hostname prefix for the Cluster Server Instance.|"cms-cs"|
cms_hostname_app|The hostname prefix for the Application Server Instance.|"cms-app"|
cms_hostname_es|The hostname prefix for the Elastic Search Server Instance.|"cms-es"|
cms_hostname_pt|The hostname prefix for the Portal Server Instance.|"cms-pt"|
cms_hostname_ct|The hostname prefix for the Content Server Instance.|"cms-ct"|
cms_dns_domain|Network Domain name for CMS Instances.|"ericsson.local"|
timezone|Timezone to be set in the Instances OS.|"America/Los_Angeles"|*|
ntp1|First ntp server IP address.|"0.rhel.pool.ntp.org"|
ntp2|Second ntp server IP address.|"1.rhel.pool.ntp.org"|
snmp_server|SNMP server IP address.|"127.0.0.1"|
aws_ami_product_code|AMI product code identifiers to use in various regions - should be CentOS 7.|"aw0evgkw8e5c1q413zgy5pjce" 
private_key_path|The path of the ssh private key file in the server running this terraform scripts, which will be used to configure VM instances.|"~/.ssh/cms_terraform_id_rsa"|*|
public_key_path|The path of the ssh pub key file in the server running this terraform scripts, which will be used to configure VM instances.|"~/.ssh/cms_terraform_id_rsa.pub"|*|
ssh_user|The user name to use for ssh to VM instances.|"centos"|*|
rds_db_version|Use this to set the db version for AWS Postgresql Server instance creation.|"9.5"|
rds_db_minor_version|Use this to set the db version for RDS instance creation.|"12"|
rds_db_name|Use this to set the db name for AWS Postgresql Server instance creation.|"ttv"|
rds_db_port|Use this to set the db port for AWS Postgresql Server instance creation.|"5432"|
rds_db_user|Use this to set the db user for AWS Postgresql Server instance creation.|"postgres"|
rds_db_pass|Use this to set the db password for AWS Postgresql Server instance creation.|"n2Cdf92j"|
package_location|Location of CMS packages for CMS installation.|"../packages"|*|
cloud_ext_ct|To determine whether CT nodes need to be installed inside or outside aws.|false|*|
existing_vpc_id|Use the parameter to set the existing vpc id, if the values set to 0, the terraform scritps will be create a new VPC.|0|*|
