# For Prepack installation

# Prepare the /opt/cms-prepack/installer/install_sysInfo.json file
data template_file prepack_sysinfo {
  template = file(var.config_install_sysInfo_template)
  depends_on = [google_compute_instance.cs, data.google_compute_instance.app_server, data.google_compute_instance.ct_server]

  vars = {
    CSNodes = jsonencode(
      slice(
        flatten(google_compute_instance.cs.*.network_interface.0.network_ip),
        1,
        length(
          flatten(google_compute_instance.cs.*.network_interface.0.network_ip),
        ),
      ),
    )
    APPNodes = var.app_count > 0 ? jsonencode(flatten(data.google_compute_instance.app_server.*.network_interface.0.network_ip)) : jsonencode([])
    CTNodes = var.ct_count > 0 ? jsonencode(flatten(data.google_compute_instance.ct_server.*.network_interface.0.network_ip)) : jsonencode([])
    prepackVersion = var.prepackVersion
    cmsUser = var.cmsUser
    cmsPassword = var.cmsPassword
    cmsDBUser = var.cmsDBUser
  }
}

output prepack_systemInfo {
  value = data.template_file.prepack_sysinfo.rendered
}

resource null_resource install_prepack {
  count = var.install_prepack && ! var.cloud_ext_ct ? 1 : 0
  #depends_on = [data.template_file.prepack_sysinfo, null_resource.es_checklogs, null_resource.pt_checklogs, null_resource.app_checklogs, null_resource.ct_checklogs]
  depends_on = [null_resource.post_install_start_services]

  connection {
    host = google_compute_instance.cs[0].network_interface.0.network_ip
    type = "ssh"
    user = var.ssh_user
    private_key = file(var.private_key_path)
    timeout     = "20m"
  }
  provisioner file {
    source      = var.prepack_package_location
    destination = "~${var.ssh_user}/prepack_packages"
  }
  
  provisioner remote-exec {
    inline = [
      "bash /etc/init.d/cms-cluster start -f",
      "cd ~${var.ssh_user}/prepack_packages/",
      "sudo yum install -y `ls *.rpm`",
      "sudo cp prepackLicense.xml /opt/tandbergtv/cms/conf/workflow",
      "sudo cp preconfigSelection.json /opt/cms-prepack",
      "cd /opt/cms-prepack/installer; sudo find ./ -type f -name '*.sh' | xargs sudo chmod a+x",
      "echo '${data.template_file.prepack_sysinfo.rendered}'|sudo tee /opt/cms-prepack/installer/install_sysInfo.json",
      "echo 'yes'|sudo tee installInput.txt",
      "echo 'yes'|sudo tee -a installInput.txt",
      "timeout 2700 bash /opt/cms-prepack/installer/deploy.sh -p /opt/cms-prepack/preconfigSelection.json < installInput.txt && [[ $? -eq 0 ]] || if [[ $${PIPESTATUS[0]} -eq 124 ]];then echo 'Installation Timeout!!';exit 1; else exit 1;fi",
      # /opt/cms-prepack/installer/install.log.<timestamp>
    ]
  }
}

