resource google_compute_global_address private_ip_address {
  provider      = google-beta
  name          = "${var.install_name}-private-ip-address"
  purpose       = "VPC_PEERING"
  address_type  = "INTERNAL"
  prefix_length = 16
  network       = google_compute_network.cms_network.self_link
}

resource google_service_networking_connection private_vpc_connection {
  provider                = google-beta
  network                 = google_compute_network.cms_network.self_link
  service                 = "servicenetworking.googleapis.com"
  reserved_peering_ranges = [google_compute_global_address.private_ip_address.name]
}

locals {
  db_name_suffix = formatdate("YYYYMMDDhhmmss", timestamp())
}

resource google_sql_database_instance cloudsql_master {
  # Do not set with static name since gcp can not create sql with the same previous name
  # Use timestamp function to generate the db name
  # https://www.terraform.io/docs/configuration/functions/timestamp.html
  #name             = "${var.install_name}-db-${formatdate("YYYYMMDDhhmmss", timestamp())}"
  name = "${var.install_name}-db-${local.db_name_suffix}-master"
  database_version = var.db_version

  depends_on = [google_service_networking_connection.private_vpc_connection]

  #"google_compute_network.cms-network"

  settings {
    #https://cloud.google.com/sql/docs/postgres/create-instance
    #tier = "db-custom-8-15360"
    tier = var.dev_mode ? var.gcp_db_tier_dev : var.gcp_db_tier

    #ip_configuration  {
    #  authorized_networks = [
    #    #name = "all"
    #    #value = "0.0.0.0/0"
    #    "${data.null_data_source.auth_netw_postgres_allowed_1.*.outputs}",
    #    "${data.null_data_source.auth_netw_postgres_allowed_2.*.outputs}",
    #  ]
    #}
    ip_configuration {
      ipv4_enabled    = "false"
      private_network = google_compute_network.cms_network.self_link
    }
    location_preference {
      zone = element(var.instance_group_zones, 0)
    }

    #SQL HA type: "ZONAL" for non-ha, "REGIONAL" for ha
    availability_type = var.sql_ha_type
    replication_type = "ASYNCHRONOUS"
    backup_configuration {
      #binary_log_enabled = true
      enabled = var.sql_ha_type == "REGIONAL" ? true : false
      start_time = "01:00"
    }
  }
}

## Read replica SQL instance
#resource google_sql_database_instance cloudsql_replica {
#  provider = google-beta
#  region = var.region
#  name = "${var.install_name}-db-${local.db_name_suffix}-replica"
#  database_version = "POSTGRES_9_6"
#
#  depends_on = [google_sql_database_instance.cloudsql_master]
#
#  settings {
#    tier = var.dev_mode ? var.gcp_db_tier_dev : var.gcp_db_tier
#
#    #ip_configuration {
#    #  ipv4_enabled    = "false"
#    #  private_network = google_compute_network.cms_network.self_link
#    #}
#    location_preference {
#      zone = element(flatten([var.instance_group_zones, var.instance_group_zones]), 1)
#    }
#  }
#  master_instance_name = google_sql_database_instance.cloudsql_master.name
#  replica_configuration {
#    failover_target = true
#  }
#}

resource google_sql_database cloudsql_db {
  name     = var.db_name
  instance = google_sql_database_instance.cloudsql_master.name
}

# create database Users
resource google_sql_user db_sql_user {
  name     = var.db_user
  instance = google_sql_database_instance.cloudsql_master.name
  host     = "%"
  password = var.db_pass
}