# Build number: 9.0.000.1

variable "project" {
  description = "Project ID on GCP for the CMS deployment."
  default     = "tvaas-poc"
}

variable "region" {
  description = "The GCP location for the CMS deployment."
  default = "us-west1"
}

variable "instance_group_zones" {
  description = "The expected Zones within the region where the instances will be created at."
  default = ["us-west1-a", "us-west1-b", "us-west1-c"]
}

variable "bastion_gcp_vpc_name" {
  description = "The GCP VPC network to which the bastion VM belong."
  default = "bastion"
}

# Security Firewall configuration
# must match the company NAT rules in use to allow access to the install from the company network
variable "bastion_public_cidr" {
  description = "The network IP cidr to which the bastion VM belong."
  default     = ["192.168.0.0/24"]
}

# Network to allow connectivity for admin access, including external CT nodes' hosts.
variable "admin_whitelist" {
  description = "Networks to allow admin connectivity from, fill with cidr format. Replace with corporate public IP address range from corporate Nat/gateway."
  default     = ["192.168.0.0/24"]
}

# Network to allow external connectivity for UI access only - replace with corporate public IP address range from corporate Nat/gateway.
variable "external_whitelist" {
  description = "Networks to allow external connectivity from, mainly for UI access, fill with cidr format. Replace with corporate public IP address range from corporate Nat/gateway."
  default     = ["192.168.0.0/24"]
}

variable "external_ftp_clients" {
  description = "The IP addresses for external ftp clients that are allowed to access the CMS content data."
  default     = ["192.168.0.0/24"]
}

# Ports allowed for UI user
variable "ui_ports" {
  description = "Accessible CMS UI ports."
  default     = ["8443", "16443"]
}

# Ports allowed for external CT nodes
# 6379 : redis
# 8501 : consul
# 9200 : elasticsearch-api
# 9292 : kibana
variable "external_access_ports" {
  description = "CMS load balanced ports for external nodes, e.g. CT node, to access."
  #default    = ["80", "8080", "8081", "7070", "8501", "9292", "9393", "5672", "5671", "5000", "7443"]
  default     = ["6379", "8501", "9200", "9292"]
}

# Ports allowed for Prepack solution
# 21   : ftp
# 6003 : RGB
variable "prepack_ports" {
  description = "CMS load balanced ports for Prepack solution."
  default     = ["21", "6003"]
}

# Ports necessary for running application
# 5601 : kibana-api
# 9090 : haproxy-ui
# 9393 : rabbitmq-ui
# 5672 : rabbitmq, necessary for cms service
# 5671 : secure-rabbitmq
# 7070 : workflow http, necessary for cmstomcat service
# 5000 : adi
variable "cs_ports" {
  description = "Accessible CMS ports for CS nodes"
  default     = ["5601", "9090", "9393", "5672", "5671", "7070", "5000"]
}

variable "ftp_data_ports" {
  description = "Ports for FTP data transfer, 10000-10099 for APP1, 10100-10199 for APP2, 10200-10299 for APP3, and so on."
  default     = "10000-10299"
}

# Networking Defaults
variable "gcp_vpc_cidr" {
  description = "The CIDR of the VPC to be created for the CMS deployment."
  default     = "10.1.0.0/16"
}

variable "gcp_subnet" {
  description = "The CIDR of the Subnet to create within the VPC. All VMs are created in this subnet, which is broken up into smaller subnets for each availability zone. Must be a valid subnet of the VPC cidr."
  default     = "10.1.0.0/24"
}

#variable "nfs_replica_zones" {
#  default = ["us-west1-a", "us-west1-c"]
#}

#variable "zone" {
#  description = "Zone (a/b/c) within the region.  Will be concatenated with the region"
#  default = "a"
#}

# Installation Identifier - every concurrent deployment needs a unique install name
variable "install_name" {
  description = "Textual Name of this CMS Install as Installation Identifier, every concurrent deployment needs a unique install name."
}

variable "app_count" {
  description = "Number of application nodes to deploy."
  default     = "1"
}

variable "cs_count" {
  description = "Number of Cluster Service nodes to deploy."
  default     = "1"
}

variable "es_count" {
  description = "Number of ElasticSearch nodes to deploy."
  default     = "1"
}

variable "pt_count" {
  description = "Number of Portal nodes to deploy."
  default     = "0"
}

####CT nodes installation
variable "ct_count" {
    description = "Number of Content Transport nodes to deploy."
    default = 0
}

variable "cloud_ext_ct" {
    description =  "To determine whether CT nodes need to be installed inside or outside GCP."
    default = false
}

variable "dev_mode" {
  description = "True to run in development mode with smaller/cheaper instance types. Set this to true when deploy CMS for production."
  default     = false
}

variable "setup_nfs" {
  description = "Ture to create an additional VM instance dedicated for running nfs service as build-in NAS server. For production, recommand to set it to false and user should use a customer provided NAS server."
  default     = true
}

variable "nfs_disk_size" {
  description = "Number of GB of disk space to alloate to build-in NFS Server instances when dev_mode is false."
  default     = "2048"
}

variable "mount_options" {
  description = "The mount options for share folders."
  default     = ["nfsvers=4.1"]
}

variable "remount" {
  description = "Enable/disable remount as a mount option."
  default     = false
}

variable "cms_nas_type" {
    description = "The type of nas server for cms app and content folders."
    default = "nfs"
}

variable "cms_nas_server" {
    description = "The IP address of nas server for cms app folder."
    default = "10.0.0.5"
}

variable "content_nas_server" {
    description = "The IP address of nas server for cms app folder."
    default = "10.0.0.5"
}

variable "ct_nas_type" {
    description = "The type of nas server for cms app and content folders on CT nodes."
    default = "nfs"
}

variable "ct_cms_nas_server" {
    description = "The IP address of nas server for cms app folder."
    default = "10.0.0.5"
}

variable "ct_content_nas_server" {
    description = "The IP address of nas server for cms app folder."
    default = "10.0.0.5"
}

variable "cms_nas_share" {
    description = "The nas share folder for cms."
    default = "/var/nfsshare/app"
}

variable "content_nas_share" {
    description = "The nas share folder for content."
    default = "/var/nfsshare/content"
}

variable "ct_cms_nas_share" {
    description = "The nas share folder for cms."
    default = "/var/nfsshare/ct-app"
}

variable "ct_content_nas_share" {
    description = "The nas share folder for content."
    default = "/var/nfsshare/ct-content"
}

# Instance Type selection for the vms
variable "gcp_instance_type_nfs" {
  description = "The GCP Instance Type to use for CMS Cluster Server Instances."
  default     = "n1-highmem-4"
}

variable "gcp_instance_type_nfs_dev" {
  description = "The GCP Instance Type to use for CMS Cluster Server Instances in development mode."
  default     = "n1-standard-1"
}

variable "gcp_instance_type_cs" {
  description = "The GCP Instance Type to use for CMS Cluster Server Instances."
  default     = "n1-highmem-4"
}

variable "gcp_instance_type_cs_dev" {
  description = "The GCP Instance Type to use for CMS Cluster Server Instances in development mode."
  default     = "n1-standard-2"
}

variable "gcp_instance_type_app" {
  description = "The GCP Instance Type to use for CMS Application Server Instances."
  default     = "n1-standard-16"
}

variable "gcp_instance_type_app_dev" {
  description = "The GCP Instance Type to use for CMS Application Server Instances in development mode."
  default     = "n1-standard-2"
}

variable "gcp_instance_type_es" {
  description = "The GCP Instance Type to use for CMS Elastic Search Server Instances. "
  default     = "n1-highmem-4"
}

variable "gcp_instance_type_es_dev" {
  description = "The GCP Instance Type to use for CMS Elastic Search Server Instances in development mode."
  default     = "n1-standard-2"
}

variable "gcp_instance_type_pt" {
  description = "The GCP Instance Type to use for CMS Portal Server Instances."
  default     = "n1-standard-1"
}

variable "gcp_instance_type_pt_dev" {
  description = "The GCP Instance Type to use for CMS Portal Server Instances."
  default     = "n1-standard-1"
}

variable "gcp_instance_type_ct" {
  description = "The GCP Instance Type to use for CMS Portal Server Instances."
  default     = "n1-standard-16"
}

variable "gcp_instance_type_ct_dev" {
  description = "The GCP Instance Type to use for CMS Portal Server Instances."
  default     = "n1-standard-2"
}

variable "gcp_db_tier" {
  description = "The GCP PostgreSQL Instances type."
  default     = "db-custom-8-15360"
}

variable "gcp_db_tier_dev" {
  description = "The GCP PostgreSQL Instances type in development mode."
  default     = "db-custom-8-15360"
}

# Instance Volume Type
# select one of standard, gp2 or io1
#  standard = magnetic
#  gp2 = General Provision SSD
#  io1 = Provisioned IOPS SSD

variable "cs_disk_size" {
  description = "Number of GB of additional space to alloate to Cluster Server instances."
  default     = "300"
}

variable "cs_disk_size_dev" {
  description = "Number of GB of additional space to alloate to Cluster Server instances in dev mode."
  default     = "20"
}

variable "app_disk_size" {
  description = "Number of GB of additional space to alloate to Cluster Server instances."
  default     = "100"
}

variable "app_disk_size_dev" {
  description = "Number of GB of additional space to alloate to Cluster Server instances in dev mode."
  default     = "20"
}

variable "es_disk_size" {
  description = "Number of GB of additional space to alloate to Cluster Server instances."
  default     = "500"
}

variable "es_disk_size_dev" {
  description = "Number of GB of additional space to alloate to Cluster Server instances in dev mode."
  default     = "20"
}

variable "pt_disk_size" {
  description = "Number of GB of additional space to alloate to Cluster Server instances."
  default     = "100"
}

variable "pt_disk_size_dev" {
  description = "Number of GB of additional space to alloate to Cluster Server instances in dev mode."
  default     = "10"
}

variable "ct_disk_size" {
  description = "Number of GB of additional space to alloate to Cluster Server instances."
  default     = "100"
}

variable "ct_disk_size_dev" {
  description = "Number of GB of additional space to alloate to Cluster Server instances in dev mode."
  default     = "20"
}

# CMS License & Fingerprint
variable "cms_license_fingerprint" {
  description = "CMS Installation License Fingerprint, should match with the fingerprint in CMS license file."
  default     = "00000000000000000000000000000000"
}

variable "customerInstanceId" {
  description = "A value used internally - not in use any more."
  default     = "cms"
}

variable "license_file_path" {
  description = "Path to CMS license file."
  default     = "../license.xml"
}

# Instance Hostname/domain details

variable "cms_hostname_cs" {
  description = "The hostname prefix for the Cluster Server Instance."
  default     = "cms-cs"
}

variable "cms_hostname_app" {
  description = "The hostname prefix for the Application Server Instance."
  default     = "cms-app"
}

variable "cms_hostname_es" {
  description = "The hostname prefix for the Elastic Search Server Instance."
  default     = "cms-es"
}

variable "cms_hostname_pt" {
  description = "The hostname prefix for the Portal Server Instance."
  default     = "cms-pt"
}

variable "cms_hostname_ct" {
  description = "The hostname prefix for the Content Server Instance."
  default     = "cms-ct"
}

variable "cms_dns_domain" {
  description = "Network Domain name for CMS Instances."
  default     = "mediakind.local"
}

variable "timezone" {
  description = "Timezone to run the Instances in."
  default     = "America/Los_Angeles"
}

variable "ntp1" {
  description = "The IP address or FQDN of first ntp server."
  default     = "0.rhel.pool.ntp.org"
}

variable "ntp2" {
  description = "The IP address or FQDN of second ntp server."
  default     = "1.rhel.pool.ntp.org"
}

variable "snmp_server" {
  description = "The IP address or FQDN of SNMP server."
  default     = "127.0.0.1"
}

# Base Operation System image to install - add more regions as needed...
variable "gcp_os_image" {
  description = "GCP image name for VM Operation System."
  default     = "centos-cloud/centos-7"                                                   # CentOS 7 (x86_64) - with Updates HVM
}

# SSH Key Details
# this allows ssh into the instances via keys on the bastion system.

variable "private_key_path" {
  description = "The path of the ssh private key the bastion will use to configure instances."
  default     = "~/.ssh/test"
}

variable "public_key_path" {
  description = "The path of the ssh pub key the bastion will use to configure instances."
  default     = "~/.ssh/test.pub"
}

variable "ssh_user" {
  description = "User name as the CMS install user."
  default     = "test"
}

variable "db_version" {
  description = "Use this to set the db version for RDS instance creation."
  default     = "POSTGRES_9_6"
}

variable "sql_ha_type" {
  description = "SQL availability_type, ZONAL for non-ha, REGIONAL for ha."
  default     = "ZONAL"
}

variable "db_name" {
  description = "Use this to set the db name for RDS instance creation."
  default     = "ttv"
}

variable "db_port" {
  description = "Use this to set the db port for RDS instance creation."
  default     = "5432"
}

variable "db_user" {
  description = "Use this to set the db user for RDS instance creation."
  default     = "postgres"
}

variable "db_pass" {
  description = "Use this to set the db password for RDS instance creation."
  default     = "n2Cdf92j"
}

variable "package_location" {
  description = "Location of CMS packages to install."
  default     = "../packages"
}

variable session_affinity {
  description = "The session affinity for the backends example: NONE, CLIENT_IP. Default is `NONE`."
  default     = "NONE"
}

variable network_project {
  description = "Name of the project for the network. Useful for shared VPC. Default is var.project."
  default     = ""
}

## Prepack variables
variable "install_prepack" {
  description = "Indicator for whether to run prepack installation or not."
  default     = false
}

variable "prepack_package_location" {
  description = "Location of Prepack packages to install."
  default     = "../prepack_packages"
}

variable "prepackVersion" {
  description = "The release version of prepack."
  default     = "5.1.000-SNAPSHOT"
}

variable "config_install_sysInfo_template" {
  description = "PrePack install sysInfo file."
  default     = "../prepackTools/install_sysInfo.tpl"
}

variable "cmsUser" {
  description = "User for connecting to CMS API."
  default     = "admin" 
}

variable "cmsPassword" {
  description = "Password for connecting to CMS API."
  default     = "admin" 
}

variable "cmsDBUser" {
  description = "User name for connecting to CMS DB."
  default     = "wfs" 
}
