#!/bin/bash -x
#
#  Script to purge elasticsearch data on logstash
#  Default is keep 7 days of logs, 30 days of metrics, and 6 months of audits
#  use 'sh logstashpurge x' to provide different amount of days to keep
#

function es_get () {
	GET=$(curl -s -w "%{http_code}" -X GET "$1")
	case "${GET: -3}" in
		20*)
			echo "${GET%???}"
			;;
		*)
			echo "${GET%???}"
			return 1
			;;
	esac
}

function es_delete () {
	GET=$(curl -s -w "%{http_code}" -X GET "$1")
	case "${GET: -3}" in
		20*)
			DELETE=$(curl -s -o /dev/null -w "%{http_code}" -X DELETE "$1")
			case "${DELETE: -3}" in
				200)
        			;;
        		*)
        			echo "${DELETE%???}"
        			return 1
        			;;
        	esac
			;;
		40*)
			;;
		*)
			echo "${GET%???}"
			return 1
			;;
	esac
}

function delete() {
	es_delete "localhost:9200/$1"
	if [ $? -ne 0 ]; then
		if [[ $1 != "" && $1 != "." && $1 != ".." ]]; then
			DATA_FOLDER=$(grep "^path.data" /etc/elasticsearch/elasticsearch.yml | cut -d' ' -f2)
            if [ -z $DATA_FOLDER ]; then
            	DATA_FOLDER="/data/elasticsearch/data"
            fi
    		rm -rf $DATA_FOLDER/*/nodes/*/indices/$1
    	fi
    fi
}

if [ -z $1 ]; then 
	LOGS_DAYS_TO_KEEP=7
	
else
	if [[ $1 =~ ^[0-9]+$ ]]; then
		LOGS_DAYS_TO_KEEP=$1
	else
		printf "Invalid parameter # of days to keep logs!"
		exit 1
	fi
fi

if [ -z $2 ]; then 
	METRICS_DAYS_TO_KEEP=30
else
	if [[ $2 =~ ^[0-9]+$ ]]; then
		METRICS_DAYS_TO_KEEP=$2
	else
		printf "Invalid parameter for # of days to keep metrics!"
		exit 1
	fi
fi

if [ -z $3 ]; then 
	AUDIT_MONTHS_TO_KEEP=6
else
	if [[ $3 =~ ^[0-9]+$ ]]; then
		AUDIT_MONTHS_TO_KEEP=$3
	else
		printf "Invalid parameter for # of months to keep audits!"
		exit 1
	fi
fi

LOGS_DATE=$(date -u --date="$LOGS_DAYS_TO_KEEP days ago" +"%Y"."%m"."%d")
METRICS_DATE=$(date -u --date="$METRICS_DAYS_TO_KEEP days ago" +"%Y"."%m"."%d")
AUDIT_DATE=$(date -u --date="$AUDIT_MONTHS_TO_KEEP months ago" +"%Y"."%m")

echo "Purging logstash indices $LOGS_DATE and earlier"
echo "Purging cms-metrics indices $METRICS_DATE and earlier"
echo "Purging audit indices $AUDIT_DATE and earlier"
echo "Purging metricbeat-cms indices $METRICS_DATE and earlier"

INDICES=($(es_get 'localhost:9200/_cat/indices' | sort | awk '{print $3}'))

if [ $? -ne 0 ]; then
	DATA_FOLDER=$(grep "^path.data" /etc/elasticsearch/elasticsearch.yml | cut -d' ' -f2)
    if [ -z $DATA_FOLDER ]; then
    	DATA_FOLDER="/data/elasticsearch/data"
    fi
	INDICES=($(ls $DATA_FOLDER/*/nodes/*/indices/ | sort))
fi

for INDEX in "${INDICES[@]}"; do
	if [[ $INDEX =~ ^logstash-[0-9]{4}\.[0-9]{2}\.[0-9]{2}$ ]]; then
		INDEX_DATE=$(cut -d'-' -f2 <<< $INDEX)
		if [[ ! "$INDEX_DATE" > "$LOGS_DATE" ]]; then
			echo "Deleting index $INDEX"
			delete $INDEX
		fi
	elif [[ $INDEX =~ ^cms-metrics-[0-9]{4}\.[0-9]{2}\.[0-9]{2}$ ]]; then
		INDEX_DATE=$(cut -d'-' -f3 <<< $INDEX)
		if [[ ! "$INDEX_DATE" > "$METRICS_DATE" ]]; then
			echo "Deleting index $INDEX"
			delete $INDEX
		fi
	elif [[ $INDEX =~ ^audit-[0-9]{4}\.[0-9]{2}$ ]]; then
		INDEX_DATE=$(cut -d'-' -f2 <<< $INDEX)
		if [[ ! "$INDEX_DATE" > "$AUDIT_DATE" ]]; then
			echo "Deleting index $INDEX"
			delete $INDEX
		fi
    elif [[ $INDEX =~ ^metricbeat-cms-6.5.4-[0-9]{4}\.[0-9]{2}\.[0-9]{2}$ ]]; then
        INDEX_DATE=$(cut -d'-' -f4 <<< $INDEX)
        if [[ ! "$INDEX_DATE" > "$METRICS_DATE" ]]; then
            echo "Deleting index $INDEX"
            delete $INDEX
        fi
    elif [[ $INDEX =~ ^metricbeat-cms-6.5.4-[0-9]{4}\.[0-9]{2}$ ]]; then
        INDEX_DATE=$(cut -d'-' -f4 <<< $INDEX)
        if [[ ! "$INDEX_DATE" > "$AUDIT_DATE" ]]; then
            echo "Deleting index $INDEX"
            delete $INDEX
        fi
	fi
done

exit 0
