#!/bin/bash

obj_file=/opt/kibana/files/logstashpurge.sh
bak_file=/opt/kibana/files/logstashpurge.sh.bak72007
local_node=`facter node.cname`

if [ $local_node == 'cs1' ]; then
    if [ -f $bak_file ]; then
        echo "The backup file for the $local_node already exists"
    else
        echo "Backup the $obj_file of the $local_node"
        mv $obj_file $bak_file
    fi
    echo "Update the $obj_file of the $local_node"
    tar xvf /root/core-patches/cms-patch-7.2.008.592.tar -C /opt/kibana/files/ logstashpurge.sh
    chown nobody.nobody $obj_file
    chmod 755 $obj_file
else
    if [ -f $bak_file ]; then
        echo "The backup file for the $local_node already exists"
    else
        echo "Backup the $obj_file of the $local_node"
        mv $obj_file $bak_file
    fi
    echo "Update the $obj_file of the $local_node"
    scp -o StrictHostKeyChecking=no cs1:$obj_file $obj_file
    chown nobody.nobody $obj_file
    chmod 755 $obj_file
fi




