#!/bin/sh
##############################################################
# Name of the file : purge_cms_data.sh                       #
##############################################################
# Description : Script to purge the CMS Titles, WOs and ME   #
#               data.  This script calls the Title, Work     #
#               order and ME purge scripts sequentially      #
#                                                            #
# Created by  : Suresh Neravati                              #
# Date        : 03/06/2011 (Converted the scripts PG format) #
#                                                            #
##############################################################

# Define the below three parameters for your database.
DB_TYPE="edb"
DB_NAME="ttv"
DB_SETTINGS="/opt/db/scripts/install/settings"
if [[ -f $DB_SETTINGS ]]; then
    . "$DB_SETTINGS"
fi
TITLES_TOBE_DELETED="$1"
TITLE_RETENTION_MARGIN="$2"
WORKORDER_RETENTION_DAYS="$3"
ME_REQUESTS_RETENTION_DAYS="$4"
PGP="Wf\$1234"
HOST_NAME="dbserver"
CAN_RUN_USER="root"
PDIR="/opt/db/scripts/cms"
DB_VER=${DB_VERSION:-10}
PSQLHOME="/usr/pgsql-${DB_VER}/bin"

# only ${CAN_RUN_USER} user can run this script.
if [ `whoami` !=  "${CAN_RUN_USER}" ]; then
  echo "************************************************************************************"
  echo "Only ${CAN_RUN_USER} user can run this script. Please log in as ${CAN_RUN_USER} user and try again...!"
  echo "************************************************************************************"
  exit 1
fi

if [ "X${TITLES_TOBE_DELETED}" = "X" ] || [ "X${TITLE_RETENTION_MARGIN}" = "X" ] || [ "X${WORKORDER_RETENTION_DAYS}" = "X" ] || [ "X${ME_REQUESTS_RETENTION_DAYS}" = "X" ]; 
then
  echo "Run the script with right parameters in the script"
  exit 1
fi
if ! [[ "${TITLES_TOBE_DELETED}" =~ ^[0-9]+$ ]] ; then
  echo "TITLES_TOBE_DELETED is not a number"; 
  exit 1
fi
if ! [[ "${TITLE_RETENTION_MARGIN}" =~ ^[0-9]+$ ]] ; then
  echo "TITLE_RETENTION_MARGIN is not a number"; 
  exit 1
fi
if [ ${WORKORDER_RETENTION_DAYS} -lt 1 ]; then
   echo "Work order retention days should be greater than one day, please try again..."
   exit 1
fi
if [ ${ME_REQUESTS_RETENTION_DAYS} -lt 1 ]; then
   echo "Metadata Enhancement requests retention days should be greater than one day, please try again..."
   exit 1
fi
PORT=${DB_PORT:-5444}
export PGPASSWORD=${PGP}
NODE_NUM=$(/opt/puppetlabs/bin/facter node.cname | sed "s/app//g")
if ! [[ "${NODE_NUM}" =~ ^[0-9]+$ ]] ; then
  echo "Error: NODE_NUM is not a number, not calculated correctly. Exiting the script..." 
  exit 1
fi
DB_USER="wfs"
if [ "X${DB_TYPE}" = "Xazure" ]; then
     DB_USER="wfs@$AZURE_DB"
fi

SLP_TIME=$(${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${DB_USER} -q -t -c "SELECT max(trunc(random() * 9 * 2 * $NODE_NUM + 1)) FROM generate_series(1,5);" | sed 's/^ *//')
${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${DB_USER} -q -t -c "select pg_sleep(${SLP_TIME});"
CHECK_CNT=$(${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${DB_USER} -q -t -c "select count(*) from pg_stat_activity where (lower(query) like '%purge_cms%' or lower(query) like '%elastic_search_wopurge_ids%') and query not like '%pg_stat_activity%';" | sed 's/^ *//')
if [ ${CHECK_CNT} -eq 1 ] ; then
   echo -e "\nDatabase purge script is already running.  You can not run the script again, exiting.\n"
   exit 1
fi

sh ${PDIR}/purge_cms_titles.sh ${TITLES_TOBE_DELETED} ${TITLE_RETENTION_MARGIN}
sh ${PDIR}/purge_cms_wos.sh ${WORKORDER_RETENTION_DAYS}
sh ${PDIR}/purge_cms_me.sh ${ME_REQUESTS_RETENTION_DAYS}
sh ${PDIR}/purge_elasticsearch_wos.sh

exit 0 
