\set VERBOSITY terse
PREPARE get_dkd AS SELECT :'dkd'::text;

CREATE OR REPLACE FUNCTION purge_cms_dn_wos() RETURNS smallint AS $func_purge_cms_dn_wos$
DECLARE
    wk_message       varchar(500);
    vsql             varchar;
    tmp_result       smallint;
    purge_wo_num     numeric:=0;    
    err_msg          varchar;
    retention_str    varchar;
    retentiondays    text;
BEGIN
   EXECUTE 'EXECUTE get_dkd' INTO retentiondays;
   IF ( retentiondays::numeric > 0 ) THEN

      vsql:='INSERT INTO delete_log (Message, recordTime) VALUES(''Purge script started for denormalized tables'',clock_timestamp()::timestamp)';
      SELECT purgewoobject(vsql,'INSERT INTO delete_log') INTO tmp_result;

      --PURGE_WFS.ENABLE_DISABLE_FOREIGNKEYS ('DISABLE');

      -- Drop and recreate the table tmp_dn_purgewo to store all delete candidate records
      vsql:='Drop table if exists tmp_dn_purgewo';
      SELECT purgewoobject(vsql,'DROP table tmp_dn_purgewo','Y') INTO tmp_result;

      vsql:='CREATE TABLE tmp_dn_purgewo(jp_id,jt_id) AS 
              WITH RECURSIVE dn_wo_path_graph AS 
              (SELECT jt.processid, jt.tokenid 
                 FROM wfs.ttv_token jt
                 WHERE jt.parenttokenid = 0 AND jt.operationalstatus IN (5,6)
                 AND jt.createdate < ( date ''today''  - interval '''||retentiondays||' days'')
              UNION ALL
              SELECT jti.processid, jti.tokenid 
                 FROM wfs.ttv_token jti  
                 JOIN dn_wo_path_graph ON (jti.parenttokenid=(dn_wo_path_graph).tokenid)
                 WHERE jti.operationalstatus IN (5,6))
              SELECT (dn_wo_path_graph).processid AS wo_id, (dn_wo_path_graph).tokenid AS token_id
                FROM dn_wo_path_graph';
      SELECT purgewoobject(vsql,'CREATE tmp_dn_purgewo') INTO tmp_result;

      vsql:='INSERT INTO tmp_dn_purgewo(jp_id,jt_id)
             WITH RECURSIVE dn_wo_path_graph AS 
             (SELECT jp.processid, jt.tokenid 
                FROM wfs.ttv_token jt
                JOIN wfs.ttv_processinstance jp 
                  ON (jt.processid = jp.processid AND jt.parenttokenid = 0 AND jp.isactive = 0)
                 AND jp.createdate < ( date ''today''  - interval '''||retentiondays||' days'')
             UNION ALL
             SELECT jpi.processid, jti.tokenid 
               FROM wfs.ttv_token jti 
               JOIN wfs.ttv_processinstance jpi 
                 ON (jti.processid = jpi.processid )
                JOIN dn_wo_path_graph ON (jti.parenttokenid=(dn_wo_path_graph).tokenid))
             SELECT (dn_wo_path_graph).processid AS wo_id, (dn_wo_path_graph).tokenid  AS token_id
               FROM dn_wo_path_graph';
      SELECT purgewoobject(vsql,'Insert more records into tmp_dn_purgewo') INTO tmp_result;

      EXECUTE 'CREATE INDEX idx_tmp_dn_purgewo_jp_id ON tmp_dn_purgewo(jp_id)';
      EXECUTE 'CREATE INDEX idx_tmp_dn_purgewo_jt_id ON tmp_dn_purgewo(jt_id)';
     
      SELECT insert_purge_log_msg ('delete_log','Created temp table idx_tmp_dn_purgewo_jt_id and its indices') INTO tmp_result;

      EXECUTE 'SELECT count(*) FROM tmp_dn_purgewo' INTO purge_wo_num;
      SELECT insert_purge_log_msg ('delete_log','Start to purge total '||purge_wo_num||' work orders from denormalized tables') INTO tmp_result;

      VSQL := 'DELETE FROM ttv_taskinstance where tokenid IN (SELECT jt_id FROM tmp_dn_purgewo)';
      SELECT purgewoobject(VSQL,'delete ttv_taskinstance') INTO tmp_result;
      SELECT insert_purge_log_msg ('delete_log','Finished ttv_taskinstance') INTO tmp_result;

      vsql := 'DELETE FROM ttv_processinstance WHERE processid in (select jp_id from tmp_dn_purgewo)';
      SELECT purgewoobject(VSQL,'delete ttv_processinstance') INTO tmp_result;
      SELECT insert_purge_log_msg ('delete_log','Finished ttv_processinstance') INTO tmp_result;

      VSQL := 'DELETE FROM ttv_token WHERE tokenid IN (SELECT jt_id FROM tmp_dn_purgewo)';
      SELECT purgewoobject(VSQL,'delete ttv_token') INTO tmp_result;
      SELECT insert_purge_log_msg ('delete_log','Finished ttv_token') INTO tmp_result;

      VSQL := 'INSERT INTO wfs.elastic_search_wopurge_ids  SELECT jp_id, clock_timestamp()::timestamp FROM wfs.tmp_dn_purgewo';
      SELECT purgewoobject(VSQL,'insert into elastic_search_wopurge_ids') INTO tmp_result;
      SELECT insert_purge_log_msg ('delete_log','Finished inserting denormalized wo ids into elastic_search_wopurge_ids') INTO tmp_result;
   END IF;
      SELECT insert_purge_log_msg ('delete_log','Purge script completed for denormalized tables successfully') INTO tmp_result;
      return 0;
EXCEPTION
    WHEN OTHERS THEN
      select SUBSTR('Error in function_purge_cms_dn_wos function : '||'-'||SQLERRM, 1, 500) into err_msg;
      SELECT insert_purge_log_msg('delete_log',err_msg) INTO tmp_result;
      return 1;
END;
$func_purge_cms_dn_wos$ LANGUAGE plpgsql;

DO $$declare
   results smallint;
begin
   select purge_cms_dn_wos() into results;
end$$;

