#!/bin/sh
####################################################################
# Name of the file : purge_cms_mdr.sh                              #
####################################################################
# Description : Script to purge the CMS Metadata revision data     #
# Parameters  : 1) Metadata latest revisions to retention          #
#                                                                  #
# Created by  : Suresh Neravati                                    #
# Date        : 06/19/2018                                         #
####################################################################
DB_TYPE="postgres"
DB_NAME="ttv"
DB_SETTINGS="/opt/db/scripts/install/settings"
if [[ -f $DB_SETTINGS ]]; then
    . "$DB_SETTINGS"
fi
latest_revs_retain=$1
PDIR="/opt/db/scripts/cms"
PGP="Wf\$1234"
HOST_NAME="dbserver"
CAN_RUN_USER="root"
DB_VER=${DB_VERSION:-9.5}
PSQLHOME="/usr/pgsql-${DB_VER}/bin"

if [ `whoami` !=  "${CAN_RUN_USER}" ]; then
   echo "************************************************************************************"
   echo "Only ${CAN_RUN_USER} user can run this script. Please log in as ${CAN_RUN_USER} user and try again...!"
   echo "************************************************************************************"
   exit 1
fi
PORT=${DB_PORT:-5432}
export PGPASSWORD=${PGP}

if [ "$DB_NAME" = "" ]; then
   echo "*****************************************************************"
   echo " Database SID should not be null, please try again....!"
   echo "*****************************************************************"
   exit 1
fi

if [ "$latest_revs_retain" = "" ]; then
   echo "*****************************************************************************************"
   echo "First parameter should be the maximum number of latest revisions to retain on metadata,"
   echo "Please try again....!"
   echo "*****************************************************************************************"
   exit 1
fi

if [ $latest_revs_retain -lt 2 ]; then
   echo "*****************************************************************************************"
   echo "The maximum number of latest revisions to retain should not be less than two,"
   echo "Please try again....!"
   echo "*****************************************************************************************"
   exit 1
fi

DB_USER="wfs"
if [ "X${DB_TYPE}" = "Xazure" ]; then
     DB_USER="wfs@$AZURE_DB"
fi

echo "------------------------------------------------------------"
echo " Metadata revisions purge script started at $(date)"
echo "------------------------------------------------------------"
${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${DB_USER} -q -t -c "DROP FUNCTION IF EXISTS insert_purge_log_msg (varchar,varchar,timestamp,varchar);"
${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${DB_USER} -q -t -c "DROP FUNCTION IF EXISTS purge_cms_mdr();" >> /dev/null
${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ttv -U ${DB_USER} --set lrr=${latest_revs_retain} -f ${PDIR}/purge_cms_mdr.sql
psql_exit_status=$?
if [ "${psql_exit_status}" -eq 0  ]; then
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ttv -U ${DB_USER} -c "select * from wfs.delete_mdr_log;"
else
   echo "Error while executing the metadata revisions purge script, exiting...."
fi
echo "------------------------------------------------------------"
echo " Metadata revisions purge script ended at $(date)"
echo "------------------------------------------------------------"

exit
