\set VERBOSITY terse
PREPARE get_dkd AS SELECT :'dkd'::text;

do $$declare
  vsql text;
BEGIN
  EXECUTE 'DROP TABLE IF EXISTS delete_me_log';
  EXECUTE 'CREATE TABLE IF NOT EXISTS delete_me_log( Message varchar(4000), recordTime timestamp default clock_timestamp()::timestamp )';
END$$;

DROP FUNCTION IF EXISTS purgemeobject(varchar, varchar, varchar);
CREATE OR REPLACE FUNCTION purgemeobject(vsql varchar,errmsg varchar default null, mask varchar default 'N') RETURNS smallint AS $func_purgemeobject$
DECLARE
   verrmsg text;
BEGIN
   EXECUTE vsql;
   return 0;
EXCEPTION
   WHEN others THEN
      select substring(errmsg,1,200) into verrmsg;
      verrmsg := sqlstate||' - Error : "'||verrmsg ||'", '||sqlerrm||'-- '||vsql;
      if upper(mask) != 'Y' then
         EXECUTE 'INSERT INTO delete_log values('''||verrmsg||''',clock_timestamp()::timestamp)';
         raise notice 'Error: % ',verrmsg;
         raise exception 'Error: % ',verrmsg;
      end if;
      return 1;
END;
$func_purgemeobject$ LANGUAGE plpgsql;

--DROP FUNCTION IF EXISTS insert_purge_log_msg( varchar, varchar, timestamp, varchar);
CREATE OR REPLACE FUNCTION insert_purge_log_msg(vtblname varchar, vsql varchar, vpurgetime timestamp default clock_timestamp()::timestamp, mask_msg varchar default 'N') RETURNS smallint AS $func_insert_purge_log_msg$
DECLARE
    verrmsg varchar;
    tmp_result   smallint;
BEGIN
    EXECUTE 'INSERT INTO '||vtblname||' (Message, recordTime) VALUES('''||vsql||''',clock_timestamp()::timestamp)';
    --dbms_output.put_line(vsql);
    return 0;
EXCEPTION
  WHEN others THEN
    select substr(vsql ||'  - Error : '||sqlerrm,1,200) into verrmsg;
    if upper(mask_msg) != 'Y' then
      EXECUTE 'INSERT INTO delete_log values('''||verrmsg||''',clock_timestamp()::timestamp)';
      raise notice 'Error: % ',verrmsg;
      raise exception 'Error: % ',verrmsg;
    end if;
    return 1;
END;
$func_insert_purge_log_msg$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION purge_cms_me() RETURNS smallint AS $func_purge_cms_me$
DECLARE
    wk_message       varchar(500);
    vsql             varchar;
    tmp_result       smallint;
    me_req_num       numeric:=0;    
    err_msg          varchar;
    retention_days   numeric;
BEGIN
  EXECUTE 'EXECUTE get_dkd' INTO retention_days;
  IF ( retention_days > 0 ) THEN

    VSQL:='INSERT INTO DELETE_ME_LOG (Message, recordTime) VALUES(''Purge ME requests script started'',clock_timestamp()::timestamp)';
    SELECT purgemeobject(vsql,'INSERT DELETE_ME_LOG') INTO tmp_result;

    -- Drop and recreate the table tmpPurgeRequestId to store all delete candidate records
    vsql:='Drop table if exists tmpPurgeRequestId';
    SELECT purgemeobject(VSQL,'DROP tmpPurgeRequestId','Y') INTO tmp_result;
/*
    VSQL:='CREATE TABLE tmpPurgeRequestId(requestId) 
			AS SELECT DISTINCT id              
			FROM WFS.ME_REQUEST              
			WHERE createdate < (to_date(to_char(clock_timestamp()::date, ''yyyy-mm-dd''),''yyyy-mm-dd'')- '||retention_days||')';
*/
    -- comeback here to fix the query
    VSQL:='CREATE TABLE tmpPurgeRequestId(requestId) 
			AS SELECT DISTINCT id              
			FROM WFS.ME_REQUEST              
			where createdate < ( date ''today'' - interval '''||retention_days::text||' days'')';
    SELECT purgemeobject(VSQL,'CREATE tmpPurgeRequestId','Y') INTO tmp_result;
    ALTER TABLE tmpPurgeRequestId ADD PRIMARY KEY (requestId);
    
    EXECUTE 'select count(*) from tmpPurgeRequestId' INTO me_req_num;
    SELECT insert_purge_log_msg ('delete_me_log','Start to purge total '||me_req_num||' ME Request') INTO tmp_result;

    VSQL:='delete from ME_CACHE_RESULT where request_id in (select requestId from tmpPurgeRequestId)';        
    SELECT purgemeobject(VSQL,'DELETE ME_CACHE_RESULT','Y') INTO tmp_result;
    SELECT insert_purge_log_msg ('delete_me_log','Finished ME_CACHE_RESULT') INTO tmp_result;

    VSQL:='delete from ME_REQUEST where id in (select requestId from tmpPurgeRequestId)';        
    SELECT purgemeobject(VSQL,'DELETE ME_REQUEST','Y') INTO tmp_result;
    SELECT insert_purge_log_msg ('delete_me_log','Finished ME_REQUEST') INTO tmp_result;

    SELECT insert_purge_log_msg ('delete_me_log','Purge ME requests scripts completed successfully') INTO tmp_result;
  END IF;
  return 0;
EXCEPTION
    WHEN OTHERS THEN
    SELECT SUBSTR('Error : '||'-'||SQLERRM, 1, 500) INTO err_msg;
    VSQL    := 'INSERT INTO DELETE_ME_LOG (MESSAGE, RECORDTIME) VALUES('''||err_msg||''', clock_timestamp()::timestamp)';
    SELECT CREATEOBJECT(VSQL,'insert DELETE_ME_LOG ERROR!') INTO tmp_result;
    return 1;
END;
$func_purge_cms_me$ LANGUAGE plpgsql;

DO $$declare
   results smallint;
begin
   select purge_cms_me() into results;
end$$;

