
\set VERBOSITY terse
PREPARE get_trm AS SELECT :'trm'::text;
PREPARE get_ttbd AS SELECT :'ttbd'::text;

do $$declare
  vsql text;
BEGIN
  EXECUTE 'DROP TABLE if exists purge_log';
  EXECUTE 'CREATE TABLE IF NOT EXISTS purge_log ( Message varchar(4000), recordTime timestamp default clock_timestamp()::timestamp )';
END$$;

CREATE OR REPLACE FUNCTION purgetitleobject(vsql varchar, errmsg varchar default null, mask varchar default 'N') RETURNS smallint AS $func_purgetitleobject$
DECLARE
   verrmsg text;
BEGIN
   EXECUTE vsql;
   return 0;
EXCEPTION 
   WHEN others THEN 
      select substring(errmsg,1,200) into verrmsg;
      verrmsg := sqlstate||' - Error : "'||verrmsg ||'", '||sqlerrm||'-- '||vsql;
      if upper(mask) != 'Y' then
         EXECUTE 'INSERT INTO purge_log values('''||verrmsg||''',clock_timestamp()::timestamp)';
         raise notice 'Error: % ',verrmsg;
         raise exception 'Error: % ',verrmsg;
      end if;
      return 1;
END; 
$func_purgetitleobject$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION  insert_purge_log_msg(vtblname varchar, vsql varchar, vpurgetime timestamp default clock_timestamp()::timestamp, mask_msg varchar default 'N') RETURNS smallint AS $func_insert_purge_log_msg$
DECLARE
    verrmsg varchar;
    tmp_result   smallint;
BEGIN
    EXECUTE 'INSERT INTO '||vtblname||' (Message, recordTime) VALUES('''||vsql||''',clock_timestamp()::timestamp)';
    --raise notice 'vsql= %',vsql;
    return 0;
EXCEPTION
  WHEN others THEN
    select substr(vsql ||'  - Error : '||sqlerrm,1,200) into verrmsg;
    if upper(mask_msg) != 'Y' then
      raise notice 'Error: % ',verrmsg;
      raise exception 'Error: % ',verrmsg;
    end if;
    return 1;
END; 
$func_insert_purge_log_msg$ LANGUAGE plpgsql;

do $$
begin
   execute drop_purge_table_cons();
EXCEPTION
   WHEN OTHERS THEN
      raise notice 'Error while dropping the purge table constraints - %', sqlerrm ;
      raise exception 'Error while dropping the purge table constraints: % ',sqlerrm;
end$$;

CREATE OR REPLACE FUNCTION purge_cms_titles() RETURNS smallint AS $function_purge_cms_titles$
DECLARE
    wk_message  varchar(500);
    wk_release  varchar(30);
    ptbefore    numeric:=0;
    ptafter     numeric:=0;
    tmp_result  smallint;
    err_msg     text;
    vsql        text;
    vtrm        numeric; 
    vttbd       numeric;
BEGIN
    EXECUTE 'EXECUTE get_trm' INTO vtrm;
    EXECUTE 'EXECUTE get_ttbd' INTO vttbd;
    IF ((vttbd > 0) AND (vtrm >= 0 )) THEN    
        -- Drop the purge_log
        vsql:='DROP TABLE if exists purge_log';
        SELECT purgetitleobject(vsql,'DROP TABLE purge_log','Y') INTO tmp_result;
  
        -- Create purge_log table
        vsql:='CREATE TABLE purge_log(Message varchar(4000), recordTime timestamp default clock_timestamp()::timestamp)';
        SELECT purgetitleobject(vsql,'CREATE TABLE purge_log') INTO tmp_result;
  
        VSQL:='INSERT INTO purge_log (Message, recordTime) VALUES(''Script started'',clock_timestamp()::timestamp)';
        SELECT purgetitleobject(vsql,'INSERT INTO purge_log','N') INTO tmp_result;   

        -- Added create index on 06/10/2013 to speedup the tmp table creation.
        VSQL := 'create index prgtmp_title_idx on pmm_title(originaltitle_id, id_, asset_id, mdmdocid)';
        --SELECT purgetitleobject(VSQL,'create index prgtmp_title_idx on pmm_title','Y');

        -- Drop and recreate the table tmp_purge_title to store all delete candidate records
        vsql:='Drop table if exists tmp_purge_title';
        SELECT purgetitleobject(vsql,'DROP tmp_purge_title','Y') INTO tmp_result;

        vsql:='CREATE TABLE tmp_purge_title(title_id, originaltitle_id, asset_id, mdmdocid) AS
               WITH RECURSIVE wo_path_graph AS (SELECT t.id_, t.originaltitle_id, t.asset_id, t.mdmdocid, t.updatedate, 1 as level
               FROM pmm_title t WHERE t.titlestatusid=5 AND t.originaltitle_id IS NULL AND t.updatedate < ( date ''today''  - interval '''||vtrm::text||' days'' )
               UNION ALL SELECT ti.id_, ti.originaltitle_id, ti.asset_id, ti.mdmdocid,  wo_path_graph.updatedate, wo_path_graph.level+1 as level
               FROM pmm_title ti JOIN wo_path_graph on (ti.originaltitle_id = wo_path_graph.id_))
               SELECT wo_path_graph.id_, wo_path_graph.originaltitle_id, wo_path_graph.asset_id, wo_path_graph.mdmdocid
               FROM wo_path_graph order by wo_path_graph.updatedate, coalesce (wo_path_graph.originaltitle_id, wo_path_graph.id_),id_';

        SELECT purgetitleobject(vsql,'CREATE TABLE tmp_purge_title','Y') INTO tmp_result;

        vsql:= 'ALTER TABLE tmp_purge_title ADD PRIMARY KEY (title_id)';
        SELECT purgetitleobject(vsql,'ALTER TABLE tmp_purge_title ADD PRIMARY KEY (title_id)','Y') INTO tmp_result;      

        SELECT insert_purge_log_msg('purge_log','Createad temp table tmp_purge_title and its primary key', clock_timestamp()::timestamp) INTO tmp_result;
        
        vsql:='Drop table if exists tmp_purge_title_master';
        SELECT purgetitleobject(vsql,'DROP tmp_purge_title_master','Y') INTO tmp_result;      
     
        vsql:='CREATE TABLE tmp_purge_title_master(title_id, originaltitle_id, asset_id, mdmdocid ) 
               AS SELECT a.title_id, a.originaltitle_id, a.asset_id, a.mdmdocid 
                    FROM (SELECT title_id, originaltitle_id, asset_id, mdmdocid FROM tmp_purge_title limit '|| vttbd::text ||') a 
                   WHERE a.originaltitle_id IS NULL';  
  
        SELECT purgetitleobject(vsql,'CREATE TABLE tmp_purge_title_master','Y') INTO tmp_result;
        execute 'ALTER TABLE tmp_purge_title_master ADD PRIMARY KEY (title_id)';
      
        SELECT insert_purge_log_msg('purge_log','Createad temp table tmp_purge_title_master and its primary key', clock_timestamp()::timestamp) INTO tmp_result;

        vsql:='Drop table if exists tmp_purging_titles';
        SELECT purgetitleobject(vsql,'DROP tmp_purging_titles','Y') INTO tmp_result;      
      
        vsql:='CREATE TABLE  tmp_purging_titles(title_id, originaltitle_id, asset_id, mdmdocid) 
               AS SELECT id_, originaltitle_id, asset_id, mdmdocid FROM pmm_title 
                   WHERE originaltitle_id IN (SELECT title_id FROM tmp_purge_title_master) union all
                   select title_id, originaltitle_id, asset_id, mdmdocid from tmp_purge_title_master';  
        SELECT purgetitleobject(vsql,'CREATE TABLE tmp_purging_titles','Y') INTO tmp_result;

        EXECUTE 'select count(*) from tmp_purging_titles' INTO ptbefore;
        vsql:='INSERT INTO tmp_purging_titles(title_id, originaltitle_id, asset_id, mdmdocid) 
               SELECT id_, originaltitle_id, asset_id, mdmdocid FROM pmm_title 
                  WHERE id_ in (SELECT id_ FROM pmm_title  
                                 WHERE originaltitle_id IS NOT NULL 
                                   AND titlestatusid=5
                                   AND updatedate < ( date ''today'' -  interval '''||vtrm::text||' days'' )
                                EXCEPT
                                SELECT title_id FROM tmp_purge_title)';  
        SELECT purgetitleobject(vsql,'INSERT INTO TABLE tmp_purging_titles','Y') INTO tmp_result;
        EXECUTE 'select count(*) from tmp_purging_titles' INTO ptafter;

        EXECUTE 'ALTER TABLE tmp_purging_titles ADD PRIMARY KEY (title_id)';
        
        SELECT insert_purge_log_msg('purge_log','Createad temp table tmp_purging_titles and its primary key', clock_timestamp()::timestamp) INTO tmp_result;

        if ( ptafter - ptbefore) > 0 then
           SELECT insert_purge_log_msg('purge_log','Additionally purging '||(ptafter - ptbefore)||' logically deleted site titles', clock_timestamp()::timestamp) INTO tmp_result;
        end if;
      
        vsql:='create index idx_tmp_purging_titles_mdmdoc on tmp_purging_titles (mdmdocid)';
        SELECT purgetitleobject(vsql,'create index idx_tmp_purging_titles_mdmdoc','Y') INTO tmp_result;

        SELECT insert_purge_log_msg('purge_log','Start to purge total '||ptafter||' titles', clock_timestamp()::timestamp) INTO tmp_result;

        vsql := 'DELETE FROM cms_assetlist_asset_metadata WHERE assetlist_assetmap_id IN (SELECT id FROM cms_assetlist_asset_map WHERE title_id IN (SELECT title_id FROM tmp_purging_titles))';
        --vsql := 'DELETE FROM cms_assetlist_asset_metadata WHERE assetlist_assetmap_id IN (SELECT ap.id FROM cms_assetlist_asset_map ap, tmp_purging_titles tp  WHERE ap.title_id =tp.title_id )';
        SELECT purgetitleobject(vsql,'delete cms_assetlist_asset_metadata') INTO tmp_result;
        SELECT insert_purge_log_msg('purge_log','deleted cms_assetlist_asset_metadata', clock_timestamp()::timestamp,'N') INTO tmp_result;

        vsql := 'DELETE FROM cms_assetlist_asset_map WHERE title_id IN (SELECT title_id FROM tmp_purging_titles)';
        SELECT purgetitleobject(vsql,'delete cms_assetlist_asset_map') INTO tmp_result;
        SELECT insert_purge_log_msg('purge_log','deleted cms_assetlist_asset_map', clock_timestamp()::timestamp) INTO tmp_result;

        vsql := 'DELETE FROM sites_tracksitetitle WHERE titleid IN (SELECT title_id FROM tmp_purging_titles)';
        SELECT purgetitleobject(vsql,'delete sites_tracksitetitle') INTO tmp_result;
        SELECT insert_purge_log_msg('purge_log','deleted sites_tracksitetitle', clock_timestamp()::timestamp) INTO tmp_result;

        vsql := 'DELETE FROM sites_distsitetitle WHERE titleid IN (SELECT title_id FROM tmp_purging_titles)';
        SELECT purgetitleobject(vsql,'delete sites_distsitetitle') INTO tmp_result;
        SELECT insert_purge_log_msg('purge_log','deleted sites_distsitetitle', clock_timestamp()::timestamp) INTO tmp_result;

        vsql := 'DELETE FROM pmm_properties WHERE titleid IN (SELECT title_id FROM tmp_purging_titles)';
        SELECT purgetitleobject(vsql,'delete pmm_properties') INTO tmp_result;
        SELECT insert_purge_log_msg('purge_log','deleted pmm_properties', clock_timestamp()::timestamp) INTO tmp_result;

        vsql := 'DELETE FROM pmm_progressitem WHERE titleid IN (SELECT title_id FROM tmp_purging_titles)';
        SELECT purgetitleobject(vsql,'delete pmm_progressitem') INTO tmp_result;
        SELECT insert_purge_log_msg('purge_log','deleted pmm_progressitem', clock_timestamp()::timestamp) INTO tmp_result;

        vsql := 'DELETE FROM pmm_title_titlelistxref WHERE titleid IN (SELECT title_id FROM tmp_purging_titles)';
        SELECT purgetitleobject(vsql,'delete pmm_title_titlelistxref') INTO tmp_result;
        SELECT insert_purge_log_msg('purge_log','deleted pmm_title_titlelistxref', clock_timestamp()::timestamp) INTO tmp_result;

        vsql := 'DELETE FROM pmm_titleasset_property WHERE titleid IN (SELECT title_id FROM tmp_purging_titles)';
        SELECT purgetitleobject(vsql,'delete pmm_titleasset_property') INTO tmp_result;
        SELECT insert_purge_log_msg('purge_log','deleted pmm_titleasset_property', clock_timestamp()::timestamp) INTO tmp_result;

        vsql := 'DELETE FROM pmm_titleassetstatus WHERE titleid IN (SELECT title_id FROM tmp_purging_titles)';
        SELECT purgetitleobject(vsql,'delete pmm_titleassetstatus') INTO tmp_result;
        SELECT insert_purge_log_msg('purge_log','deleted pmm_titleassetstatus', clock_timestamp()::timestamp) INTO tmp_result;

        vsql := 'DELETE FROM pmm_title_purge_history WHERE title_id IN (SELECT title_id FROM tmp_purging_titles)';
        SELECT purgetitleobject(vsql,'delete pmm_title_purge_history') INTO tmp_result;
        SELECT insert_purge_log_msg('purge_log','deleted pmm_title_purge_history', clock_timestamp()::timestamp) INTO tmp_result;

        vsql := 'DELETE FROM mdm_metadata_revision mdmr WHERE exists (SELECT mdmdocid FROM tmp_purging_titles t where t.mdmdocid= mdmr.document_id )';
        SELECT purgetitleobject(vsql,'delete mdm_metadata_revision') INTO tmp_result;
        SELECT insert_purge_log_msg('purge_log','deleted mdm_metadata_revision', clock_timestamp()::timestamp) INTO tmp_result;

        vsql := 'DELETE FROM mdm_rootassetrevision mdmrar WHERE exists (SELECT mdmdocid FROM tmp_purging_titles t where t.mdmdocid= mdmrar.asset_id )';
        SELECT purgetitleobject(vsql,'delete mdm_rootassetrevision') INTO tmp_result;
        SELECT insert_purge_log_msg('purge_log','deleted mdm_rootassetrevision', clock_timestamp()::timestamp) INTO tmp_result;

        -- delete transient data from rules tables in case if you find any (Defect D-03565 fixed on 02/17/2015)
        vsql := 'DELETE FROM tre_bulkexecution_contentproc WHERE titleid IN (SELECT title_id FROM tmp_purging_titles)';
        SELECT purgetitleobject(vsql,'delete tre_bulkexecution_contentproc') INTO tmp_result;
        SELECT insert_purge_log_msg('purge_log','deleted tre_bulkexecution_contentproc', clock_timestamp()::timestamp) INTO tmp_result;

        vsql := 'DELETE FROM tre_bulkexecution_general WHERE titleid IN (SELECT title_id FROM tmp_purging_titles)';
        SELECT purgetitleobject(vsql,'delete tre_bulkexecution_general') INTO tmp_result;
        SELECT insert_purge_log_msg('purge_log','deleted tre_bulkexecution_general', clock_timestamp()::timestamp) INTO tmp_result;

        vsql := 'DELETE FROM tre_bulkexecution_failedtitles WHERE titleid IN (SELECT title_id FROM tmp_purging_titles)';
        SELECT purgetitleobject(vsql,'delete tre_bulkexecution_failedtitles') INTO tmp_result;
        SELECT insert_purge_log_msg('purge_log','deleted tre_bulkexecution_failedtitles', clock_timestamp()::timestamp) INTO tmp_result;

        vsql := 'DELETE FROM pmm_title WHERE id_ IN (SELECT title_id FROM tmp_purging_titles) ';
        SELECT purgetitleobject(vsql,'delete pmm_title') INTO tmp_result;
        SELECT insert_purge_log_msg('purge_log','deleted pmm_title',clock_timestamp()::timestamp) INTO tmp_result;
        SELECT insert_purge_log_msg('purge_log','CMS Title purge script finished successfully', clock_timestamp()::timestamp) INTO tmp_result;
    ELSE
      SELECT insert_purge_log_msg('purge_log','Title delete criteria is not correct',clock_timestamp()::timestamp) INTO tmp_result;
    END IF;
    return 0;
EXCEPTION
    WHEN OTHERS THEN
      select SUBSTR('Error in function_purge_cms_titles function : '||'-'||SQLERRM, 1, 500) into err_msg;
      SELECT insert_purge_log_msg('purge_log',err_msg,clock_timestamp()::timestamp) INTO tmp_result;
      return 1;
END;
$function_purge_cms_titles$ LANGUAGE plpgsql;

DO $$declare
   results smallint;
begin
   select purge_cms_titles() into results;
end$$;
