#!/bin/sh
##############################################################
# Name of the file : ptitles.sh                              #
##############################################################
# Description : Script to purge the CMS work orders          #
# Parameters  : 1) Titles retention days                     #
#                                                            #
# Created by  : Suresh Neravati                              #
# Date        : 10/19/2011                                   #
##############################################################
DB_TYPE="edb"
DB_NAME="ttv"
DB_SETTINGS="/opt/db/scripts/install/settings"
if [[ -f $DB_SETTINGS ]]; then
    . "$DB_SETTINGS"
fi
vdays_keep_data=$1
PDIR="/opt/db/scripts/cms"
PGP="Wf\$1234"
HOST_NAME="dbserver"
CAN_RUN_USER="root"
DB_VER=${DB_VERSION:-10}
PSQLHOME="/usr/pgsql-${DB_VER}/bin"

# only ${CAN_RUN_USER} user can run this script.
if [ `whoami` !=  "${CAN_RUN_USER}" ]; then
  echo "************************************************************************************"
  echo "Only ${CAN_RUN_USER} user can run this script. Please log in as ${CAN_RUN_USER} user and try again...!"
  echo "************************************************************************************"
  exit 1
fi
PORT=${DB_PORT:-5444}
export PGPASSWORD=${PGP}

if [ "$DB_NAME" = "" ]; then
   echo "*****************************************************************"
   echo " Database SID should not be null, please try again....!"
   echo "*****************************************************************"
   exit 1
fi

if [ "$vdays_keep_data" = "" ]; then
   echo "*****************************************************************************************"
   echo "First parameter must be the number of days to retain data, please try again....!"
   echo "*****************************************************************************************"
   exit 1
fi

if [ $vdays_keep_data -lt 1 ]; then
   echo "*****************************************************************************************"
   echo "First parameter number of days to maintain previous data should not be less than one,"
   echo "Please try again....!"
   echo "*****************************************************************************************"
   exit 1
fi

DB_USER="wfs"
if [ "X${DB_TYPE}" = "Xazure" ]; then
     DB_USER="wfs@$AZURE_DB"
fi

echo "------------------------------------------------------------"
echo " Work order script started at $(date)"
echo "------------------------------------------------------------"
${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${DB_USER} -q -t -c "DROP FUNCTION IF EXISTS insert_purge_log_msg (varchar,varchar,timestamp,varchar);"
${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ttv -U ${DB_USER} -q -t -c "DROP FUNCTION IF EXISTS purge_cms_wos();" >> /dev/null
${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ttv -U ${DB_USER} --set dkd=$vdays_keep_data -f ${PDIR}/purge_cms_wos.sql
psql_exit_status=$?
if [ "${psql_exit_status}" -eq 0  ]; then
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ttv -U ${DB_USER} --set dkd=$vdays_keep_data -f ${PDIR}/purge_cms_dn_wos.sql
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ttv -U ${DB_USER} -c "select * from wfs.delete_log;"
else
   echo "Error while executing the purge work order script, exiting...."
fi

echo "------------------------------------------------------------"
echo " Work order script ended at $(date)"
echo "------------------------------------------------------------"

exit
