#!/bin/sh
######################################################################
# Name of the file : purge_elasticsearch_wos.sh                      #
######################################################################
# Description : Script to purge the CMS WOs from the Elastic search. #
#               This script deletes the Workorders that are          #
#               successfully deleted from database. If geo site      #
#               exists, it will delete from both sites.              #
#                                                                    #
# Created by  : Siva Soumya Mandadi                                  #
# Date        : 03/23/2015                                           #
#                                                                    #
# Modified by : Suresh Neravati on 03/07/2017 to work from app node  #
######################################################################

#Defined below are variables needed
DB_TYPE="edb"
DB_NAME="ttv"
ES_SERVER="es"
DB_SETTINGS="/opt/db/scripts/install/settings"
if [[ -f $DB_SETTINGS ]]; then
    . "$DB_SETTINGS"
fi
CURR_WO_ID=1
PGP="Wf\$1234"
WO_ID_PURGED=""
WO_ID_BATCH_LIMIT=1000
LOG_DIR="/opt/db/scripts/cms"
LOG_FILE="purge_elasticsearch_wos.log"
HOST_NAME="dbserver"
GEO_CONF_DIR="/opt/tandbergtv"
GEO_CONF_FILE="geo.conf"
IS_GEO=no
CAN_RUN_USER="root"
DB_VER=${DB_VERSION:-10}
PSQLHOME="/usr/pgsql-${DB_VER}/bin"

# only ${CAN_RUN_USER} user can run this script.
if [ `whoami` !=  "${CAN_RUN_USER}" ]; then
  echo "************************************************************************************"
  echo "Only ${CAN_RUN_USER} user can run this script. Please log in as ${CAN_RUN_USER} user and try again...!"
  echo "************************************************************************************"
  exit 1
fi

DB_USER="wfs"
if [ "X${DB_TYPE}" = "Xazure" ]; then
     DB_USER="wfs@$AZURE_DB"
fi

if [[ -f ${GEO_CONF_DIR}/${GEO_CONF_FILE} ]]; then
  SEC_DOMAIN=$(grep -i SECONDARY_DOMAIN ${GEO_CONF_DIR}/${GEO_CONF_FILE}| cut -f2 -d"=" | sed 's/^ *//')
  if [[ "X${SEC_DOMAIN}" = "X" ]]; then
    echo -e "\nNo Secondary Domain\n"
  else
    IS_GEO=yes
  fi
fi
PORT=${DB_PORT:-5444}
export PGPASSWORD=${PGP}
TOTAL_COUNT=$(${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${DB_USER} -q -t -c "select count(*) from elastic_search_wopurge_ids;")
if [[ "$TOTAL_COUNT" -eq "0" ]] ; then
  echo "**************************************************************"
  echo "No workorders to purge from Elasticsearch"
  echo "**************************************************************"
  exit 1
fi

echo "**************************************************************"
echo "Start to purge "$TOTAL_COUNT" workorders from Elasticsearch."
echo "**************************************************************"

# delete WO's in batches of 100
# only WO removes from table if successfully purge from primary and secondary if available
while [[ "$TOTAL_COUNT" -gt "0" ]] ; do
  esWOlist=$(${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${DB_USER} -q -t -c "select distinct wopurge_id from wfs.elastic_search_wopurge_ids where wopurge_id>='$CURR_WO_ID' order by wopurge_id offset 0 limit $WO_ID_BATCH_LIMIT;")
  WO_IDS_TO_PURGE=""
  for woID in $esWOlist ; do
    WO_IDS_TO_PURGE=\"$woID\"","$WO_IDS_TO_PURGE
  done
  WO_IDS_TO_PURGE=${WO_IDS_TO_PURGE%?}
  
  curl_cmd="curl -s -X POST \"http://$ES_SERVER:9200/wfs/_delete_by_query\" -H 'Content-Type: application/json' -d'{\"query\":{\"ids\":{\"type\":\"_doc\",\"values\":[${WO_IDS_TO_PURGE}]}}}' -o /dev/null -w '%{http_code}'"
  httpCode=$(eval $curl_cmd)

  if [[ -z "$httpCode" ]] ; then
    echo "**************************************************************"
    echo " Connection failed to Elasticsearch Node: $ES_SERVER"
    echo "**************************************************************"
    exit 1
  elif [[ "$httpCode" -eq "200" ]] || [[ "$httpCode" -eq "404" ]] ; then
    if [[ "$IS_GEO" = "yes" ]] ; then
      curl_cmd="curl -s -X POST \"http://$ES_SERVER.$SEC_DOMAIN:9200/wfs/_delete_by_query\" -H 'Content-Type: application/json' -d'{\"query\":{\"ids\":{\"type\":\"_doc\",\"values\":[${WO_IDS_TO_PURGE}]}}}' -o /dev/null -w '%{http_code}'"
      httpCode2=$(eval $curl_cmd)
      if [[ "$httpCode2" -eq "200" ]] || [[ "$httpCode2" -eq "404" ]] ; then
        success="purged"
      fi
    else
      success="purged"
    fi
  fi
  
  WO_ID_PURGED=""
  if [[ "$success" = "purged" ]] ; then
      WO_ID_PURGED=$(echo $WO_IDS_TO_PURGE |sed 's/"//g')
  else
    echo -e "$WO_IDS_TO_PURGE" >> $LOG_DIR/$LOG_FILE
  fi
  CURR_WO_ID=$woID
  
  if [[ ! -z "$WO_ID_PURGED" ]] ; then
    ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${DB_USER} -q -t -c "delete from elastic_search_wopurge_ids where wopurge_id in ($WO_ID_PURGED);"
    echo "WO IDs:$WO_ID_PURGED purged from Elasticsearch"
  fi
  TOTAL_COUNT=$((TOTAL_COUNT - WO_ID_BATCH_LIMIT))
done
echo "******************************************************************"
echo "No more workorders to purge from Elasticsearch"
echo "End of the purge work order script"
echo "------------------------------------------------------------------"
exit 0


