"""
This software has been developed by Ericsson.

Copyright (c) 2016 Ericsson, Inc.

COPYRIGHT:
    This file is the property of Ericsson.
    It cannot be copied, used, or modified without obtaining
    an authorization from the authors or a mandated
    member of Ericsson.
    If such an authorization is provided, any modified version or
    copy of the software must contain this header.

 WARRANTIES:
    This software is made available by the authors in the hope
    that it will be useful, but without any warranty.
    Ericsson.com is not liable for any consequence related to the
    use of the provided software.
"""

from __future__ import (absolute_import, division, print_function)
import sys


class Deploypattern(Exception):
    """
    A base class from which all other exceptions inherit.
    """


class FileNotFound(Deploypattern):
    """
    A custom class when file is not found.
    """
    pass


class PathNotFound(Deploypattern):
    """
    A custom class when path is not found.
    """
    pass


class InvalidConfig(Deploypattern):
    """
    A custom class when there is an error about config info.
    """
    pass


class LoadError(Deploypattern):
    """
    A custom class when error occurs during 'load' step.
    """
    pass


class ImageNameError(Deploypattern):
    """
    A custom class when container image is not found on registry.
    """
    pass


class InitNotDone(Deploypattern):
    """
    A custom class when init has not been done yet.
    """
    pass


class AnsibleError(Deploypattern):
    """
    A custom class when there is ansible error.
    """
    pass


class InitError(Deploypattern):
    """
    A custom class when error occurs during 'init' step.
    """
    pass


class ConnectionError(Deploypattern):
    """
    A custom class when ssh connection error occurs.
    """
    pass


class PatternError(Deploypattern):
    """
    A custom class when input pattern has bad format.
    """
    pass


class LabelError(Deploypattern):
    """
    A custom class when label Error.
    """
    pass


class BundleError(Deploypattern):
    """
    A custom class when label Error.
    """
    pass


class K8sApiError(Deploypattern):
    """
    A custom class when K8s.
    """
    pass


class DeployError(Deploypattern):
    """
    A custom class when Deploy Error occurs.
    """
    pass


class YamlError(Deploypattern):
    """
    A custom class when Deploy Error occurs.
    """
    pass


def quiet_hook(kind, message, traceback):
    """
    remove traceback of Deploypattern exception
    """
    if Deploypattern in kind.__bases__:
        # Only print Error Type and Message
        print('{0}: {1}'.format(kind.__name__, message))
    else:
        # Print Error Type, Message and Traceback
        sys.__excepthook__(kind, message, traceback)


sys.excepthook = quiet_hook
