"""
This software has been developed by Ericsson.

Copyright (c) 2016 Ericsson, Inc.

COPYRIGHT:
    This file is the property of Ericsson.
    It cannot be copied, used, or modified without obtaining
    an authorization from the authors or a mandated
    member of Ericsson.
    If such an authorization is provided, any modified version or
    copy of the software must contain this header.

 WARRANTIES:
    This software is made available by the authors in the hope
    that it will be useful, but without any warranty.
    Ericsson.com is not liable for any consequence related to the
    use of the provided software.
"""
from __future__ import (absolute_import, division, print_function)

import logging

LOGGER = logging.getLogger(__name__)

__PLUGINS = []


def register_plugin(name, cls):
    """ Register plugins """
    LOGGER.debug("register : %s - %s", name, cls.__name__)
    __PLUGINS.append((name, cls))


def load_plugin(name):
    """ Load plugins """
    for __name, __cls in __PLUGINS:
        if __name == name:
            LOGGER.debug("load : %s - %s", __name, __cls.__name__)
            return __cls
    raise NotImplementedError("No plugin name %s" % name)
