"""
This software has been developed by Ericsson.

Copyright (c) 2016 Ericsson, Inc.

COPYRIGHT:
    This file is the property of Ericsson.
    It cannot be copied, used, or modified without obtaining
    an authorization from the authors or a mandated
    member of Ericsson.
    If such an authorization is provided, any modified version or
    copy of the software must contain this header.

 WARRANTIES:
    This software is made available by the authors in the hope
    that it will be useful, but without any warranty.
    Ericsson.com is not liable for any consequence related to the
    use of the provided software.
"""
from __future__ import (absolute_import, division, print_function)

import logging
import subprocess
import os


# try:
#     from subprocess import DEVNULL # py3k
# except ImportError:
#     import os
#     DEVNULL = open(os.devnull, 'wb')

import ericsson.deploypattern.lib.errors as errors

from ericsson.deploypattern.lib.config import Config

LOGGER = logging.getLogger(__name__)

HELM_BIN = '/usr/local/bin/helm'
TMP_DIR_MIN_SIZE = 0.2 #GB

def __get_helm_repo_path():
    """
    Path to Helm repository
    :return:
    """
    helm_repo = Config().get('helm_repo', 'path') + '/' + \
        Config().get('helm_repo', 'name')
    return helm_repo


def create_helm_repo_dir():
    """ Create a local helm repository """
    try:
        helm_repo_path = __get_helm_repo_path()
        LOGGER.info(":: creating Helm repository directory in %s", helm_repo_path)

        if not os.path.exists(helm_repo_path):
            os.makedirs(helm_repo_path)

        # Change directory owner and permissions
        cmd = "chown :1000 " + helm_repo_path + " && chmod g+rwx " + helm_repo_path
        subprocess.Popen(cmd, shell=True, stderr=subprocess.PIPE,
                     stdout=subprocess.PIPE).communicate()

    except Exception as error:
        raise errors.InitError(error)








