{{/* vim: set filetype=mustache: */}}
{{/*
Expand the name of the chart.
*/}}
{{- define "server-api.name" -}}
{{- default .Chart.Name .Values.nameOverride | trunc 63 | trimSuffix "-" -}}
{{- end -}}

{{/*
Create a default fully qualified app name.
We truncate at 63 chars because some Kubernetes name fields are limited to this (by the DNS naming spec).
*/}}
{{- define "server-api.fullname" -}}
{{- $name := default .Chart.Name .Values.nameOverride -}}
{{- printf "%s-%s" .Release.Name $name | trunc 63 | trimSuffix "-" -}}
{{- end -}}

{{- define "mongo.url" -}}
    {{- if eq .Values.env.mongo_replica true -}}
        {{- printf "%s-0.%s:27017,%s-1.%s:27017,%s-2.%s:27017" .Values.mongo_name .Values.mongo_name .Values.mongo_name .Values.mongo_name .Values.mongo_name .Values.mongo_name -}}
    {{- else -}}
        {{- printf "%s-0.%s:27017" .Values.mongo_name .Values.mongo_name -}}
    {{- end -}}
{{- end -}}
