{{/* vim: set filetype=mustache: */}}
{{/*
Expand the name of the chart.
*/}}
{{- define "unified-ui.name" -}}
{{- default .Chart.Name .Values.nameOverride | trunc 63 | trimSuffix "-" -}}
{{- end -}}

{{/*
Create a default fully qualified app name.
We truncate at 63 chars because some Kubernetes name fields are limited to this (by the DNS naming spec).
*/}}
{{- define "unified-ui.fullname" -}}
{{- $name := default .Chart.Name .Values.nameOverride -}}
{{- printf "%s-%s" .Release.Name $name | trunc 63 | trimSuffix "-" -}}
{{- end -}}

{{- define "mongo.url" -}}
    {{- if eq .Values.env.mongo_replica true -}}
        {{- printf "%s-0.%s:27017,%s-1.%s:27017,%s-2.%s:27017" .Values.mongo_name .Values.mongo_name .Values.mongo_name .Values.mongo_name .Values.mongo_name .Values.mongo_name -}}
    {{- else -}}
        {{- printf "%s-0.%s:27017" .Values.mongo_name .Values.mongo_name -}}
    {{- end -}}
{{- end -}}

{{- define "pkgconfigaddr" -}}
    {{- if .Values.connector.packager -}}
        {{- printf "%s" "pkg-config" -}}
    {{- else -}}
        {{- printf "%s" "127.0.0.1" -}}
    {{- end -}}
{{- end -}}

{{- define "elconfigaddr" -}}
    {{- if .Values.connector.encoder -}}
        {{- printf "%s" "el-config" -}}
    {{- else -}}
        {{- printf "%s" "127.0.0.1" -}}
    {{- end -}}
{{- end -}}

{{- define "automationaddr" -}}
    {{- if .Values.connector.encoder -}}
        {{- printf "%s" "automation" -}}
    {{- else -}}
        {{- printf "%s" "127.0.0.1" -}}
    {{- end -}}
{{- end -}}


{{- define "spconfigaddr" -}}
    {{- if .Values.connector.multiplexer -}}
        {{- printf "%s" "sp-config" -}}
    {{- else -}}
        {{- printf "%s" "127.0.0.1" -}}
    {{- end -}}
{{- end -}}

{{- define "odconfigaddr" -}}
    {{- if .Values.connector.ondemand -}}
        {{- printf "%s" "od-config" -}}
    {{- else -}}
        {{- printf "%s" "127.0.0.1" -}}
    {{- end -}}
{{- end -}}

{{- define "odjobmgtaddr" -}}
    {{- if .Values.connector.ondemand -}}
        {{- printf "%s" "od-job-mgt" -}}
    {{- else -}}
        {{- printf "%s" "127.0.0.1" -}}
    {{- end -}}
{{- end -}}

