# unified-ui

[Unified-UI](http://ericsson.com/media)

## TL;DR;

```bash
$ helm install unified-ui
```

## Introduction

This chart bootstraps a unified-ui deployment on a [Kubernetes](http://kubernetes.io) cluster using the [Helm](https://helm.sh) package manager.

## Prerequisites

- Kubernetes 1.7+ with Beta APIs enabled
- PV provisioner support in the underlying infrastructure

## Installing the Chart

To install the chart with the release name `my-release` in namespace mfvp:

```bash
$ helm install --namespace mfvp --name my-release unified-ui
```

The command deploys unified-ui on the Kubernetes cluster in the default configuration. The [configuration](#configuration) section lists the parameters that can be configured during installation.

> **Tip**: List all releases using `helm list`

## Uninstalling the Chart

To uninstall/delete the `my-release` deployment:

```bash
$ helm delete my-release
```

The command removes all the Kubernetes components associated with the chart and deletes the release.

## Configuration

The following table lists the configurable parameters of the unified-ui chart and their default values.

|           Parameter           |                Description                       |           Default            |
|-------------------------------|--------------------------------------------------|------------------------------|
| `replicaCount`                | Replicat Count                                   | 1                            |
| `image.repository`            | Image repository                                 | `repodocker.envivio.com/prod`|
| `image.tag  `                 | Image tag                                        | `{VERSION}`                  |
| `env.rabbitmq_server_addr`    | RabbitMQ address                                 | `rabbitmq                    |
| `env.rabbitmq_server_port`    | RabbitMQ port                                    | `5672`                       |
| `env.mongo_replica`           | Mongo Replica                                    | `true`                       |
| `service.type       `         | Type of service                                  | `ClusterIP`                  |
| `nodeSelector`                | POD node selector                                | ``                           |
| `volumes.log.enable`          | enable volume for log                            | `false`                      |
| `volumes.log.name`            | name of the PV for log                           | ``                           |
| `env.https`                   | enable https                                     | `true`                       |
| `env.https_cert_path`         | path to private certificate for https            | if no present self signed    |
| `env.https_key_path`          | path to private key for https                    | if no present self signed    |
| `env.port`                    | port                                             | `8080`                       |
| `env.port_https`              | port https                                       | `8443`                       |




The above parameters map to the env variables defined in unified-ui container. For more information please refer to the unified-ui image documentation.

Specify each parameter using the `--set key=value[,key=value]` argument to `helm install`. For example,

```bash
$ helm install --namespace mfvp --name my-release \
  --set nodeSelector=mfvpmc\
    unified-ui
```

The above command sets the node selector to `mfvpmc`.

Alternatively, a YAML file that specifies the values for the parameters can be provided while installing the chart. For example,

```bash
$ helm install --namespace mfvp --name my-release -f values.yaml unified-ui
```

> **Tip**: You can use the default [values.yaml](values.yaml)

## Volumes

Log can be exported to an external PV. 

```bash
$ helm install --namespace mfvp --name my-release \
  --set volumes.log.enable=true \
  --set volumes.log.name=log-unified-ui-pv
    unified-ui
```


## Metrics
The chart optionally can start a metrics exporter for [prometheus](https://prometheus.io). The metrics endpoint (port 9121) is exposed in the service. Metrics can be scraped from within the cluster using something similar as the described in the [example Prometheus scrape configuration](https://github.com/prometheus/prometheus/blob/master/documentation/examples/prometheus-kubernetes.yml). If metrics are to be scraped from outside the cluster, the Kubenretes API proxy can be utilized to access the endpoint.
