# encoding live config

[Alarm](http://ericsson.com/media)

## TL;DR;

```bash
$ helm install placement-api
```

## Introduction

This chart bootstraps a placement-api deployment on a [Kubernetes](http://kubernetes.io) cluster using the [Helm](https://helm.sh) package manager.

## Prerequisites

- Kubernetes 1.7+ with Beta APIs enabled
- PV provisioner support in the underlying infrastructure

## Installing the Chart

To install the chart with the release name `my-release` in namespace mfvp:

```bash
$ helm install --namespace mfvp --name my-release placement-api
```

The command deploys placement-api on the Kubernetes cluster in the default configuration. The [configuration](#configuration) section lists the parameters that can be configured during installation.

> **Tip**: List all releases using `helm list`

## Uninstalling the Chart

To uninstall/delete the `my-release` deployment:

```bash
$ helm delete my-release
```

The command removes all the Kubernetes components associated with the chart and deletes the release.

## Configuration

The following tables lists the configurable parameters of the Redis chart and their default values.

|           Parameter           |                Description                       |           Default            |
|-------------------------------|--------------------------------------------------|------------------------------|
| `replicaCount`                | Replicat Count                                   | 1                            |
| `image.repository`            | Image repository                                 | `repodocker.envivio.com/prod`|
| `env.rabbitmq_server_addr`    | RabbitMQ address                                 | `rabbitmq`                   |
| `env.rabbitmq_server_port`    | RabbitMQ port                                    | `5672`                       |
| `env.mongo_replica`           | Mongo Replica                                    | `true`                       |
| `service.type       `         | Type of service                                  | `ClusterIP`                  |
| `nodeSelector`                | POD node selector                                | ``                           |
| `volumes.log.enable`          | enable volume for log                            | `false`                      |
| `volumes.log.name`            | name of the PV for log                           | ``                           |


The above parameters map to the env variables defined in placement-api container. For more information please refer to the placement-api image documentation.

Specify each parameter using the `--set key=value[,key=value]` argument to `helm install`. For example,

```bash
$ helm install --namespace mfvp --name my-release \
  --set nodeSelector=mfvpmc\
    placement-api
```

The above command sets the node selector to `mfvpmc`.

Alternatively, a YAML file that specifies the values for the parameters can be provided while installing the chart. For example,

```bash
$ helm install --namespace mfvp --name my-release -f values.yaml placement-api
```

> **Tip**: You can use the default [values.yaml](values.yaml)

## Volumes

Log can be exported to an external PV.

```bash
$ helm install --namespace mfvp --name my-release \
  --set volumes.log.enable=true \
  --set volumes.log.name=log-placement-api-pv
    placement-api
```


## Metrics
The chart optionally can start a metrics exporter for [prometheus](https://prometheus.io). The metrics endpoint (port 9121) is exposed in the service. Metrics can be scraped from within the cluster using something similar as the described in the [example Prometheus scrape configuration](https://github.com/prometheus/prometheus/blob/master/documentation/examples/prometheus-kubernetes.yml). If metrics are to be scraped from outside the cluster, the Kubenretes API proxy can be utilized to access the endpoint.
