{{/* vim: set filetype=mustache: */}}
{{/*
Expand the name of the chart.
*/}}
{{- define "service-api.name" -}}
{{- default .Chart.Name .Values.nameOverride | trunc 63 | trimSuffix "-" -}}
{{- end -}}

{{/*
Create a default fully qualified app name.
We truncate at 63 chars because some Kubernetes name fields are limited to this (by the DNS naming spec).
*/}}
{{- define "service-api.fullname" -}}
{{- $name := default .Chart.Name .Values.nameOverride -}}
{{- printf "%s-%s" .Release.Name $name | trunc 63 | trimSuffix "-" -}}
{{- end -}}

{{- define "mongo.url" -}}
    {{- if eq .Values.env.mongo_replica true -}}
        {{- printf "%s-0.%s:27017,%s-1.%s:27017,%s-2.%s:27017" .Values.mongo_name .Values.mongo_name .Values.mongo_name .Values.mongo_name .Values.mongo_name .Values.mongo_name -}}
    {{- else -}}
        {{- printf "%s-0.%s:27017" .Values.mongo_name .Values.mongo_name -}}
    {{- end -}}
{{- end -}}


{{/* if release name = chart name do not concat
{{- define "fullname" -}}
{{- $name := default .Chart.Name .Values.nameOverride -}}
{{- if ne .Chart.Name .Release.Name -}}
{{- printf "%s-%s" .Release.Name $name | trunc 63 | trimSuffix "-" -}}
{{- else -}}
{{- printf "%s" $name | trunc 63 | trimSuffix "-" -}}
{{- end -}}
{{- end -}}
*/}}


{{/* Dynaic mongo url
{{- define "mongo.url" -}}
    {{- if eq .Values.env.mongo_replica true -}}
        {{- range $mongocount, $e := until (.Values.mongodbReplicaCount|int) -}}
            {{- printf "%s-mongodb-replicaset-%d." $.Values.mongodbReleaseName $mongocount -}}
            {{- printf "%s-mongodb-replicaset:%d" $.Values.mongodbReleaseName ($.Values.mongodbPort|int) -}}
            {{- if lt $mongocount  ( sub ($.Values.mongodbReplicaCount|int) 1 ) -}}
              {{- printf "," -}}
            {{- end -}}
        {{- end -}}
    {{- else -}}
            {{- printf "%s-mongodb-%d." $.Values.mongodbReleaseName $mongocount -}}
            {{- printf "%s-mongodb:%d" $.Values.mongodbReleaseName ($.Values.mongodbPort|int) -}}
    {{- end -}}
{{- end -}}
*/}}
