#!/usr/bin/env python

__all__ = ['CMSService', 'TomcatService', 'FTPService', 'WorkflowService', 'GenericService']

import time
import socket
import os

from SSHCommander import SSHCommander
from HttpRequestDecorator import HttpRequestDecorator

class APPService(object):
	REMOTE_SRV_CMD = "su root -c 'export PATH=$PATH:/sbin; service %(name)s %(cmd)s'"
	NATIVE_SRV_CMD = "service %(name)s %(cmd)s"
	def __init__(self, name, ipaddr, user, password, rootPasswd, timeout=30, isNative=False):
		self.__service_name = name
		self.__server_ip = ipaddr
		self.__user_name = user
		self.__login_password = password
		self.__root_password = rootPasswd
		
		self.__timeout = timeout
		self.__isNativeService = isNative
		
	def getServerIp(self):
		return self.__server_ip
			
	def start(self):
		if self.__isNativeService:
			self.__command = APPService.NATIVE_SRV_CMD % {'name': self.__service_name, 'cmd': 'start'}
			print os.popen(self.__command, "r").read()
			return
			
		self.__command = APPService.REMOTE_SRV_CMD % {'name': self.__service_name, 'cmd': 'start'}
		
		client = SSHCommander(self.__server_ip, self.__user_name, self.__login_password)
		
		print "starting " + self.__service_name + " on " + self.__server_ip
		status, output = client.execute_interactive(self.__command, self.__root_password, self.__timeout)
		
		print output
		if status != 0:
			print "fail to start " + self.__service_name + " on " + self.__server_ip	
	
	def stop(self):
		if self.__isNativeService:
			self.__command = APPService.NATIVE_SRV_CMD % {'name': self.__service_name, 'cmd': 'stop'}
			print os.popen(self.__command, "r").read()
			return
				
		self.__command = APPService.REMOTE_SRV_CMD % {'name': self.__service_name, 'cmd': 'stop'}
		
		client = SSHCommander(self.__server_ip, self.__user_name, self.__login_password)
		
		print "stopping " + self.__service_name + " on " + self.__server_ip
		status, output = client.execute_interactive(self.__command, self.__root_password, self.__timeout)
		
		print output
		if status != 0:
			print "fail to stop " + self.__service_name + " on " + self.__server_ip	
	
	def restart(self):
		if self.__isNativeService:
			self.__command = APPService.NATIVE_SRV_CMD % {'name': self.__service_name, 'cmd': 'restart'}
			print os.popen(self.__command, "r").read()
			return
				
		self.__command = APPService.REMOTE_SRV_CMD % {'name': self.__service_name, 'cmd': 'restart'}
		
		client = SSHCommander(self.__server_ip, self.__user_name, self.__login_password)
		
		print "restarting " + self.__service_name + " on " + self.__server_ip
		status, output = client.execute_interactive(self.__command, self.__root_password, self.__timeout)
		
		print output
		if status != 0:
			print "fail to restart " + self.__service_name + " on " + self.__server_ip	
			
	def status(self):
		if self.__isNativeService:
			self.__command = APPService.NATIVE_SRV_CMD % {'name': self.__service_name, 'cmd': 'status'}
			print os.popen(self.__command, "r").read()
			return
		
		self.__command = APPService.REMOTE_SRV_CMD % {'name': self.__service_name, 'cmd': 'status'}
		
		client = SSHCommander(self.__server_ip, self.__user_name, self.__login_password)
		
		print "checking " + self.__service_name + " on " + self.__server_ip
		status, output = client.execute_interactive(self.__command, self.__root_password, self.__timeout)
		
		print output
		if status != 0:
			print "fail to get " + self.__service_name + " status on " + self.__server_ip	

	def waitforServiceUp(self, timeout=0):
		return True

class CMSService(APPService):
	def __init__(self, ipaddr="localhost", user="cms", password="cms1234", rootPasswd="root1234", isNative=False):
		APPService.__init__(self, "cms", ipaddr, user, password, rootPasswd, 90, isNative)
	
	def waitforServiceUp(self, timeout=720):
		while timeout > 0:
			time.sleep(15)
			timeout = timeout - 15
			try:
				url = "https://" + self.getServerIp() + ":8443/portal"
				print "Waiting service [" + url + "] to startup..."
				resp = HttpRequestDecorator.request(url)
				if resp[0]["status"] == '200' or resp[0]["status"] == '302':
					print "cms service on " + self.getServerIp() + " started up"
					return True
			except socket.error:
				pass
		
		print "cms service on " + self.getServerIp() + " is still down"
		return False
		
class TomcatService(APPService):
	def __init__(self, ipaddr="localhost", user="cms", password="cms1234", rootPasswd="root1234", isNative=False):
		APPService.__init__(self, "tomcat", ipaddr, user, password, rootPasswd, isNative=isNative)	

	def waitforServiceUp(self, timeout=270):
		while timeout > 0:
			time.sleep(15)
			timeout = timeout - 15
			try:
				url = "http://" + self.getServerIp() + ":8081/filemanager/services/FileSubsystemWebservice"
				print "Waiting service [" + url + "] to startup..."
				resp = HttpRequestDecorator.request(url , "GET")
				if resp[0]["status"] == '200':
					print "tomcat service on " + self.getServerIp() + " started up"
					return True
			except socket.error:
				pass
		
		print "tomcat service on " + self.getServerIp() + " is still down"
		return False

class WorkflowService(APPService):
	def __init__(self, ipaddr="localhost", user="cms", password="cms1234", rootPasswd="root1234", isNative=False):
		APPService.__init__(self, "workflow", ipaddr, user, password, rootPasswd, 90, isNative)	

	def waitforServiceUp(self, timeout=300):
		while timeout > 0:
			time.sleep(15)
			timeout = timeout - 15
			try:
				url = "http://" + self.getServerIp() + ":7070/workflow/services/AdaptorService"
				print "Waiting service [" + url + "] to startup..."
				resp = HttpRequestDecorator.request(url , "GET")
				if resp[0]["status"] == '200':
					print "workflow service on " + self.getServerIp() + " started up"
					return True
			except socket.error:
				pass
		
		print "workflow service on " + self.getServerIp() + " is still down"
		return False	
		
class FTPService(APPService):
	def __init__(self, ipaddr="localhost", user="cms", password="cms1234", rootPasswd="root1234", isNative=False):
		APPService.__init__(self, "vsftpd", ipaddr, user, password, rootPasswd, isNative=isNative)			

class GenericService(APPService):
	def __init__(self, svcname, ipaddr="localhost", user="cms", password="cms1234", rootPasswd="root1234", isNative=False):
		APPService.__init__(self, svcname, ipaddr, user, password, rootPasswd, isNative=isNative)

def main():
	service = WorkflowService(isNative=True)
	service.stop()
	
	
if __name__ == "__main__":
	main()