#!/usr/bin/env python
import BaseClass
import AlertActions
import Alerts

class AlertNames(BaseClass.BaseClass):
	
	#		 (0,		  1)
	# data = (ALERT_NAME, PATTERN)
	
	def __init__(self):
		BaseClass.BaseClass.__init__(self)
	
	def checkExistence(self, data):
		key = data[0]
		self.cursor.execute("SELECT * FROM ALERT_NAMES WHERE ALERT_NAME='%s'" % key)
		rows = self.cursor.fetchall()
		if len(rows):
			return rows[0][0]
		else:
			return False
		
	def getNextId(self):
		return 1
	
	def insert(self, id_, data):
		"""
		data[0]: ALERT_NAME
		data[1]: PATTERN
		data[2]: ALERTS
		"""
		alertName = data[0]
		alertPattern = data[1]
		
		aas = AlertActions.AlertActions()
		
		try:
			"""
			step.1: insert alert name and pattern
			"""
			statement = "INSERT INTO ALERT_NAMES (ALERT_NAME, PATTERN) VALUES %s" % self.tupleToStr([alertName, alertPattern])
			print statement
			self.cursor.execute(statement)

			return self.commit()
		except Exception, e:
			print e
			return self.rollback()
		
	def update(self, data):
		"""
		data[0]: ALERT_NAME
		data[1]: PATTERN
		data[2]: ALERTS
		"""
		alertName = data[0]
		alertPattern = data[1]
		
		try:
			"""
			step.1: update alert name and pattern
			"""
			statement = "UPDATE ALERT_NAMES SET PATTERN = '%s' WHERE ALERT_NAME='%s'" % (alertPattern, alertName)
			print statement
			self.cursor.execute(statement)
			return self.commit()
		except Exception, e:
			print e
			return self.rollback()
			
		except Exception, e:
			print e
			return self.rollback()
		
	def delete(self, data):
		""" delete the alert and its actions
		data[0]: alert name
		"""
		alertName = data[0]
		
		aas = AlertActions.AlertActions()
		als = Alerts.AlertPolicyForCMS3X()
		
		try: 
			statement = "SELECT IDENTIFIER FROM ALERTS WHERE ALERT_NAME = '%s'" % alertName
			print statement
			self.cursor.execute(statement)	
			alertIds = self.cursor.fetchall()
			
			for a in alertIds:	
				alertId = a[0]
				aas.delete([alertId])
				als.delete([alertId, alertName])
			
			statement = "DELETE FROM ALERT_NAMES WHERE ALERT_NAME='%s'" % alertName
			print statement
			self.cursor.execute(statement)	
			return self.commit()			
			
		except Exception, e:
			print e
			return self.rollback()	
		
	def createAlerts(self, alertName, alerts):		
		als = Alerts.AlertPolicyForCMS3X()
		aas = AlertActions.AlertActions()
		
		for a in alerts:
			als.handle(a["IDENTIFIER"],alertName,a["THRESH_COUNT"], a["THRESH_SECS"], a["FREQ_COUNT"], a["FREQ_SECS"], 'LOG', self.getIsDelete(a))
			try:
				if a["EMAIL"] is not None:
					aas.handle(a["IDENTIFIER"],0,a["EMAIL"],self.getIsDelete(a))
			except KeyError:
				pass
			try:
				if a["SNMP_TRAP"] is not None:
					aas.handle(a["IDENTIFIER"],1,a["SNMP_TRAP"],self.getIsDelete(a))
			except KeyError:
				pass
		
	def getIsDelete(self, item):
		if not item.has_key("IS_DELETE"):
			return False
		else:
			return item["IS_DELETE"].lower() == "true"	
		
	def backUpExisting(self, args):	
		"""
		Input:
			args[0]: ALERT_NAME
		Output:
			A sequence value of ["ALERT_NAME", "PATTERN"]
		"""			
		statement ="SELECT ALERT_NAME, PATTERN FROM ALERT_NAMES WHERE ALERT_NAME='%s'"
		if(len(args)):
			self.cursor.execute(statement % args[0]);
			rows = self.cursor.fetchall()
		return rows[0]
		

def main():
	an = AlertNames()
	an.add("testName", ".*testPattern.*")
	
if __name__ == "__main__":
	main()