#!/usr/bin/env python
import os
import BaseClass
import AlertActions
import shutil
import yaml
import Common
from SSHCommander import SSHCommander

class AlertPolicyForCMS3X(BaseClass.BaseClass):
	def __init__(self):
		BaseClass.BaseClass.__init__(self)
	
	def checkExistence(self, data):
		alertIdentifier = data[0]
		self.cursor.execute("SELECT IDENTIFIER FROM ALERTS WHERE IDENTIFIER='%s'" % (alertIdentifier))
		if len(self.cursor.fetchall()):
			return True
		else:
			return False
		
	def getNextId(self):
		return 1
	
	def insert(self, id_, data):
		try:
			statement = "INSERT INTO ALERTS (IDENTIFIER, ALERT_NAME , THRESH_COUNT, THRESH_SECS, FREQ_COUNT, FREQ_SECS, TYPE)"\
			" VALUES %s" % self.tupleToStr(data[0:7])
			print statement 
			self.cursor.execute(statement)	
			
			aas = AlertActions.AlertActions()
			try:
				"""data[7] is EMAIL"""
				if data[7] is not None:
					aas.insert(None, (data[0],0,data[7]))
			except KeyError:
				pass
			try:
				"""data[8] is SNMP_TRAP"""
				if data[8] is not None:
					aas.insert(None, (data[0],1,data[8]))
			except KeyError:
				pass	
			return self.commit()
		except Exception, e:
			print e
			return self.rollback()
		
	def update(self, data):
		try:
			statement = "UPDATE ALERTS SET ALERT_NAME='%s', THRESH_COUNT='%s', THRESH_SECS='%s', FREQ_COUNT='%s', FREQ_SECS='%s', TYPE='%s' WHERE IDENTIFIER='%s'" \
			% (data[1],data[2],data[3],data[4],data[5],data[6],data[0])
			print statement 
			self.cursor.execute(statement)	
			aas = AlertActions.AlertActions()
			try:
				"""data[7] is EMAIL"""
				if data[7] is not None:
					aas.update((data[0],0,data[7]))
			except KeyError:
				pass
			try:
				"""data[8] is SNMP_TRAP"""
				if data[8] is not None:
					aas.update((data[0],1,data[8]))
			except KeyError:
				pass		
			return self.commit()
		except Exception, e:
			print e
			return self.rollback()
	
	def delete(self, data):
		"""
		data[0]: alert identifier
		data[1]: alert name
		"""
		alertId = data[0]
		alertName = data[1]
		
		aas = AlertActions.AlertActions()
		
		try: 
			aas.delete([alertId])
			
			statement = "DELETE FROM ALERTS WHERE IDENTIFIER = '%s' AND ALERT_NAME='%s'" %(alertId, alertName)
			print statement
			
			self.cursor.execute(statement)			
			return self.commit()
		except Exception, e:
			print e
			return self.rollback()	
		
	def backUpAllExisting(self, args):
		"""
		Input:
			args[0]: ALERT_NAME
		OutPut:
			[{"IDENTIFIER":value, "THRESH_COUNT":value, "THRESH_SECS":value, "FREQ_COUNT":value,"FREQ_SECS":value, "Email":value, "SNMP_TRAP":value}{...}]
		"""	
		alertStatement ="SELECT IDENTIFIER, THRESH_COUNT, THRESH_SECS, FREQ_COUNT, FREQ_SECS FROM ALERTS WHERE ALERT_NAME='%s'"	
		alertActionStatment = "SELECT  ACTION_TYPE, DETAIL FROM ALERT_ACTIONS WHERE IDENTIFIER = '%s'"
		
		fieldArray = ["IDENTIFIER", "THRESH_COUNT", "THRESH_SECS", "FREQ_COUNT","FREQ_SECS"]
		if(args is None or not len(args)):
			return
		item = []
		self.cursor.execute(alertStatement % args[0])
		alertRows = self.cursor.fetchall()
		for alertRow in alertRows:
			alertDict = {}
			"""Set alert fields"""
			for i in range(len(alertRow)):
				if alertRow[i] is None:
					alertDict[fieldArray[i]] = ""
				else:
					alertDict[fieldArray[i]] = alertRow[i]
			
			"""set alert action field"""
			self.cursor.execute(alertActionStatment % alertRow[0])
			alertActionRows = self.cursor.fetchall()
			for alertActionRow in alertActionRows:
				if(alertActionRow[0] == 0):
					"""Email Type"""
					alertDict["Email"] = alertActionRow[1]
				elif (alertActionRow[0] == 1):
					"""SNMP_TRAP Type"""
					alertDict["SNMP_TRAP"] = alertActionRow[1]
			item.append(alertDict)
		return item			
	
	#["IDENTIFIER", "THRESH_COUNT", "THRESH_SECS", "FREQ_COUNT","FREQ_SECS", "SNMP_TRAP","EMAIL"]
	def backUpExisting(self, args):	
		"""
		Input:
			args[0]: IDENTIFIER
		Output:
		 	A squence value of ("IDENTIFIER", "THRESH_COUNT", "THRESH_SECS", "FREQ_COUNT","FREQ_SECS", "SNMP_TRAP","EMAIL")
		"""	
		alertStatement ="SELECT IDENTIFIER, THRESH_COUNT, THRESH_SECS, FREQ_COUNT, FREQ_SECS FROM ALERTS WHERE IDENTIFIER='%s'"
		alertActionStatment = "SELECT  ACTION_TYPE, DETAIL FROM ALERT_ACTIONS WHERE IDENTIFIER = '%s'"
		
		fieldArray = ["IDENTIFIER", "THRESH_COUNT", "THRESH_SECS", "FREQ_COUNT","FREQ_SECS", "SNMP_TRAP","EMAIL"]
		valueArray = []
		"""Initialized return result"""
		for i in range(len(fieldArray)):
			valueArray.append("")
	
		if(args is None or not len(args)):
			return
		self.cursor.execute(alertStatement % args[0])
		alertRows = self.cursor.fetchall()
		"""Set alert name fields"""		
		for i in range(len(alertRows[0])):
			valueArray[i] = alertRows[0][i]
			
		self.cursor.execute(alertActionStatment % args[0])
		alertActionRows = self.cursor.fetchall()
		for alertActionRow in alertActionRows:				
			if alertActionRow[0] == 1: 
				"""SNMP_TRAP type """
				valueArray[fieldArray.index("SNMP_TRAP")] = alertActionRow[1]
			elif(alertActionRow[0] == 0):
				"""EMAIL type"""
				valueArray[fieldArray.index("EMAIL")] = alertActionRow[1]
		return valueArray

class AlertPolicyForCMS4X():
	ALERT_CONF_FILE = '/etc/logstash/alerts.yaml'
	
	def __init__(self, csNodes):
		self._loadConfig(csNodes)

	def _loadConfig(self, csNodes):
		self._hosts = csNodes
		self._localConfig = '/tmp/alerts.%s.yaml' % str(os.getpid())
		
		host01 = self._hosts[0]
		self.syncConfigToLocal(host01['ip'], host01['user'], host01['password'], host01['rootPasswd'])
		with open(self._localConfig, 'r') as f:
			self._allContent = yaml.load( f.read() )
			
		if self._allContent is None:
			self._allContent = []
		#print self._allContent		
	
	def syncConfigToLocal(self, serverip, username, password, rootpwd):
		print "Start to sync alert configuration from %s to LOCAL: " % serverip
		
		inter_filename = os.path.join(Common.Common.COMMON_SHARED_FOLDER, 'alerts.%s.yaml'%serverip.replace(".", ""))
		cmd = None
		try:
			cmd = SSHCommander(serverip, username, password)
			
			remote_cmd = 'su root -c "\cp -f %s %s"' % (AlertPolicyForCMS4X.ALERT_CONF_FILE, inter_filename)
			status, output = cmd.execute_interactive(remote_cmd, rootpwd)
			print output
			if status != 0:
				print "Alert configuration on CS node may do not exist"
				basedir = os.path.dirname(inter_filename)
				if not os.path.exists(basedir):
					os.makedirs(basedir)
				open(inter_filename, 'a').close()
			
			shutil.copyfile(inter_filename, self._localConfig)
		except Exception:
			raise
		finally:
			if cmd:
				cmd.logout()
	
	def syncConfigToRemote(self, serverip, username, password, rootpwd):
		print "Start to sync alert configuration to REMOTE: " + serverip
		
		# Use serverip to distiguish the interchange file
		inter_filename = os.path.join(Common.Common.COMMON_SHARED_FOLDER, 'alerts.%s.yaml'%serverip.replace(".", ""))
		shutil.copyfile(self._localConfig, inter_filename)
		
		cmd = None
		try:
			cmd = SSHCommander(serverip, username, password)
			
			remote_cmd = 'su root -c "/bin/cp -f %s %s;rm -f %s"' % (inter_filename, AlertPolicyForCMS4X.ALERT_CONF_FILE, inter_filename)

			status, output = cmd.execute_interactive(remote_cmd, rootpwd)
			print output
			if status != 0:
				raise Exception("Failed to sync alert configuration to remote: " + serverip)
		except Exception:
			raise
		finally:
			if cmd:
				cmd.logout()
	
	def checkExistence(self, data):
		foundObj = self.getAlertByIdentifier(data['IDENTIFIER'])
		if foundObj != None:
			return True
		else:
			return False
	
	def getAlertByIdentifier(self, idf):
		alertIdentifier = idf
		obj = None
		
		for elem in self._allContent:
			if 'alert' not in elem:
				continue
			
			alert = elem['alert']
			if 'name' in alert and alert['name']==alertIdentifier:
				obj = alert
				break
		
		return obj
	
	def insert(self, data):
		print('Adding alert: ' + str(data))
		freq = {'count': int(data['FREQ_COUNT']), 'time': AlertPolicyForCMS4X.formatSeconds(int(data['FREQ_SECS']))}
		# NOTE: WORK-AROUND:
		#thres = {'count': int(data['THRESH_COUNT']), 'time': AlertPolicyForCMS4X.formatSeconds(int(data['THRESH_SECS']))}
		obj = {}
		obj['name'] = str(data['IDENTIFIER'])
		obj['pattern'] = str(data['PATTERN'])
		obj['frequency'] = freq
		#obj['threshold'] = thres
		if 'SNMP_TRAP' in data and data['SNMP_TRAP']:
			obj['trap'] = int(data['SNMP_TRAP'])
		if 'EMAIL' in data and data['EMAIL']:
			obj['email'] = str(data['EMAIL'])
		
		self._allContent.append({'alert': obj})
		return True
		
	def update(self, data):
		print('Updating alert: ' + str(data))
		obj = self.getAlertByIdentifier(data['IDENTIFIER'])
		if not obj:
			return
		
		obj['pattern'] = str(data['PATTERN'])
		if 'SNMP_TRAP' in data and data['SNMP_TRAP']:
			obj['trap'] = int(data['SNMP_TRAP'])
		if 'EMAIL' in data and data['EMAIL']:
			obj['email'] = str(data['EMAIL'])
		
		freq = {}
		freq['count'] = int(data['FREQ_COUNT'])
		freq['time'] = AlertPolicyForCMS4X.formatSeconds(int(data['FREQ_SECS']))
		obj['frequency'] = freq
		
		# NOTE: WORK-AROUND:
		#thres = {}
		#thres['count'] = int(data['THRESH_COUNT'])
		#thres['time'] = AlertPolicyForCMS4X.formatSeconds(int(data['THRESH_SECS']))
		#obj['threshold'] = thres
	
	def delete(self, data):
		print('Deleting alert: ' + str(data))
		alertIdentifier = data['IDENTIFIER']
		for elem in self._allContent:
			if 'alert' not in elem:
				continue
			
			alert = elem['alert']
			if 'name' in alert and alert['name']==alertIdentifier:
				self._allContent.remove(elem)
				break
	
	def saveToFile(self):
		with open(self._localConfig, 'w') as f:
			yaml.dump(self._allContent, f, default_flow_style=False)
		
		# synchronize configuration to remote CS nodes
		for hst in self._hosts:
			self.syncConfigToRemote(hst['ip'], hst['user'], hst['password'], hst['rootPasswd'])
		#print yaml.dump(self._allContent, default_flow_style=False, indent=2)
	
	@staticmethod
	def formatSeconds(secs):
		hr = secs / 3600
		secs = secs % 3600
		min = secs / 60
		secs = secs % 60
		return '%02d:%02d:%02d'%(hr, min, secs)

class AlertPolicyForCMS5X(AlertPolicyForCMS4X):
	ALERT_CONF_FILE = "/opt/tandbergtv/cms/conf/logstash/alerts.yaml"
	def __init__(self):
		AlertPolicyForCMS4X.__init__(self, None)

	def _loadConfig(self, csNodes):
		self._localConfig = '/tmp/alerts.%s.yaml' % str(os.getpid())
		
		self.syncConfigToLocal(None, None, None, None)
		with open(self._localConfig, 'r') as f:
			self._allContent = yaml.load( f.read() )
			
		if self._allContent is None:
			self._allContent = []
		#print self._allContent	
				
	def syncConfigToLocal(self, serverip, username, password, rootpwd):
		print "Start to copy alert configuration file %s to %s" % (AlertPolicyForCMS5X.ALERT_CONF_FILE, self._localConfig)
		shutil.copyfile(AlertPolicyForCMS5X.ALERT_CONF_FILE, self._localConfig)
		
	def saveToFile(self):
		with open(self._localConfig, 'w') as f:
			yaml.dump(self._allContent, f, default_flow_style=False)
			
		shutil.copyfile(self._localConfig, AlertPolicyForCMS5X.ALERT_CONF_FILE)
		print "Saved alerts to configuration file " + AlertPolicyForCMS5X.ALERT_CONF_FILE
				
def main():
	#a = Alerts()
	#a.add("testidentifier","testName", 1,60,1,60,'LOG')
	a = AlertPolicyForCMS4X([{"ip":"127.0.0.1", "user":"root", "password":"root1234", "rootPasswd":"root1234"}])
	a.insert({'IDENTIFIER':'Ingest Validation Warning','PATTERN':'.*validationMessages.*= Warning:.*',
				'THRESH_COUNT':1, 'THRESH_SECS':60, 'FREQ_COUNT':100, 'FREQ_SECS':1, 'SNMP_TRAP':1123})
	
	a.update({'IDENTIFIER':'EPGManager Translation Alert','PATTERN':'.*validationMessages.*= Warning:.*',
			'THRESH_COUNT':1, 'THRESH_SECS':60, 'FREQ_COUNT':100, 'FREQ_SECS':1, 'SNMP_TRAP':1123})
	
	a.delete({'IDENTIFIER':'EPGManager Validation Rule Abort'})
	a.saveToFile()
	
if __name__ == "__main__":
	main()