#!/usr/bin/env python
import re
import os

from decimal import Decimal
from xml.dom.minidom import parseString
from CMSVersionDeploymentPolicy import CMSVersionDeploymentPolicy

class BaseClass(object):
    isOverride = False

    def __init__(self):
        self.connection = CMSVersionDeploymentPolicy.getPrepackDepolymentPolicy().getDatabaseConnection()
        self.cursor = self.connection.cursor()
        
    def handle(self, *args):
        if type(args[0]) == type(tuple()):
            args = args[0]
                      
        if self.isDelete(args):
            return self.delete(args[0:len(args)-1])
        else:
            if self.checkExistence(args[0:len(args)-1]):
                if self.isOverride:
                    return self.update(args[0:len(args)-1])
                else:
                    return False
            else:
                id_ = self.getNextId()
                return self.insert(id_, args[0:len(args)-1])
    
    def backup(self, *args):
        if type(args[0]) == type(tuple()):
            args = args[0]
#         self.isDelete(args) or 
        if self.checkExistence(args[0:len(args)-1]):
            return (False, self.backUpExisting(args[0:len(args)-1]))
        else:
            return (True, (args[0],))
    
    def isDelete(self, *args):
        if type(args[0]) == type(tuple()):
            args = args[0]
        return args[-1]
    
    def checkExistence(self, *args):
        pass
    
    def insert(self, *args):
        pass
    
    def update(self, *args):
        pass
    
    def generateUpdateSetClause(self, data, columnDataMap):
        setClause = ""
        delimter = ""
        for column in columnDataMap:
            value = data[column["index"]]
            if value is not None:
                mark = "'"
                if column.has_key("notString") and column["notString"]:
                    mark = ""
                setClause = setClause + delimter + column + "=" + mark + value + mark
                delimter = ", "
        return setClause
    
    def delete(self, *args):
        pass        
    
    def backUpExisting(self, *args):
        #Sub class should implement this method, to back up an existing item, it is to be inserted or updated when rolling back. 
        #return an array of eaey column
        pass
    
    def backUpAll(self, *args):
        if type(args[0]) == type(tuple()):
            args = args[0]
        return self.backUpAllExisting(args)
    
    def backUpAllExisting(self, *args):
        pass
    
    def getNextId(self):
        pass
    
    def execute(self, statement):
        self.cursor.execute(statement)
        
    def fetchall(self):
        return self.cursor.fetchall()
    
    def _export(self):
        pass
    
    def export(self, outputFile):
        # print self.selectStatement
        try:
            self.cursor.execute(self.selectStatement)
            rows = self.fetchall()
            
            output = self.columns + "\n"
            for row in rows:
                output += "\t".join(self.noneToNull(row)) + "\n"
        
            print output
            f = file(outputFile, "w")
            f.write(output.strip())
            f.close()
        except Exception, e:
            print e
    
    def importFromFile(self, tdf):
        """
        tdf=Tab Delimited File
        First line, which has the header for the columns, is ignored.
        """
        lines = file(tdf, "r").readlines()[1 : ]
        for line in lines:
            fields = map(lambda s : s.strip(), filter(None, line.split("\t")))
            fields = map(lambda s : ["", s][s != "null"], fields)
            self.add(tuple(fields))
    
    def noneToNull(self, row):
        return map(lambda l : [str(l), "null"][l == None], row)
    
    def commit(self):
        print "Successfully executed.  Committing."
        self.connection.commit()
        return True
    
    def rollback(self):
        print "Failed to execute.  Rolling back."
        self.connection.rollback()
        return False

    def setSelectStatement(self):
        self.selectStatement = "SELECT %s FROM %s" % (self.columns, self.table)
    
    def trim(self, str):
        return str.strip('\n\t ')
        
    def prettyxml(self, dom):
        regex = r'\n|\t'
        uglyXml = parseString(re.sub(regex, "", dom.toxml(encoding="UTF-8"))).toprettyxml(encoding="UTF-8")
        prettyxml = re.sub(r'>\n\t*([^<]+)\n\t*<', r'>\1<', uglyXml)
        prettyxml = re.sub(r'<filter>\n\t*(<.*>)\s*</filter>', r'<filter>\1</filter>', prettyxml)
        return prettyxml
    
    def createFile(self,filePath, content):
        dir = os.path.dirname(filePath)
        if not os.path.exists(dir):
            os.makedirs(dir)
        f = file(filePath, "w")
        f.write(content)
        f.close()
    
    def tupleToStr(self, values):
        arr = []
        for v in values:
            if isinstance(v, basestring):
                arr.append(str(v))
            elif type(v) == type(long()):
                arr.append(int(v))
            elif isinstance(v, Decimal):
                arr.append(int(v))
            else:
                arr.append(v)
        return str(tuple(arr)).replace("None", "NULL").replace("\\\\", "\\")
    
    @staticmethod
    def setOverride():
        BaseClass.isOverride = True
    
    @staticmethod
    def getIsOverride():
        return BaseClass.isOverride
