#!/usr/bin/env python
#
# Copyright (c) 2012 Ericsson, Inc.  All Rights Reserved.
#
# This module contains unpublished, confidential, proprietary
# material.  The use and dissemination of this material are
# governed by a license.  The above copyright notice does not
# evidence any actual or intended publication of this material.
#

from DatabaseConnectionProvider import *

class CMSVersionDeploymentPolicy(object):
    cmsVersion = 4.0
    POLICY = None
    
    @staticmethod
    def setCMSVersion(version):
        if version:
            CMSVersionDeploymentPolicy.cmsVersion = float(version[:3])

    @staticmethod
    def getCMSVersion():
        return CMSVersionDeploymentPolicy.cmsVersion
    
    @staticmethod
    def getPrepackDepolymentPolicy():
        if CMSVersionDeploymentPolicy.POLICY is not None:
            return CMSVersionDeploymentPolicy.POLICY
        
        cmsVersion = CMSVersionDeploymentPolicy.getCMSVersion()
        if cmsVersion == 3.0:
            CMSVersionDeploymentPolicy.POLICY = CMS3_0_DeploymentPolicy()
        elif cmsVersion == 3.1:
            CMSVersionDeploymentPolicy.POLICY = CMS3_1_DeploymentPolicy()
        elif cmsVersion > 3.1 and cmsVersion <= 4.0:
            CMSVersionDeploymentPolicy.POLICY = CMS4_0_DeploymentPolicy()
        elif cmsVersion > 4.0 and cmsVersion < 5.0:
            CMSVersionDeploymentPolicy.POLICY = CMS4_1_DeploymentPolicy()
        elif cmsVersion >=5.0:
            CMSVersionDeploymentPolicy.POLICY = CMS5_0_DeploymentPolicy()
        return CMSVersionDeploymentPolicy.POLICY
        
    @staticmethod
    def getReportInstaller(config = None):
        return CMSVersionDeploymentPolicy.getPrepackDepolymentPolicy().getReportInstaller(config)
                 
    @staticmethod
    def installAndConfigureReports(config):
        installer = CMSVersionDeploymentPolicy.getReportInstaller(config)
        installer.startDepoyReports()       
        
    @staticmethod
    def getReportDeploymentPath():
        installer = CMSVersionDeploymentPolicy.getReportInstaller()
        return installer.getDeploymentPath()
              
    @staticmethod
    def getReportConfigurationFilePath():
        installer = CMSVersionDeploymentPolicy.getReportInstaller()
        return installer.getReportConfigureFilePath()     
    
    @staticmethod
    def getJreportCatalogDataSourceFilePath():
        installer = CMSVersionDeploymentPolicy.getReportInstaller()
        return installer.getJreportCatalogDataSourceFilePath()        

""" 
    Base class to provide different interface for deployment
"""    
class PrepackDeploymentPolicy(object):
    DB_PROVIDER = None
    
    def __init__(self):
        self.ruleSetviceProvider = None
                
    def initDbProvider(self, sid, usr, pwd, host, port):
        pass
        
    def getDatabaseConnection(self):
        return PrepackDeploymentPolicy.DB_PROVIDER.getCurrentConnection()
    
    def cleanDatabaseConnection(self):
        if PrepackDeploymentPolicy.DB_PROVIDER:
            PrepackDeploymentPolicy.DB_PROVIDER.cleanCurrentConnection()
    
    def getRuleServiceProvider(self):
        return self.ruleSetviceProvider
    
    def getReportInstaller(self, config=None):
        pass
    
"""
    Provides deployment implementation for CMS 3.0
"""    
class CMS3_0_DeploymentPolicy(PrepackDeploymentPolicy):   
    
    def __init__(self):
        from RulesetService import CMS3_0_RulesetService
        self.ruleSetviceProvider = CMS3_0_RulesetService()
    
    def initDbProvider(self, sid, usr, pwd, host, port):
        PrepackDeploymentPolicy.DB_PROVIDER = OracleDatabaseConnectionProvider(sid, usr, pwd, host, port)

    def getReportInstaller(self, config=None):
        from PrepackReportInstaller import CMS3_0_PrepackReportInstaller
        return CMS3_0_PrepackReportInstaller(config)
        
    def insertAlerts(self, alerts, stubCmmObj):
        from AlertNames import AlertNames
        from Alerts import AlertPolicyForCMS3X
        ans = AlertNames()
        als = AlertPolicyForCMS3X()
        for alertName in alerts:
            ans.handle(alertName["ALERT_NAME"],alertName["PATTERN"],stubCmmObj.getIsDelete(alertName))
            if(not stubCmmObj.getIsDelete(alertName)):
                for alert in alertName["ALERTS"]:
                    als.handle(alert["IDENTIFIER"],alertName["ALERT_NAME"],alert["THRESH_COUNT"], alert["THRESH_SECS"], 
                       alert["FREQ_COUNT"], alert["FREQ_SECS"], 'LOG',alert["EMAIL"], alert["SNMP_TRAP"],stubCmmObj.getIsDelete(alert))
        
class CMS3_1_DeploymentPolicy(PrepackDeploymentPolicy):
    """
    Provides deployment implementation for CMS 3.1
    """
    
    def __init__(self):
        from RulesetService import CMS3_X_RulesetService
        self.ruleSetviceProvider = CMS3_X_RulesetService()
    
    def initDbProvider(self, sid, usr, pwd, host, port):
        PrepackDeploymentPolicy.DB_PROVIDER = OracleDatabaseConnectionProvider(sid, usr, pwd, host, port)
        
    def getReportInstaller(self, config=None):
        from PrepackReportInstaller import Above_CMS3_0_PrepackReportInstaller
        return Above_CMS3_0_PrepackReportInstaller(config)
        
    def insertAlerts(self, alerts, stubCmmObj):
        from AlertNames import AlertNames
        from Alerts import AlertPolicyForCMS3X
        ans = AlertNames()
        als = AlertPolicyForCMS3X()
        for alertName in alerts:
            ans.handle(alertName["ALERT_NAME"],alertName["PATTERN"],stubCmmObj.getIsDelete(alertName))
            if(not stubCmmObj.getIsDelete(alertName)):
                for alert in alertName["ALERTS"]:
                    als.handle(alert["IDENTIFIER"],alertName["ALERT_NAME"],alert["THRESH_COUNT"], alert["THRESH_SECS"], 
                       alert["FREQ_COUNT"], alert["FREQ_SECS"], 'LOG',alert["EMAIL"], alert["SNMP_TRAP"],stubCmmObj.getIsDelete(alert))
    
class CMS4_0_DeploymentPolicy(PrepackDeploymentPolicy):   
    """
    Provides deployment implementation for CMS 4.0
    """
    
    def __init__(self):
        from RulesetService import CMS4_X_RulesetService
        self.ruleSetviceProvider = CMS4_X_RulesetService()
    
    def initDbProvider(self, sid, usr, pwd, host, port):
        PrepackDeploymentPolicy.DB_PROVIDER = EDBDatabaseConnectionProvider(sid, usr, pwd, host, port)

    def getReportInstaller(self, config=None):
        from PrepackReportInstaller import CMS4_0_PrepackReportInstaller
        return CMS4_0_PrepackReportInstaller(config)
        
    def insertAlerts(self, alerts, stubCmmObj):
        from BaseClass import BaseClass
        from Alerts import AlertPolicyForCMS4X
        csnodes = stubCmmObj.getConfig("cluster_service_nodes")
        als = AlertPolicyForCMS4X(csnodes)
        #als = Alerts.Alerts()
        for rec in alerts:
            alert = rec["ALERTS"][0]
            '''
            alert.handle(alert["IDENTIFIER"],rec["ALERT_NAME"],alert["THRESH_COUNT"], alert["THRESH_SECS"],
                       alert["FREQ_COUNT"], alert["FREQ_SECS"], None, alert["EMAIL"], alert["SNMP_TRAP"],
                       rec["PATTERN"],self.getIsDelete(alert))
            '''
            if stubCmmObj.getIsDelete(rec):
                als.delete({"IDENTIFIER": alert["IDENTIFIER"]})
            elif als.getAlertByIdentifier(alert["IDENTIFIER"]):
                if BaseClass.getIsOverride():
                    als.update({'IDENTIFIER': alert["IDENTIFIER"], 'PATTERN': rec["PATTERN"], 'THRESH_COUNT': alert["THRESH_COUNT"],
                            'THRESH_SECS': alert["THRESH_SECS"], 'FREQ_COUNT': alert["FREQ_COUNT"], 'FREQ_SECS': alert["FREQ_SECS"],
                            'EMAIL': alert["EMAIL"], 'SNMP_TRAP': alert["SNMP_TRAP"]})
            else:
                als.insert({'IDENTIFIER': alert["IDENTIFIER"], 'PATTERN': rec["PATTERN"], 'THRESH_COUNT': alert["THRESH_COUNT"],
                            'THRESH_SECS': alert["THRESH_SECS"], 'FREQ_COUNT': alert["FREQ_COUNT"], 'FREQ_SECS': alert["FREQ_SECS"],
                            'EMAIL': alert["EMAIL"], 'SNMP_TRAP': alert["SNMP_TRAP"]})
        
        als.saveToFile()
        
class CMS4_1_DeploymentPolicy(CMS4_0_DeploymentPolicy): 
    
    def __init__(self):
        CMS4_0_DeploymentPolicy.__init__(self)
    
    def getReportInstaller(self, config=None):
        from PrepackReportInstaller import CMS4_1_PrepackReportInstaller
        return CMS4_1_PrepackReportInstaller(config)
        
        
class CMS5_0_DeploymentPolicy(CMS4_1_DeploymentPolicy): 
    
    def __init__(self):
        CMS4_1_DeploymentPolicy.__init__(self)
        from RulesetService import CMS5_X_RulesetService
        self.ruleSetviceProvider = CMS5_X_RulesetService()

    def insertAlerts(self, alerts, stubCmmObj):
        from BaseClass import BaseClass
        from Alerts import AlertPolicyForCMS5X
        als = AlertPolicyForCMS5X()
        #als = Alerts.Alerts()
        for rec in alerts:
            alert = rec["ALERTS"][0]
            '''
            alert.handle(alert["IDENTIFIER"],rec["ALERT_NAME"],alert["THRESH_COUNT"], alert["THRESH_SECS"],
                       alert["FREQ_COUNT"], alert["FREQ_SECS"], None, alert["EMAIL"], alert["SNMP_TRAP"],
                       rec["PATTERN"],self.getIsDelete(alert))
            '''
            if stubCmmObj.getIsDelete(rec):
                als.delete({"IDENTIFIER": alert["IDENTIFIER"]})
            elif als.getAlertByIdentifier(alert["IDENTIFIER"]):
                if BaseClass.getIsOverride():
                    als.update({'IDENTIFIER': alert["IDENTIFIER"], 'PATTERN': rec["PATTERN"], 'THRESH_COUNT': alert["THRESH_COUNT"],
                            'THRESH_SECS': alert["THRESH_SECS"], 'FREQ_COUNT': alert["FREQ_COUNT"], 'FREQ_SECS': alert["FREQ_SECS"],
                            'EMAIL': alert["EMAIL"], 'SNMP_TRAP': alert["SNMP_TRAP"]})
            else:
                als.insert({'IDENTIFIER': alert["IDENTIFIER"], 'PATTERN': rec["PATTERN"], 'THRESH_COUNT': alert["THRESH_COUNT"],
                            'THRESH_SECS': alert["THRESH_SECS"], 'FREQ_COUNT': alert["FREQ_COUNT"], 'FREQ_SECS': alert["FREQ_SECS"],
                            'EMAIL': alert["EMAIL"], 'SNMP_TRAP': alert["SNMP_TRAP"]})
        
        als.saveToFile()               
    
def main():
    CMSVersionDeploymentPolicy.setCMSVersion("4.0.0")
    policy = CMSVersionDeploymentPolicy.getPrepackDepolymentPolicy()
    policy.getDatabaseConnection()
    print type(policy).__name__
        
if __name__ == "__main__":
    main()        
    
        